% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xform.R
\name{xform}
\alias{qform<-}
\alias{sform<-}
\alias{xform}
\title{Obtain or replace the ``xform'' transforms for an image}
\usage{
xform(image, useQuaternionFirst = TRUE)

qform(x) <- value

sform(x) <- value
}
\arguments{
\item{image, x}{An image, in any acceptable form (see
\code{\link{retrieveNifti}}).}

\item{useQuaternionFirst}{A single logical value. If \code{TRUE}, the
``qform'' matrix will be used first, if it is defined; otherwise the
``sform'' matrix will take priority.}

\item{value}{A new 4x4 qform or sform matrix. If the matrix has a
\code{"code"} attribute, the appropriate qform or sform code is also set.}
}
\value{
A affine matrix corresponding to the ``qform'' or ``sform''
  information in the image header. This is a plain matrix, which does not
  have the \code{"affine"} class or \code{source} and \code{target}
  attributes.
}
\description{
These functions convert the ``qform'' or ``sform'' information in a NIfTI
header to or from a corresponding affine matrix. These two ``xform''
mechanisms are defined by the NIfTI standard, and may both be in use in a
particular image header.
}
\note{
The qform and sform replacement functions are for advanced users only.
  Modifying the transforms without knowing what you're doing is usually
  unwise, as you can make the image object inconsistent.
}
\author{
Jon Clayden <code@clayden.org>
}
\references{
The NIfTI-1 standard (\url{http://nifti.nimh.nih.gov/nifti-1})
  is the definitive reference on ``xform'' conventions.
}

