% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/endNode.R
\name{endNode}
\alias{endNode}
\title{Retrieve Nodes from Relationships or Paths}
\usage{
endNode(object)
}
\arguments{
\item{object}{A relationship or path object.}
}
\value{
A node object.
}
\description{
Retrieve the end node from a relationship or path object.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

alice = createNode(graph, "Person", name = "Alice")
bob = createNode(graph, "Person", name = "Bob")

rel = createRel(alice, "WORKS_WITH", bob)

endNode(rel)

query = "
MATCH p = (a:Person)-[:WORKS_WITH]->(b:Person)
WHERE a.name = 'Alice' AND b.name = 'Bob'
RETURN p
"

path = cypherToList(graph, query)[[1]]$p

endNode(path)
}
}
\seealso{
\code{\link{startNode}}
}

