% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dropIndex.R
\name{dropIndex}
\alias{dropIndex}
\title{Indexes}
\usage{
dropIndex(graph, label = character(), key = character(), all = FALSE)
}
\arguments{
\item{graph}{A graph object.}

\item{label}{A character string.}

\item{key}{A character string.}

\item{all}{A logical constant. If \code{TRUE}, drop all indexes from the graph.}
}
\description{
Drop the index(es) for a given node label and property key or for the entire graph database.
}
\details{
Dropping a uniqueness constraint necessarily drops the index as well.
It is unnecessary to use \code{dropIndex} if \code{dropConstraint} has already been
applied to the same \code{(label, key)} pair.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

addIndex(graph, "Person", "status")
getIndex(graph)

dropIndex(graph, "Person", "status")
getIndex(graph)
}
}
\seealso{
\code{\link{addIndex}}, \code{\link{getIndex}}
}

