# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Correlation
#' 
#' Calculates the correlation between two vectors.
#' 
#' @param A First matrix.
#' @param B Second matrix.
#' @param cor Return correlation matrix?
#' @return Numeric matrix. 
cov <- function(A, B, cor = FALSE) {
    .Call('_RNOmni_cov', PACKAGE = 'RNOmni', A, B, cor)
}

#' Matrix Inner Product
#'
#' Calculates the inner product \eqn{A'B}.
#'
#' @param A Numeric matrix.
#' @param B Numeric matrix.
#' @return Numeric matrix. 
matIP <- function(A, B) {
    .Call('_RNOmni_matIP', PACKAGE = 'RNOmni', A, B)
}

#' Matrix Inverse
#'
#' Calcualtes \eqn{A^{-1}}.
#' 
#' @param A Numeric matrix.
#' @return A numeric matrix. 
matInv <- function(A) {
    .Call('_RNOmni_matInv', PACKAGE = 'RNOmni', A)
}

#' Schur complement
#'
#' Calculates the efficient information \eqn{I_{bb}-I_{ba}I_{aa}^{-1}I_{ab}}. 
#'
#' @param Ibb Information of target parameter
#' @param Iaa Information of nuisance parameter
#' @param Iba Cross information between target and nuisance parameters
#' @return Numeric matrix. 
SchurC <- function(Ibb, Iaa, Iba) {
    .Call('_RNOmni_SchurC', PACKAGE = 'RNOmni', Ibb, Iaa, Iba)
}

#' Univariate OLS model.
#' 
#' Fits the standard OLS model.
#' 
#' @param y Numeric vector.
#' @param X Numeric matrix.
#' 
#' @return List containing the following:
#' \item{Beta}{Regression coefficient.}
#' \item{V}{Outcome variance.}
#' \item{Ibb}{Information matrix for beta.}
#' \item{Resid}{Outcome residuals.}
#' 
fitOLS <- function(y, X) {
    .Call('_RNOmni_fitOLS', PACKAGE = 'RNOmni', y, X)
}

