% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IndirectMethod.R
\name{IINT}
\alias{IINT}
\title{Indirect-INT}
\usage{
IINT(y, G, X, S, k = 3/8, parallel = F, check = T)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Obs by snp genotype matrix.}

\item{X}{Model matrix of covariates.}

\item{S}{Model matrix of structure adjustments.}

\item{k}{Offset applied during rank-normalization. See
\code{\link{rankNormal}}.}

\item{parallel}{Logical indicating whether to run in parallel. Must register
parallel backend first.}

\item{check}{Logical indicating whether to check the input.}
}
\value{
A numeric matrix of Wald statistics and p-values, one for each locus
  (column) in \code{G}, assessing the null hypothesis that genotype is
  unrelated to the phenotype.
}
\description{
Two-stage regression procedure. In the first stage, phenotype is regressed on
covariates and structure adjustments to obtain residuals. Genotype is also regressed
on covariates and structure adjustments to obtain residuals. In the second stage,
INT-transformed phenotypic residuals are regressed on genotypic residuals.
}
\examples{
# IINT against normal phenotype 
p = RNOmni::IINT(y=RNOmni::Y[,1],G=RNOmni::G[,1:10],X=RNOmni::X,S=RNOmni::S);
}
