% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasicTest.R
\name{BAT}
\alias{BAT}
\title{Basic Association Test}
\usage{
BAT(y, G, X, S, parallel = F, check = T)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Obs by snp genotype matrix.}

\item{X}{Model matrix of covariates.}

\item{S}{Model matrix of structure adjustments.}

\item{parallel}{Logical indicating whether to run in parallel. Must register
parallel backend first.}

\item{check}{Logical indicating whether to check input formatting.}
}
\value{
A numeric matrix of score statistics and p-values, one for each locus
  (column) in \code{G}, assessing the null hypothesis that genotype is
  unrelated to the phenotype.
}
\description{
Test of association between genotype and the untransformed phenotype, 
adjusting for covariates and population structure.
}
\examples{
# BAT against normal phenotype
p = RNOmni::BAT(y=RNOmni::Y[,1],G=RNOmni::G[,1:10],X=RNOmni::X,S=RNOmni::S);
}
