% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankNormal.R
\name{IINT0}
\alias{IINT0}
\title{Indirect-INT, Without Secondary Adjustment}
\usage{
IINT0(y, G, X, S, calcP = T, k = 3/8, parallel = F, check = T)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Obs by snp genotype matrix.}

\item{X}{Model matrix of covariates.}

\item{S}{Model matrix of structure adjustments.}

\item{calcP}{Logical indicating that p values should be calculated.}

\item{k}{Offset applied during rank-normalization. See
\code{\link{rankNormal}}.}

\item{parallel}{Logical indicating whether to run in parallel. Must register
parallel backend first.}

\item{check}{Logical indicating whether to check the input.}
}
\value{
A numeric matrix of Wald statistics, one for each locus in \code{G},
  assessing the null hypothesis that genotype is unrelated to the outcome. If
  \code{calcP=T}, a p-value is additionally calculated for each locus.
}
\description{
Two-stage regression procedure. In the first stage, phenotype is regressed on
covariates and structure adjustments to obtain residuals. In the second stage,
INT-transformed residuals are regressed on genotype only.
}
\details{
Note that, in simulations, this approach did not consistently 
control the type I error. For a similar approach that did provide valid 
inference, see \code{\link{IINT}}.
}
\examples{
# IINT0 against normal phenotype 
p = RNOmni::IINT0(y=RNOmni::Y[,1],G=RNOmni::G[,1:10],X=RNOmni::X,S=RNOmni::S);
}
