/*
 * Decompiled with CFR 0.152.
 */
package de.hzi.infg.utilities;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TidyXml
extends DefaultHandler {
    private boolean entry;
    private Document newDoc;
    private Stack<Element> docStack;
    private String entryString = "";

    public TidyXml(String xml) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory spFactory = SAXParserFactory.newInstance();
        SAXParser parser = spFactory.newSAXParser();
        parser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)this);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        docBuilder.parse(new InputSource(new StringReader(xml)));
    }

    @Override
    public void startDocument() throws SAXException {
        this.docStack = new Stack();
        this.docStack.push(null);
        try {
            DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = df.newDocumentBuilder();
            this.newDoc = db.newDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element currEl = this.newDoc.createElement(qName);
        int i = 0;
        while (i < attributes.getLength()) {
            currEl.setAttribute(attributes.getQName(i), attributes.getValue(i));
            ++i;
        }
        this.docStack.push(currEl);
        if (qName.equalsIgnoreCase("entry")) {
            this.entry = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean dontSetEntryString = false;
        Element currEl = this.docStack.pop();
        Element parentEl = this.docStack.peek();
        if (this.entry && qName.equalsIgnoreCase("entry")) {
            if (this.entryString.equalsIgnoreCase("empty")) {
                dontSetEntryString = true;
            }
            currEl.setTextContent(this.entryString);
            this.entryString = "";
            this.entry = false;
        }
        if (!dontSetEntryString) {
            if (parentEl != null) {
                parentEl.appendChild(currEl);
            } else {
                this.newDoc.appendChild(currEl);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.entry) {
            this.entryString = String.valueOf(this.entryString) + new String(ch, start, length);
        }
    }

    public String getTidyXml() {
        String xmlString = "";
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer trans = tf.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(this.newDoc);
            trans.transform(source, result);
            xmlString = sw.toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return xmlString;
    }
}

