/*
 * Decompiled with CFR 0.152.
 */
package de.hzi.infg;

import de.hzi.infg.exceptions.ErrorFromWebserviceExeption;
import de.hzi.infg.exceptions.NoResultSoFarException;
import de.hzi.infg.exceptions.ParameterNotFoundException;
import de.hzi.infg.interfaces.RequestInterface;
import de.hzi.infg.utilities.Utils;
import gov.nih.nlm.ncbi.www.soap.eutils.EUtilsServiceStub;
import gov.nih.nlm.ncbi.www.soap.eutils.egquery.EGQueryResultType;
import gov.nih.nlm.ncbi.www.soap.eutils.egquery.EGqueryRequest;
import gov.nih.nlm.ncbi.www.soap.eutils.egquery.Result;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class RequestEGQuery
implements RequestInterface {
    private EGqueryRequest request;
    private Result result;
    private EGQueryResultType resultType;
    private static final String resultItemName = "resultitem";

    public RequestEGQuery(Map<String, String> arguments, EUtilsServiceStub service) throws ErrorFromWebserviceExeption, RemoteException {
        this.request = new EGqueryRequest(arguments.keySet());
        Utils.setParameterToRequest(this.request, arguments);
        this.result = service.run_eGquery(this.request);
        service.cleanup();
        this.resultType = this.result.getEGQueryResult();
        if (this.result.getEGQueryResult().getERROR() != null) {
            throw new ErrorFromWebserviceExeption("The request produced an error: " + this.result.getEGQueryResult().getERROR());
        }
    }

    @Override
    public String[] getParameter() {
        ArrayList<String> tmpList = new ArrayList<String>();
        tmpList.add("term");
        tmpList.add("false");
        tmpList.add(resultItemName);
        tmpList.add("true");
        return tmpList.toArray(new String[tmpList.size()]);
    }

    @Override
    public String[] getParameterByName(String parameter) throws ParameterNotFoundException {
        if (!parameter.equalsIgnoreCase(resultItemName)) {
            throw new ParameterNotFoundException("The parameter \"" + parameter + "\" has no further parameters to get.");
        }
        Map tmpMap = this.resultType.getResultItem()[0].getParametersMap();
        Set tmpKeySet = tmpMap.keySet();
        return tmpKeySet.toArray(new String[tmpKeySet.size()]);
    }

    @Override
    public Map<String, Object> getResultMap() throws NoResultSoFarException {
        if (this.result == null) {
            throw new NoResultSoFarException("There are no results to get.");
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("term", this.result.getTerm());
        returnMap.put(resultItemName, this.resultType.getResultItem());
        return returnMap;
    }

    @Override
    public String[] getComplexType(String name) throws ParameterNotFoundException {
        if (!name.equalsIgnoreCase(resultItemName)) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not part of this result or is no complex type.");
        }
        ArrayList<String> listToReturn = new ArrayList<String>();
        String firstEntry = resultItemName;
        String values = "";
        Stack<String> ss = new Stack<String>();
        ss.push(resultItemName);
        values = Utils.recStructureBuild(values, this.resultType.getResultItem(), new Stack<String>(), ss, false, 0);
        if (values.startsWith("{bw}")) {
            values = values.substring("{bw}".length(), values.length());
        } else if (values.startsWith("{ss}")) {
            values = values.substring("{ss}".length(), values.length());
        }
        listToReturn.add(values);
        listToReturn.add(0, firstEntry);
        return listToReturn.toArray(new String[listToReturn.size()]);
    }

    @Override
    public String getSimpleType(String name) throws ParameterNotFoundException {
        if (name.equalsIgnoreCase("term")) {
            return this.result.getTerm();
        }
        throw new ParameterNotFoundException("The parameter \"" + name + "\" is not part of this result.");
    }
}

