% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{GLMnetToGraph}
\alias{GLMnetToGraph}
\title{Convert the result of imputedGLMnetwork into a network.}
\usage{
GLMnetToGraph(object, threshold)
}
\arguments{
\item{object}{an object of class \code{HDpath} as obtained from the function
\code{\link{imputedGLMnetwork}}}

\item{threshold}{the percentage of times, among the m imputed networks, that
an edge has to be predicted to be in the final network}
}
\value{
an 'igraph' object. See \code{\link[igraph]{igraph}}
}
\description{
\code{GLMnetToGraph} combines the m inferred networks, obtained from m
imputed datasets, into a single stable network
}
\examples{
data(lung)
data(thyroid)
nobs <- nrow(lung)
miss_ind <- sample(1:nobs, round(0.2 * nobs), replace = FALSE)
lung[miss_ind, ] <- NA
lung <- na.omit(lung)
lambdas <- 4 * 10^(seq(0, -2, length = 10))
\dontrun{
lung_hdmi <- imputedGLMnetwork(lung, thyroid, sigma = 2, lambdas = lambdas,
                               m = 10, B = 5)
lung_net <- GLMnetToGraph(lung_hdmi, 0.75)
lung_net
plot(lung_net)
}

}
\author{
{Alyssa Imbert, \email{alyssa.imbert@inra.fr}

Nathalie Villa-Vialaneix, \email{nathalie.villa-vialaneix@inra.fr}}
}
\references{
{Imbert, A., Le Gall, C., Armenise, C., Lefebvre, G., Hager, J.,
Valsesia, A., Gourraud, P.A., Viguerie, N. and Villa-Vialaneix, N. (2017)
Multiple hot-deck imputation for network inference from RNA sequencing data.
\emph{Preprint}.}
}
\seealso{
\code{\link{imputedGLMnetwork}}, \code{\link[igraph]{igraph}}
}

