print.retention <- function(
  x,                # <retention> object. Could be generated by e.g. mixpanelGetRetention.
  percentages=TRUE, # Output as counts or percentages? Default TRUE.
  silent=FALSE,     # Silent?
  ...               # Unused.
) {
  if(percentages)
    tab = cbind(Count=x$cohortCount, x$retainPerc)
  else
    tab = cbind(Count=x$cohortCount, x$retainCount)
  
  if(!silent) {
    cat("Retention Matrix\n")
    cat("Row names are Cohort Start Dates. Column names are Periods (0 -> 0 to 1 units)\n")
    print(tab)
  }
  
  invisible(tab)
}


