% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbAppendTable_MariaDBConnection.R,
%   R/dbExistsTable_MariaDBConnection_character.R,
%   R/dbListObjects_MariaDBConnection_ANY.R, R/dbListTables_MariaDBConnection.R,
%   R/dbReadTable_MariaDBConnection_character.R,
%   R/dbRemoveTable_MariaDBConnection_character.R,
%   R/dbWriteTable_MariaDBConnection_character_character.R,
%   R/dbWriteTable_MariaDBConnection_character_data.frame.R, R/table.R
\name{mariadb-tables}
\alias{mariadb-tables}
\alias{dbAppendTable_MariaDBConnection}
\alias{dbAppendTable,MariaDBConnection-method}
\alias{dbExistsTable_MariaDBConnection_character}
\alias{dbExistsTable,MariaDBConnection,character-method}
\alias{dbListObjects_MariaDBConnection_ANY}
\alias{dbListObjects,MariaDBConnection-method}
\alias{dbListTables_MariaDBConnection}
\alias{dbListTables,MariaDBConnection-method}
\alias{dbReadTable_MariaDBConnection_character}
\alias{dbReadTable,MariaDBConnection,character-method}
\alias{dbRemoveTable_MariaDBConnection_character}
\alias{dbRemoveTable,MariaDBConnection,character-method}
\alias{dbWriteTable_MariaDBConnection_character_character}
\alias{dbWriteTable,MariaDBConnection,character,character-method}
\alias{dbWriteTable_MariaDBConnection_character_data.frame}
\alias{dbWriteTable,MariaDBConnection,character,data.frame-method}
\title{Read and write MariaDB tables.}
\usage{
\S4method{dbAppendTable}{MariaDBConnection}(conn, name, value, ..., row.names = NULL)

\S4method{dbExistsTable}{MariaDBConnection,character}(conn, name, ...)

\S4method{dbListObjects}{MariaDBConnection}(conn, prefix = NULL, ...)

\S4method{dbListTables}{MariaDBConnection}(conn, ...)

\S4method{dbReadTable}{MariaDBConnection,character}(conn, name, ..., row.names = FALSE, check.names = TRUE)

\S4method{dbRemoveTable}{MariaDBConnection,character}(conn, name, ..., temporary = FALSE, fail_if_missing = TRUE)

\S4method{dbWriteTable}{MariaDBConnection,character,character}(
  conn,
  name,
  value,
  field.types = NULL,
  overwrite = FALSE,
  append = FALSE,
  header = TRUE,
  row.names = FALSE,
  nrows = 50,
  sep = ",",
  eol = "\\n",
  skip = 0,
  quote = "\\"",
  temporary = FALSE,
  ...
)

\S4method{dbWriteTable}{MariaDBConnection,character,data.frame}(
  conn,
  name,
  value,
  field.types = NULL,
  row.names = FALSE,
  overwrite = FALSE,
  append = FALSE,
  ...,
  temporary = FALSE
)
}
\arguments{
\item{conn}{a \linkS4class{MariaDBConnection} object, produced by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{name}{a character string specifying a table name.}

\item{value}{A data frame.}

\item{...}{Unused, needed for compatibility with generic.}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

If \code{TRUE}, always translate row names to a column called "row_names".
If \code{FALSE}, never translate row names. If \code{NA}, translate
rownames only if they're a character vector.

A string is equivalent to \code{TRUE}, but allows you to override the
default name.

For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}

\item{prefix}{A fully qualified path in the database's namespace, or \code{NULL}.
This argument will be processed with \code{\link[DBI:dbUnquoteIdentifier]{dbUnquoteIdentifier()}}.
If given the method will return all objects accessible through this prefix.}

\item{check.names}{If \code{TRUE}, the default, column names will be
converted to valid R identifiers.}

\item{temporary}{If \code{TRUE}, creates a temporary table that expires
when the connection is closed. For \code{dbRemoveTable()}, only temporary
tables are considered if this argument is set to \code{TRUE}.}

\item{fail_if_missing}{If \code{FALSE}, \code{dbRemoveTable()} succeeds if the
table doesn't exist.}

\item{field.types}{Optional, overrides default choices of field types,
derived from the classes of the columns in the data frame.}

\item{overwrite}{a logical specifying whether to overwrite an existing table
or not. Its default is \code{FALSE}.}

\item{append}{a logical specifying whether to append to an existing table
in the DBMS.  If appending, then the table (or temporary table)
must exist, otherwise an error is reported. Its default is \code{FALSE}.}

\item{header}{logical, does the input file have a header line? Default is the
same heuristic used by \code{read.table()}, i.e., \code{TRUE} if the first
line has one fewer column that the second line.}

\item{nrows}{number of lines to rows to import using \code{read.table} from
the input file to create the proper table definition. Default is 50.}

\item{sep}{field separator character}

\item{eol}{End-of-line separator}

\item{skip}{number of lines to skip before reading data in the input file.}

\item{quote}{the quote character used in the input file (defaults to
\verb{\\"}.)}
}
\value{
A data.frame in the case of \code{dbReadTable()}; otherwise a logical
indicating whether the operation was successful.
}
\description{
These methods read or write entire tables from a MariaDB database.
}
\details{
When using \code{load_data_local_infile = TRUE} in \code{\link[=dbConnect]{dbConnect()}},
pass \code{safe = FALSE} to \code{dbAppendTable()} to avoid transactions.
Because \verb{LOAD DATA INFILE} is used internally, this means that
rows violating primary key constraints are now silently ignored.
}
\note{
The data.frame returned by \code{dbReadTable()} only has
primitive data, e.g., it does not coerce character data to factors.
Temporary tables are ignored for \code{dbExistsTable()} and \code{dbListTables()} due to
limitations of the underlying C API. For this reason, a prior existence check
is performed only before creating a regular persistent table; an attempt to
create a temporary table with an already existing name will fail with a
message from the database driver.
}
\examples{
if (mariadbHasDefault()) {
  con <- dbConnect(RMariaDB::MariaDB(), dbname = "test")

  # By default, row names are written in a column to row_names, and
  # automatically read back into the row.names()
  dbWriteTable(con, "mtcars", mtcars[1:5, ], temporary = TRUE)
  dbReadTable(con, "mtcars")
  dbReadTable(con, "mtcars", row.names = FALSE)
}
}
