% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_get_groups}
\alias{mvl_get_groups}
\title{Retrieve indices belonging to one or more groups}
\usage{
mvl_get_groups(prev, first_indices)
}
\arguments{
\item{prev}{MVL_OBJECT \code{prev} computed by \code{mvl_write_groups}}

\item{first_indices}{indices from \code{first} vector computed by \code{mvl_write_groups}}
}
\value{
a vector of indices
}
\description{
This function is passed the \code{prev} vector computed by \code{mvl_write_groups} and one or more indices from the \code{first} vector.
}
\examples{
\dontrun{
Mtmp<-mvl_open("tmp_a.mvl", append=TRUE, create=TRUE)
mvl_write_object(Mtmp, data.frame(x=runif(100), y=1:100), "df1")
Mtmp<-mvl_remap(Mtmp)
mvl_write_groups(Mtmp, list(Mtmp$df1[,"x",ref=TRUE], Mtmp$df1[,"y", ref=TRUE]), "df1_groups")
Mtmp<-mvl_remap(Mtmp)
print(mvl_get_groups(Mtmp["df1_groups", ref=TRUE]["prev", ref=TRUE], Mtmp$df1_groups$first[1:5]))
}
}
\seealso{
\code{\link{mvl_group}}
}
