% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_group_lapply}
\alias{mvl_group_lapply}
\title{Apply function to index stretches}
\usage{
mvl_group_lapply(G, fn)
}
\arguments{
\item{G}{a list of groups and group stretches produced by \code{mvl_group}}

\item{fn}{a function of one argument - list of indices}
}
\value{
a list of results of function \code{fn}
}
\description{
Iteratively call function \code{fn(idx)} over index stretches previously computed with \code{mvl_group}
}
\examples{
\dontrun{
Mtmp<-mvl_open("tmp_a.mvl", append=TRUE, create=TRUE)
mvl_write_object(Mtmp, data.frame(x=rep(c("a", "b"), 50), y=(1:100)/5), "df1")
Mtmp<-mvl_remap(Mtmp)
df1<-Mtmp$df1
G<-mvl_group(list(df1[,"x",ref=TRUE], df1[,"y", ref=TRUE]))
mvl_group_lapply(G, function(idx) { return(sum(df1[idx, "y"]))})
}
}
\seealso{
\code{\link{mvl_group}}
}
