% Generated by roxygen2 (4.0.2): do not edit by hand
\name{NewVAReventRealization}
\alias{NewVAReventRealization}
\title{Generates a new realization of a VAR model}
\usage{
NewVAReventRealization(var, xprev, noise, exogen = NULL, B = NULL)
}
\arguments{
\item{var}{A VAR model represented by a \code{varest} object as returned by \code{\link{getVARmodel}} or \code{\link{VAR}}}

\item{xprev}{previous status of the random variable}

\item{noise}{uncorrelated or white noise (residual). Default is \code{rnorm(length(xprev))} (or \code{rnorm(ncol(B)})}

\item{exogen}{vector containing the values of the "exogen" variables (predictor) for the generation}

\item{B}{matrix of coefficients for the vectorial white-noise component}
}
\value{
a vector of values
}
\description{
Generates a new realization of a VAR model
}
\author{
Emanuele Cordano, Emanuele Eccel
}
\seealso{
\code{\link{forecastEV}},\code{\link{forecastResidual}}
}

