/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import com.hp.hpl.jena.iri.ViolationCodes;
import com.hp.hpl.jena.iri.impl.ErrorAction;
import com.hp.hpl.jena.iri.impl.GroupAction;
import com.hp.hpl.jena.iri.impl.HostAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComponentPatternParser
implements ViolationCodes {
    static String separators = "([(](?![?]))|([(][?])|([)])|(\\[)|(\\])|([@][{])|([}]|[a-z]-[a-z])";
    static final int OPEN_PAREN = 1;
    static final int OPEN_NON_CAPTURING_PAREN = 2;
    static final int CLOSE_PAREN = 3;
    static final int OPEN_SQ = 4;
    static final int CLOSE_SQ = 5;
    static final int OPEN_VAR = 6;
    static final int CLOSE_BRACE = 7;
    static final int LOWER_CASE_RANGE = 8;
    static final int OTHER = -1;
    static final Pattern keyword = Pattern.compile(separators);
    static final Pattern splitter = Pattern.compile("(?=" + separators + ")|(?<=" + separators + ")");
    final String[] split;
    final int[] classify;
    int field;
    int groupCount;
    final StringBuffer rslt = new StringBuffer();
    int shouldLowerCase;
    int mustLowerCase;
    int hostNames;
    final Pattern pattern;

    public ComponentPatternParser(String p) {
        this.split = splitter.split(p);
        this.field = 0;
        this.classify = new int[this.split.length];
        int i = 0;
        while (i < this.split.length) {
            this.classify[i] = this.classify(this.split[i]);
            ++i;
        }
        while (this.field < this.split.length) {
            this.next();
        }
        this.pattern = Pattern.compile(this.rslt.toString());
    }

    public Pattern get() {
        return this.pattern;
    }

    GroupAction[] actions() {
        int gCount = this.pattern.matcher("").groupCount() + 1;
        GroupAction[] result = new GroupAction[gCount];
        int i = 1;
        while (i < gCount) {
            int g = 1 << i;
            result[i] = (this.mustLowerCase & g) != 0 ? new ErrorAction(60) : ((this.shouldLowerCase & g) != 0 ? new ErrorAction(61) : ((this.hostNames & g) != 0 ? new HostAction(i) : GroupAction.NoAction));
            ++i;
        }
        return result;
    }

    private int classify(String string) {
        Matcher m = keyword.matcher(string);
        if (!m.matches()) {
            return -1;
        }
        int i = 1;
        while (i <= m.groupCount()) {
            if (m.start(i) != -1) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException("IRI code internal error: no group matched.");
    }

    private void untilCloseSq() {
        while (this.classify[this.field - 1] != 5) {
            if (this.field >= this.split.length) {
                throw new IllegalArgumentException("Internal IRI code error. Did not find CLOSE_SQ in until().");
            }
            this.add();
        }
    }

    private void next() {
        switch (this.classify[this.field]) {
            case 5: {
                throw new IllegalArgumentException("Found unexpected ], either pattern syntax error, or limitation of IRI code.");
            }
            case 4: {
                this.add();
                this.untilCloseSq();
                break;
            }
            case 6: {
                ++this.field;
                this.rslt.append("(");
                ++this.groupCount;
                if (this.split[this.field].equals("host")) {
                    this.addHost();
                    break;
                }
                if (this.split[this.field].equals("shouldLowerCase")) {
                    this.shouldLowerCase |= 1 << this.groupCount;
                } else if (this.split[this.field].equals("mustLowerCase")) {
                    this.mustLowerCase |= 1 << this.groupCount;
                } else {
                    throw new IllegalArgumentException("No macro: " + this.split[this.field]);
                }
                this.addLowerCase();
                break;
            }
            case 1: {
                ++this.groupCount;
            }
            case -1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                this.add();
                return;
            }
            default: {
                throw new IllegalStateException("IRI code internal error.");
            }
        }
    }

    private void addLowerCase() {
        int sqCount = 0;
        ++this.field;
        if (this.classify[this.field] != 1) {
            throw new IllegalArgumentException(String.valueOf(this.split[this.field - 1]) + " macro syntax error");
        }
        ++this.field;
        this.rslt.append("?:(?:");
        StringBuffer caseInsensitiveEx = new StringBuffer();
        while (this.classify[this.field - 1] != 3 || sqCount > 0) {
            if (this.field >= this.split.length) {
                throw new IllegalArgumentException("Internal IRI code error. Did not find CLOSE_PAREN in addLowerCase().");
            }
            switch (this.classify[this.field]) {
                case 4: {
                    ++sqCount;
                    caseInsensitiveEx.append('[');
                    break;
                }
                case 5: {
                    --sqCount;
                    caseInsensitiveEx.append(']');
                    break;
                }
                case 8: {
                    if (sqCount == 0) {
                        this.makeCaseInsensitive(caseInsensitiveEx);
                        break;
                    }
                    caseInsensitiveEx.append(this.split[this.field]);
                    caseInsensitiveEx.append((char)(this.split[this.field].charAt(0) - 97 + 65));
                    caseInsensitiveEx.append('-');
                    caseInsensitiveEx.append((char)(this.split[this.field].charAt(2) - 97 + 65));
                    break;
                }
                case 1: {
                    if (sqCount == 0) {
                        throw new IllegalStateException("IRI code internal error: capturing group not supported inside lowercase.");
                    }
                }
                case 2: 
                case 3: 
                case 7: {
                    caseInsensitiveEx.append(this.split[this.field]);
                    break;
                }
                case -1: {
                    this.makeCaseInsensitive(caseInsensitiveEx);
                    break;
                }
                default: {
                    throw new IllegalStateException("IRI code internal error.");
                }
            }
            this.add();
        }
        if (this.classify[this.field] != 7) {
            throw new IllegalArgumentException("case macro syntax error");
        }
        ++this.field;
        this.rslt.append("|(");
        this.rslt.append(caseInsensitiveEx);
        this.rslt.append(")");
    }

    private void makeCaseInsensitive(StringBuffer caseInsensitiveEx) {
        int i = 0;
        while (i < this.split[this.field].length()) {
            char c = this.split[this.field].charAt(i);
            if (c >= 'a' && c <= 'z') {
                caseInsensitiveEx.append('[');
                caseInsensitiveEx.append(c);
                caseInsensitiveEx.append((char)(c - 97 + 65));
                caseInsensitiveEx.append(']');
            }
            ++i;
        }
    }

    private void addHost() {
        this.hostNames |= 1 << this.groupCount;
        ++this.field;
        if (this.classify[this.field] != 7) {
            throw new IllegalArgumentException("host macro syntax error");
        }
        this.rslt.append("[^\\[\\]:/?#@!$&'()*+,;=]*|\\[[^\\[\\]/?#@!$&'()*+,;=]*\\])");
        ++this.field;
    }

    private void add() {
        this.rslt.append(this.split[this.field]);
        ++this.field;
    }

    public String toString() {
        return this.pattern.pattern();
    }
}

