% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset08}
\alias{dataset08}
\title{Monica Penedo ROC dataset}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1:5, 1:5, 1:112, 1], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1:5, 1:5, 1:64, 1], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:64], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:64, 1], numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:64, 1], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "dataset08", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "ROC", the data type}
\item{\code{descriptions$name}}{, chr "PENEDO", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, num [1:5, 1:5, 1:112, 1:2], truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr [1:5] "0" "1" "2" "3" ..., treatment labels}
\item{\code{descriptions$readerID}}{, chr [1:5] "0" "1" "2" "3" ..., reader labels}
}
}
\usage{
dataset08
}
\description{
This is referred to in the book as the "PEN" dataset. It consists of 112 cases, 
64 of which are diseased, interpreted in five treatments (basically different image compression
algorithms) by five 
radiologists using the FROC paradigm (the inferred ROC dataset is included; the original FROC data
is lost).
}
\examples{
str(dataset08)
PlotEmpiricalOperatingCharacteristics(dataset = dataset08, opChType = "ROC")$Plot


}
\references{
Penedo et al. Free-Response Receiver Operating Characteristic 
Evaluation of Lossy JPEG2000 and Object-based Set Partitioning in 
Hierarchical Trees Compression of Digitized Mammograms. 
Radiology. 2005;237(2):450-457.
}
\keyword{datasets}
