% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StSignificanceTestingCrossedModalities.R
\name{StSignificanceTestingCrossedModalities}
\alias{StSignificanceTestingCrossedModalities}
\title{Perform significance testing using crossed modalities analysis}
\usage{
StSignificanceTestingCrossedModalities(crossedData, avgIndx, FOM = "wAFROC", 
alpha = 0.05, option = "ALL")
}
\arguments{
\item{crossedData}{The crossed modalities dataset}

\item{avgIndx}{The index of the modality to be averaged over}

\item{FOM}{See \link{StSignificanceTesting}.}

\item{alpha}{See \link{StSignificanceTesting}.}

\item{option}{See \link{StSignificanceTesting}.}
}
\value{
The return list contains the same items with \link{StSignificanceTesting}.
}
\description{
Performs ORH analysis for specified crossed modalities dataset 
   averaged over specified modality factor
}
\examples{
## read the raw data file in extdata directory
crossedFileName <- system.file("extdata", "includedCrossedModalitiesData.xlsx", 
package = "RJafroc", mustWork = TRUE)
crossedData <- DfReadCrossedModalities(crossedFileName)
retCrossed1 <- StSignificanceTestingCrossedModalities(crossedData, 1)

## read the built in dataset
retCrossed2 <- StSignificanceTestingCrossedModalities(datasetCrossedModality, 1)

}
