/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v20;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class GenericDataParser {
    protected static Logger logger = Configuration.getSdmxLogger();
    private static final String SERIES = "Series";
    private static final String SERIES_KEY = "SeriesKey";
    private static final String VALUE = "value";
    private static final String CONCEPT = "concept";
    private static final String OBS = "Obs";
    private static final String OBS_TIME = "Time";
    private static final String OBS_VALUE = "ObsValue";
    private static final String ATTRIBUTES = "Attributes";
    private static final String ATTRIBUTEVALUE = "Value";

    public static DataParsingResult parse(InputStreamReader inputStreamReader, DataFlowStructure dataFlowStructure, String string, boolean bl) throws XMLStreamException, UnsupportedEncodingException, SdmxException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        BufferedReader bufferedReader = GenericDataParser.skipBOM(inputStreamReader);
        XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(bufferedReader);
        DataParsingResult dataParsingResult = new DataParsingResult();
        ArrayList<PortableTimeSeries> arrayList = new ArrayList<PortableTimeSeries>();
        PortableTimeSeries portableTimeSeries = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement()) {
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == SERIES) {
                    portableTimeSeries = new PortableTimeSeries();
                    portableTimeSeries.setDataflow(string);
                }
                if (xMLEvent.getName().getLocalPart() == SERIES_KEY) {
                    GenericDataParser.setSeriesKey(portableTimeSeries, xMLEventReader, dataFlowStructure);
                }
                if (xMLEvent.getName().getLocalPart() == ATTRIBUTES) {
                    GenericDataParser.setSeriesAttributes(portableTimeSeries, xMLEventReader);
                }
                if (xMLEvent.getName().getLocalPart() == OBS && bl) {
                    GenericDataParser.setSeriesSingleObs(portableTimeSeries, xMLEventReader);
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != SERIES) continue;
            arrayList.add(portableTimeSeries);
        }
        dataParsingResult.setData(arrayList);
        return dataParsingResult;
    }

    private static void setSeriesKey(PortableTimeSeries portableTimeSeries, XMLEventReader xMLEventReader, DataFlowStructure dataFlowStructure) throws XMLStreamException {
        String string = null;
        String string2 = null;
        String[] stringArray = new String[dataFlowStructure.getDimensions().size()];
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement() && (xMLEvent = xMLEvent2.asStartElement()).getName().getLocalPart().equalsIgnoreCase(VALUE)) {
                Iterator<Attribute> iterator = xMLEvent.getAttributes();
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.getName().toString().equalsIgnoreCase(CONCEPT)) {
                        string = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equalsIgnoreCase(VALUE)) continue;
                    string2 = attribute.getValue();
                }
            }
            if (xMLEvent2.isEndElement() && (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart().equalsIgnoreCase(VALUE)) {
                if (dataFlowStructure.isDimension(string)) {
                    stringArray[dataFlowStructure.getDimensionPosition((String)string) - 1] = string + "=" + string2;
                }
                if (string.equalsIgnoreCase("FREQ") || string.equalsIgnoreCase("FREQUENCY")) {
                    portableTimeSeries.setFrequency(string2);
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != SERIES_KEY) continue;
            portableTimeSeries.setDimensions(Arrays.asList(stringArray));
            break;
        }
    }

    private static void setSeriesAttributes(PortableTimeSeries portableTimeSeries, XMLEventReader xMLEventReader) throws XMLStreamException {
        String string = null;
        String string2 = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement() && (xMLEvent = xMLEvent2.asStartElement()).getName().getLocalPart().equalsIgnoreCase(VALUE)) {
                Iterator<Attribute> iterator = xMLEvent.getAttributes();
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.getName().toString().equalsIgnoreCase(CONCEPT)) {
                        string = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equalsIgnoreCase(VALUE)) continue;
                    string2 = attribute.getValue();
                }
            }
            if (xMLEvent2.isEndElement() && (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart().equalsIgnoreCase(VALUE)) {
                portableTimeSeries.addAttribute(string + '=' + string2);
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != ATTRIBUTES) continue;
            break;
        }
    }

    private static void setSeriesSingleObs(PortableTimeSeries portableTimeSeries, XMLEventReader xMLEventReader) throws XMLStreamException, SdmxException {
        String string = null;
        String string2 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement()) {
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == OBS_TIME) {
                    string = xMLEventReader.getElementText();
                }
                if (xMLEvent.getName().getLocalPart() == OBS_VALUE) {
                    string2 = xMLEvent.getAttributeByName(new QName(VALUE)).getValue();
                }
                if (xMLEvent.getName().getLocalPart() == ATTRIBUTEVALUE) {
                    String string3 = xMLEvent.getAttributeByName(new QName(CONCEPT)).getValue();
                    String string4 = xMLEvent.getAttributeByName(new QName(VALUE)).getValue();
                    hashtable.put(string3, string4);
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != OBS) continue;
            portableTimeSeries.addObservation(string2, string, hashtable);
            break;
        }
    }

    public static BufferedReader skipBOM(InputStreamReader inputStreamReader) throws SdmxException {
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        logger.fine(inputStreamReader.getEncoding());
        try {
            char[] cArray = new char[1];
            bufferedReader.mark(1);
            bufferedReader.read(cArray, 0, 1);
            logger.fine(String.format("0x%2s", Integer.toHexString(cArray[0])));
            if ((byte)cArray[0] == -1) {
                logger.fine("BOM found and skipped");
            } else {
                bufferedReader.reset();
            }
        }
        catch (IOException iOException) {
            throw new SdmxException("Error handling BOM for UTF8 response stream.");
        }
        return bufferedReader;
    }
}

