% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x13_spec.R
\name{x13_spec}
\alias{x13_spec}
\title{X-13ARIMA model specification, SA/X13}
\usage{
x13_spec(
  spec = c("RSA5c", "RSA0", "RSA1", "RSA2c", "RSA3", "RSA4c", "X11"),
  preliminary.check = NA,
  estimate.from = NA_character_,
  estimate.to = NA_character_,
  estimate.first = NA_integer_,
  estimate.last = NA_integer_,
  estimate.exclFirst = NA_integer_,
  estimate.exclLast = NA_integer_,
  estimate.tol = NA_integer_,
  transform.function = c(NA, "Auto", "None", "Log"),
  transform.adjust = c(NA, "None", "LeapYear", "LengthOfPeriod"),
  transform.aicdiff = NA_integer_,
  usrdef.outliersEnabled = NA,
  usrdef.outliersType = NA,
  usrdef.outliersDate = NA,
  usrdef.outliersCoef = NA,
  usrdef.varEnabled = NA,
  usrdef.var = NA,
  usrdef.varType = NA,
  usrdef.varCoef = NA,
  tradingdays.option = c(NA, "TradingDays", "WorkingDays", "UserDefined", "None"),
  tradingdays.autoadjust = NA,
  tradingdays.leapyear = c(NA, "LeapYear", "LengthOfPeriod", "None"),
  tradingdays.stocktd = NA_integer_,
  tradingdays.test = c(NA, "Remove", "Add", "None"),
  easter.enabled = NA,
  easter.julian = NA,
  easter.duration = NA_integer_,
  easter.test = c(NA, "Add", "Remove", "None"),
  outlier.enabled = NA,
  outlier.from = NA_character_,
  outlier.to = NA_character_,
  outlier.first = NA_integer_,
  outlier.last = NA_integer_,
  outlier.exclFirst = NA_integer_,
  outlier.exclLast = NA_integer_,
  outlier.ao = NA,
  outlier.tc = NA,
  outlier.ls = NA,
  outlier.so = NA,
  outlier.usedefcv = NA,
  outlier.cv = NA_integer_,
  outlier.method = c(NA, "AddOne", "AddAll"),
  outlier.tcrate = NA_integer_,
  automdl.enabled = NA,
  automdl.acceptdefault = NA,
  automdl.cancel = NA_integer_,
  automdl.ub1 = NA_integer_,
  automdl.ub2 = NA_integer_,
  automdl.mixed = NA,
  automdl.balanced = NA,
  automdl.armalimit = NA_integer_,
  automdl.reducecv = NA_integer_,
  automdl.ljungboxlimit = NA_integer_,
  automdl.ubfinal = NA_integer_,
  arima.mu = NA,
  arima.p = NA_integer_,
  arima.d = NA_integer_,
  arima.q = NA_integer_,
  arima.bp = NA_integer_,
  arima.bd = NA_integer_,
  arima.bq = NA_integer_,
  arima.coefEnabled = NA,
  arima.coef = NA,
  arima.coefType = NA,
  fcst.horizon = NA_integer_,
  x11.mode = c(NA, "Undefined", "Additive", "Multiplicative", "LogAdditive",
    "PseudoAdditive"),
  x11.seasonalComp = NA,
  x11.lsigma = NA_integer_,
  x11.usigma = NA_integer_,
  x11.trendAuto = NA,
  x11.trendma = NA_integer_,
  x11.seasonalma = NA_character_,
  x11.fcasts = NA_integer_,
  x11.bcasts = NA_integer_,
  x11.calendarSigma = NA,
  x11.sigmaVector = NA,
  x11.excludeFcasts = NA,
  benchmarking.enabled = NA,
  benchmarking.target = c(NA, "Original", "CalendarAdjusted"),
  benchmarking.useforecast = NA,
  benchmarking.rho = NA_real_,
  benchmarking.lambda = NA_real_
)
}
\arguments{
\item{spec}{an x13 model specification. It can be the 'JDemetra+' name (\code{character}) of a predefined X13 'JDemetra+' model specification
(see \emph{Details}), an object of class \code{c("SA_spec","X13")} or an object of class \code{c("SA", "X13")}. The default is \code{"RSA5c"}.}

\item{preliminary.check}{a Boolean to check the quality of the input series and exclude highly problematic ones
(e.g. the series with a number of identical observations and/or missing values above pre-specified threshold values).

The time span of the series, which is the (sub)period used to estimate the regarima model, is controlled by the following six variables:
\code{estimate.from, estimate.to, estimate.first, estimate.last, estimate.exclFirst} and \code{estimate.exclLast};
where \code{estimate.from} and \code{estimate.to} have priority over the remaining span control variables,
\code{estimate.last} and \code{estimate.first} have priority over \code{estimate.exclFirst} and \code{estimate.exclLast},
and \code{estimate.last} has priority over \code{estimate.first}. Default= "All".}

\item{estimate.from}{a character in format "YYYY-MM-DD" indicating the start of the time span (e.g. "1900-01-01").
It can be combined with the parameter \code{estimate.to}.}

\item{estimate.to}{a character in format "YYYY-MM-DD" indicating the end of the time span (e.g. "2020-12-31").
It can be combined with the parameter \code{estimate.from}.}

\item{estimate.first}{a numeric specifying the number of periods considered at the beginning of the series.}

\item{estimate.last}{numeric specifying the number of periods considered at the end of the series.}

\item{estimate.exclFirst}{a numeric specifying the number of periods excluded at the beginning of the series.
It can be combined with the parameter \code{estimate.exclLast}.}

\item{estimate.exclLast}{a numeric specifying the number of periods excluded at the end of the series.
It can be combined with the parameter \code{estimate.exclFirst}.}

\item{estimate.tol}{a numeric, convergence tolerance. The absolute changes in the log-likelihood function
are compared to this value to check for the convergence of the estimation iterations.}

\item{transform.function}{the transformation of the input series: \code{"None"} = no transformation of the series;
\code{"Log"} = takes the log of the series; \code{"Auto"} = the program tests for the log-level specification.}

\item{transform.adjust}{pre-adjustment of the input series for the length of period or leap year effects:
\code{"None"} = no adjustment; \code{"LeapYear"} = leap year effect; \code{"LengthOfPeriod"} = length of period.
Modifications of this variable are taken into account only when \code{transform.function} is set to \code{"Log"}.}

\item{transform.aicdiff}{a numeric defining the difference in AICC needed to accept no transformation when the automatic
transformation selection is chosen (considered only when \code{transform.function} is set to \code{"Auto"}).

Control variables for the pre-specified outliers. The pre-specified outliers are used in the model only when enabled
(\code{usrdef.outliersEnabled=TRUE}) and the outlier type (\code{usrdef.outliersType}) and date
(\code{usrdef.outliersDate}) are provided.}

\item{usrdef.outliersEnabled}{logical. If \code{TRUE}, the program uses the pre-specified outliers.}

\item{usrdef.outliersType}{a vector defining the outlier type. Possible types are: \code{("AO")} = additive,
\code{("LS")} = level shift, \code{("TC")} = transitory change, \code{("SO")} = seasonal outlier.
E.g.: \code{usrdef.outliersType = c("AO","AO","LS")}.}

\item{usrdef.outliersDate}{a vector defining the outlier dates. The dates should be characters in format "YYYY-MM-DD".
E.g.: \code{usrdef.outliersDate= c("2009-10-01","2005-02-01","2003-04-01")}.}

\item{usrdef.outliersCoef}{a vector providing fixed coefficients for the outliers. The coefficients can't be fixed if
\code{transform.function} is set to \code{"Auto"} i.e. the series transformation need to be pre-defined.
E.g.: \code{ usrdef.outliersCoef=c(200,170,20)}.

Control variables for the user-defined variables:}

\item{usrdef.varEnabled}{a logical. If \code{TRUE}, the program uses the user-defined variables.}

\item{usrdef.var}{a time series (\code{ts}) or a matrix of time series (\code{mts}) with the user-defined variables.}

\item{usrdef.varType}{a vector of character(s) defining the user-defined variables component type.
Possible types are: \code{"Undefined", "Series", "Trend", "Seasonal", "SeasonallyAdjusted", "Irregular", "Calendar"}.
The type \code{"Calendar"}must be used with \code{tradingdays.option = "UserDefined"} to use user-defined calendar regressors.
If not specified, the program will assign the \code{"Undefined"} type.}

\item{usrdef.varCoef}{a vector providing fixed coefficients for the user-defined variables. The coefficients can't be fixed
if \code{transform.function} is set to \code{"Auto"} i.e. the series transformation need to be pre-defined.}

\item{tradingdays.option}{to specify the set of trading days regression variables:
\code{"TradingDays"} = six day-of-the-week regression variables;
\code{"WorkingDays"} = one working/non-working day contrast variable;
\code{"None"} = no correction for trading days and working days effects;
\code{"UserDefined"} = user-defined trading days regressors (regressors must be defined by the \code{usrdef.var}
argument with \code{usrdef.varType} set to \code{"Calendar"} and \code{usrdef.varEnabled = TRUE}).
\code{"None"} must also be specified for the "day-of-week effects" correction (\code{tradingdays.stocktd} to be modified accordingly).}

\item{tradingdays.autoadjust}{a logical. If \code{TRUE}, the program corrects automatically for the leap year effect.
Modifications of this variable are taken into account only when \code{transform.function} is set to \code{"Auto"}.}

\item{tradingdays.leapyear}{a \code{character} to specify whether or not to include the leap-year effect in the model:
\code{"LeapYear"} = leap year effect; \code{"LengthOfPeriod"} = length of period, \code{"None"} = no effect included.
The leap-year effect can be pre-specified in the model only if the input series hasn't been pre-adjusted
(\code{transform.adjust} set to \code{"None"}) and if the automatic correction for the leap-year effect isn't selected
(\code{tradingdays.autoadjust} set to \code{FALSE}).}

\item{tradingdays.stocktd}{a numeric indicating the day of the month when inventories and other stock are reported
(to denote the last day of the month, set the variable to 31). Modifications of this variable are taken into account
only when \code{tradingdays.option} is set to \code{"None"}.}

\item{tradingdays.test}{defines the pre-tests for the significance of the trading day regression variables
based on the AICC statistics: \code{"Add"} = the trading day variables are not included in the initial regression model
but can be added to the RegARIMA model after the test;
\code{"Remove"} = the trading day variables belong to the initial regression model but can be removed from the RegARIMA model
after the test; \code{"None"} = the trading day variables are not pre-tested and are included in the model.}

\item{easter.enabled}{a logical. If \code{TRUE}, the program considers the Easter effect in the model.}

\item{easter.julian}{a logical. If \code{TRUE}, the program uses the Julian Easter (expressed in Gregorian calendar).}

\item{easter.duration}{a numeric indicating the duration of the Easter effect (length in days, between 1 and 20).}

\item{easter.test}{defines the pre-tests for the significance of the Easter effect based on the t-statistic
(the Easter effect is considered as significant if the t-statistic is greater than 1.96):
\code{"Add"} = the Easter effect variable is not included in the initial regression model but can be added
to the RegARIMA model after the test;
\code{"Remove"} = the Easter effect variable belongs to the initial regression model but can be removed
from the RegARIMA model after the test;
\code{"None"} = the Easter effect variable is not pre-tested and is included in the model.}

\item{outlier.enabled}{a logical. If \code{TRUE}, the automatic detection of outliers is enabled in the defined time span.

The time span during which outliers will be searched is controlled by the following
six variables: \code{outlier.from, outlier.to, outlier.first, outlier.last, outlier.exclFirst} and \code{outlier.exclLast};
where \code{outlier.from} and \code{outlier.to} have priority over the remaining span control variables,
\code{outlier.last} and \code{outlier.first} have priority over \code{outlier.exclFirst} and \code{outlier.exclLast},
and \code{outlier.last} has priority over \code{outlier.first}.}

\item{outlier.from}{a character in format "YYYY-MM-DD" indicating the start of the time span (e.g. "1900-01-01").
It can be combined with the parameter \code{outlier.to}.}

\item{outlier.to}{a character in format "YYYY-MM-DD" indicating the end of the time span (e.g. "2020-12-31").
it can be combined with the parameter \code{outlier.from}.}

\item{outlier.first}{a numeric specifying the number of periods considered at the beginning of the series.}

\item{outlier.last}{a numeric specifying the number of periods considered at the end of the series.}

\item{outlier.exclFirst}{a numeric specifying the number of periods excluded at the beginning of the series.
It can be combined with the parameter \code{outlier.exclLast}.}

\item{outlier.exclLast}{a numeric specifying the number of periods excluded at the end of the series.
It can be combined with the parameter \code{outlier.exclFirst}.}

\item{outlier.ao}{a logical. If \code{TRUE}, the automatic detection of additive outliers is enabled
(\code{outlier.enabled} must be also set to \code{TRUE}).}

\item{outlier.tc}{a logical. If \code{TRUE}, the automatic detection of transitory changes is enabled
(\code{outlier.enabled} must be also set to \code{TRUE}).}

\item{outlier.ls}{a logical. If \code{TRUE}, the automatic detection of level shifts is enabled
(\code{outlier.enabled} must be also set to \code{TRUE}).}

\item{outlier.so}{a logical. If \code{TRUE}, the automatic detection of seasonal outliers is enabled
(\code{outlier.enabled} must be also set to \code{TRUE}).}

\item{outlier.usedefcv}{a logical. If \code{TRUE}, the critical value for the outlier detection procedure
is automatically determined by the number of observations in the outlier detection time span. If \code{FALSE},
the procedure uses the entered critical value (\code{outlier.cv}).}

\item{outlier.cv}{a numeric. The entered critical value for the outlier detection procedure.
The modification of this variable is only taken into account when \code{outlier.usedefcv} is set to \code{FALSE}.}

\item{outlier.method}{determines how the program successively adds detected outliers to the model.
At present, only the \code{AddOne} method is supported.}

\item{outlier.tcrate}{a numeric. The rate of decay for the transitory change outlier.}

\item{automdl.enabled}{a logical. If \code{TRUE}, the automatic modelling of the ARIMA model is enabled.
If \code{FALSE}, the parameters of the ARIMA model can be specified.

Control variables for the automatic modelling of the ARIMA model (when \code{automdl.enabled} is set to \code{TRUE}):}

\item{automdl.acceptdefault}{a logical. If \code{TRUE}, the default model (ARIMA(0,1,1)(0,1,1)) may be chosen
in the first step of the automatic model identification. If the Ljung-Box Q statistics for the residuals is acceptable,
the default model is accepted and no further attempt will be made to identify another model.}

\item{automdl.cancel}{the cancellation limit (\code{numeric}). If the difference in moduli of an AR and an MA roots
(when estimating ARIMA(1,0,1)(1,0,1) models in the second step of the automatic identification of the differencing orders)
is smaller than the cancellation limit, the two roots are assumed equal and cancel out.}

\item{automdl.ub1}{the first unit root limit (\code{numeric}). It is the threshold value for the initial unit root test
in the automatic differencing procedure. When one of the roots in the estimation of the ARIMA(2,0,0)(1,0,0) plus mean model,
performed in the first step of the automatic model identification procedure, is larger than the first unit root limit in modulus,
it is set equal to unity.}

\item{automdl.ub2}{the second unit root limit (\code{numeric}). When one of the roots in the estimation of
the ARIMA(1,0,1)(1,0,1) plus mean model, which is performed in the second step of the automatic model identification
procedure, is larger than second unit root limit in modulus, it is checked if there is a common factor
in the corresponding AR and MA polynomials of the ARMA model that can be canceled (see \code{automdl.cancel}).
If there is no cancellation, the AR root is set equal to unity (i.e. the differencing order changes).}

\item{automdl.mixed}{a logical. This variable controls whether ARIMA models with non-seasonal AR and MA terms
or seasonal AR and MA terms will be considered in the automatic model identification procedure.
If \code{FALSE}, a model with AR and MA terms in both the seasonal and non-seasonal parts of the model can be acceptable,
provided there are no AR or MA terms in either the seasonal or non-seasonal terms.}

\item{automdl.balanced}{a logical. If \code{TRUE}, the automatic model identification procedure will have a preference
for balanced models (i.e. models for which the order of the combined AR and differencing operator is equal to the order
of the combined MA operator).}

\item{automdl.armalimit}{the ARMA limit (\code{numeric}). It is the threshold value for t-statistics of ARMA coefficients
and constant term used for the final test of model parsimony. If the highest order ARMA coefficient has a t-value
smaller than this value in magnitude, the order of the model is reduced. If the constant term t-value is smaller
than the ARMA limit in magnitude, it is removed from the set of regressors.}

\item{automdl.reducecv}{numeric, ReduceCV. The percentage by which the outlier's critical value will be reduced
when an identified model is found to have a Ljung-Box statistic with an unacceptable confidence coefficient.
The parameter should be between 0 and 1, and will only be active when automatic outlier identification is enabled.
The reduced critical value will be set to (1-ReduceCV)*CV, where CV is the original critical value.}

\item{automdl.ljungboxlimit}{the Ljung Box limit (\code{numeric}). Acceptance criterion for the confidence intervals
of the Ljung-Box Q statistic. If the LjungBox Q statistics for the residuals of a final model is greater than
the Ljung Box limit, then the model is rejected, the outlier critical value is reduced and model and outlier identification
(if specified) is redone with a reduced value.}

\item{automdl.ubfinal}{numeric, final unit root limit. The threshold value for the final unit root test.
If the magnitude of an AR root for the final model is smaller than the final unit root limit, then a unit root is assumed,
the order of the AR polynomial is reduced by one and the appropriate order of the differencing (non-seasonal, seasonal)
is increased. The parameter value should be greater than one.

Control variables for the non-automatic modelling of the ARIMA model (when \code{automdl.enabled} is set to \code{FALSE}):}

\item{arima.mu}{logical. If \code{TRUE}, the mean is considered as part of the ARIMA model.}

\item{arima.p}{numeric. The order of the non-seasonal autoregressive (AR) polynomial.}

\item{arima.d}{numeric. The regular differencing order.}

\item{arima.q}{numeric. The order of the non-seasonal moving average (MA) polynomial.}

\item{arima.bp}{numeric. The order of the seasonal autoregressive (AR) polynomial.}

\item{arima.bd}{numeric. The seasonal differencing order.}

\item{arima.bq}{numeric. The order of the seasonal moving average (MA) polynomial.

Control variables for the user-defined ARMA coefficients. Coefficients can be defined for the regular and seasonal
autoregressive (AR) polynomials and moving average (MA) polynomials. The model considers the coefficients only if
the procedure for their estimation (\code{arima.coefType}) is provided, and the number of provided coefficients
matches the sum of (regular and seasonal) AR and MA orders (\code{p,q,bp,bq}).}

\item{arima.coefEnabled}{logical. If \code{TRUE}, the program uses the user-defined ARMA coefficients.}

\item{arima.coef}{a vector providing the coefficients for the regular and seasonal AR and MA polynomials.
The vector length must be equal to the sum of the regular and seasonal AR and MA orders.
The coefficients shall be provided in the following order: regular AR (\emph{Phi}; \code{p} elements),
regular MA  (\emph{Theta}; \code{q} elements), seasonal AR (\emph{BPhi}; \code{bp} elements)
and seasonal MA (\emph{BTheta}; \code{bq} elements).
E.g.: \code{arima.coef=c(0.6,0.7)} with \code{arima.p=1, arima.q=0,arima.bp=1} and \code{arima.bq=0}.}

\item{arima.coefType}{a vector defining the ARMA coefficients estimation procedure.
Possible procedures are: \code{"Undefined"} = no use of any user-defined input (i.e. coefficients are estimated),
\code{"Fixed"} = the coefficients are fixed at the value provided by the user,
\code{"Initial"} = the value defined by the user is used as the initial condition.
For orders for which the coefficients shall not be defined, the \code{arima.coef} can be set to \code{NA} or \code{0},
or the \code{arima.coefType} can be set to \code{"Undefined"}.
E.g.: \code{arima.coef = c(-0.8,-0.6,NA)}, \code{arima.coefType = c("Fixed","Fixed","Undefined")}.}

\item{fcst.horizon}{the forecasting horizon (\code{numeric}). The forecast length generated by the RegARIMA model
in periods (positive values) or years (negative values). By default, the program generates a two-year forecast
(\code{fcst.horizon} set to \code{-2}).}

\item{x11.mode}{character: the decomposition mode. Determines the mode of the seasonal adjustment decomposition to be performed:
\code{"Undefined"} - no assumption concerning the relationship between the time series components is made;
\code{"Additive"} - assumes an additive relationship;
\code{"Multiplicative"} - assumes a multiplicative relationship;
\code{"LogAdditive"} - performs an additive decomposition of the logarithms of the series being adjusted;
\code{"PseudoAdditive"} - assumes an pseudo-additive relationship. Could be changed by the program, if needed.}

\item{x11.seasonalComp}{logical: if \code{TRUE}, the program computes a seasonal component. Otherwise, the seasonal component
is not estimated and its values are all set to 0 (additive decomposition) or 1 (multiplicative decomposition).}

\item{x11.lsigma}{numeric: the lower sigma boundary for the detection of extreme values, > 0.5, default=1.5.}

\item{x11.usigma}{numeric: the upper sigma boundary for the detection of extreme values, > lsigma, default=2.5.}

\item{x11.trendAuto}{logical: automatic Henderson filter. If \code{TRUE}, an automatic selection of the Henderson filter's length
for the trend estimation is enabled.}

\item{x11.trendma}{numeric: the length of the Henderson filter. The user-defined length of the Henderson filter.
The option is available when the automatic Henderson filter selection is disabled (\code{x11.trendAuto=FALSE}).
Should be an odd number in the range (1, 101].}

\item{x11.seasonalma}{a vector of character(s) specifying which seasonal moving average (i.e. seasonal filter)
will be used to estimate the seasonal factors for the entire series. The vector can be of length:
1 - the same seasonal filter is used for all periods (e.g.: `seasonal.filter = "Msr"` or `seasonal.filter = "S3X3"` );
or have a different value for each quarter (length 4) or each month (length 12) - (e.g. for quarterly series: `seasonal.filter = c("S3X3", "Msr", "S3X3", "Msr")`).
Possible filters are: `"Msr"`, `"Stable"`, `"X11Default"`, `"S3X1"`, `"S3X3"`, `"S3X5"`, `"S3X9"`, `"S3X15"`.
`"Msr"` - the program chooses the final seasonal filter automatically.}

\item{x11.fcasts}{numeric: the number of forecasts generated by the RegARIMA model in periods (positive values) or years (negative values).Default value: fcasts=-1.}

\item{x11.bcasts}{numeric: the number of backcasts used in X11. Negative figures are translated in years of backcasts. Default value: bcasts=0.}

\item{x11.calendarSigma}{character to specify if the standard errors used for extreme values detection and adjustment are computed:
from 5 year spans of irregulars (\code{"None"}, the default);
separately for each calendar month/quarter (\code{"All"});
separately for each period only if Cochran’s hypothesis test determines that the irregular component is heteroskedastic
by calendar month/quarter (\code{"Signif"});
separately for two complementary sets of calendar months/quarters specified by the x11.sigmaVector parameter (\code{"Select"},
see parameter \code{x11.sigmaVector}).}

\item{x11.sigmaVector}{a vector to specify one of the two groups of periods for whose standard errors used for extreme values
detection and adjustment will be computed. Only used if \code{x11.calendarSigma = "Select"}. Possible values are: "Group1" and "Group2".}

\item{x11.excludeFcasts}{logical: to exclude forecasts and backcasts. If \code{TRUE}, the RegARIMA model forecasts and backcasts are not used during the detection of extreme values in the seasonal adjustment routines.}

\item{benchmarking.enabled}{logical: to enable benchmarking. If \code{TRUE}, the benchmarking is enabled.}

\item{benchmarking.target}{character: the target of the benchmarking procedure, which can be the raw series (\code{"Original"}) or the series the adjusted for calendar effects (\code{"CalendarAdjusted"}).}

\item{benchmarking.useforecast}{logical: If \code{TRUE}, the forecasts of the seasonally adjusted variable and of the target variable are used in the benchmarking computation so the benchmarking constrains is also applied to the forecasting period.}

\item{benchmarking.rho}{numeric: the value of the AR(1) parameter (set between 0 and 1) in the function used for benchmarking.}

\item{benchmarking.lambda}{numeric: a parameter used for benchmarking that relatesto to the weights in the regression equation. It is typically equal to 0, 1/2 or 1.}
}
\value{
A two-element list of class \code{c("SA_spec", "X13")}, containing:
(1) an object of class \code{c("regarima_spec", "X13")} with the RegARIMA model specification;
(2) an object of class \code{c("X11_spec", "data.frame")} with the X11 algorithm specification.
Each component refers to different parts of the SA model specification, mirroring the arguments of the function (for details,
see the function arguments in the description).
Each lowest-level component (except span, pre-specified outliers, user-defined variables and pre-specified ARMA coefficients)
is structured as a data frame with columns denoting different variables of the model specification and rows referring to:
\itemize{
\item first row: the base specification, as provided within the argument \code{spec};
\item second row: user modifications as specified by the remaining arguments of the function (e.g.: \code{arima.d});
\item and third row: the final model specification.

The final specification (third row) shall include user modifications (row two) unless they were wrongly specified.
The pre-specified outliers, user-defined variables and pre-specified ARMA coefficients consist of a list of
\code{Predefined} (base model specification) and \code{Final} values.

\item \code{regarima}: an object of class \code{c("regarima_spec", "x13")}. See \emph{Value} of the function \code{\link{regarima_spec_x13}}.

\item \code{x11}: a data.frame of class \code{c("X11_spec", "data.frame")}, containing the \emph{x11} variables in line with
the names of the arguments variables. The final values can be also accessed with the function \code{\link{s_x11}}.
}
}
\description{
Function to create (and/or modify) a \code{c("SA_spec", "X13")} class object with the SA model specification for the X13 method.
It can be done from a pre-defined 'JDemetra+' model specification (a \code{character}), a previous specification
(\code{c("SA_spec", "X13")} object) or a seasonal adjustment model (\code{c("SA", "X13")} object).
}
\details{
The available predefined 'JDemetra+' model specifications are described in the table below:

\tabular{rrrrrrr}{
\strong{Identifier} |\tab \strong{Log/level detection} |\tab \strong{Outliers detection} |\tab \strong{Calendar effects} |\tab \strong{ARIMA}\cr
RSA0 |\tab \emph{NA} |\tab \emph{NA} |\tab \emph{NA} |\tab Airline(+mean)\cr
RSA1 |\tab automatic |\tab AO/LS/TC  |\tab \emph{NA} |\tab Airline(+mean)\cr
RSA2c |\tab automatic |\tab AO/LS/TC |\tab 2 td vars + Easter |\tab Airline(+mean)\cr
RSA3 |\tab automatic |\tab AO/LS/TC |\tab \emph{NA} |\tab automatic\cr
RSA4c |\tab automatic |\tab AO/LS/TC |\tab 2 td vars + Easter |\tab automatic\cr
RSA5c |\tab automatic |\tab AO/LS/TC |\tab 7 td vars + Easter |\tab automatic\cr
X11 |\tab \emph{NA} |\tab \emph{NA} |\tab \emph{NA} |\tab NA
}
}
\examples{
\donttest{
myseries <- ipi_c_eu[, "FR"]
myspec1 <- x13_spec(spec = "RSA5c")
myreg1 <- x13(myseries, spec = myspec1)

# To modify a pre-specified model specification
myspec2 <- x13_spec(spec = "RSA5c", tradingdays.option = "WorkingDays")
myreg2 <- x13(myseries, spec = myspec2)

# To modify the model specification of a "X13" object
 myspec3 <- x13_spec(myreg1, tradingdays.option = "WorkingDays")
 myreg3 <- x13(myseries, myspec3)

# To modify the model specification of a "X13_spec" object
 myspec4 <- x13_spec(myspec1, tradingdays.option = "WorkingDays")
 myreg4 <- x13(myseries, myspec4)

# Pre-specified outliers
 myspec1 <- x13_spec(spec = "RSA5c", usrdef.outliersEnabled = TRUE,
             usrdef.outliersType = c("LS", "AO"),
             usrdef.outliersDate = c("2008-10-01", "2002-01-01"),
             usrdef.outliersCoef = c(36, 14),
             transform.function = "None")

 myreg1 <- x13(myseries, myspec1)
 myreg1
 s_preOut(myreg1)


# User-defined calendar regressors
 var1 <- ts(rnorm(length(myseries))*10, start = start(myseries), frequency = 12)
 var2 <- ts(rnorm(length(myseries))*100, start = start(myseries), frequency = 12)
 var <- ts.union(var1, var2)
 myspec1 <- x13_spec(spec = "RSA5c", tradingdays.option = "UserDefined",
                     usrdef.varEnabled = TRUE,
                     usrdef.var = var,
                     usrdef.varType = c("Calendar", "Calendar"))
 myreg1 <- x13(myseries, myspec1)
 myreg1

 myspec2 <- x13_spec(spec = "RSA5c", usrdef.varEnabled = TRUE,
             usrdef.var = var1, usrdef.varCoef = 2,
             transform.function = "None")
 myreg2 <- x13(myseries, myspec2)
 s_preVar(myreg2)

# Pre-specified ARMA coefficients
 myspec1 <- x13_spec(spec = "RSA5c", automdl.enabled = FALSE,
             arima.p = 1, arima.q = 1, arima.bp = 0, arima.bq = 1,
             arima.coefEnabled = TRUE,
             arima.coef = c(-0.8, -0.6, 0),
             arima.coefType = c(rep("Fixed", 2), "Undefined"))

 s_arimaCoef(myspec1)
 myreg1 <- x13(myseries, myspec1)
 myreg1

# To define a seasonal filter
 myspec1 <- x13_spec("RSA5c", x11.seasonalma = rep("S3X1", 12))
 mysa1 <- x13(myseries, myspec1)
}
}
\references{
More information and examples related to 'JDemetra+' features in the online documentation:
\url{https://jdemetra-new-documentation.netlify.app/}
BOX G.E.P. and JENKINS G.M. (1970), "Time Series Analysis: Forecasting and Control", Holden-Day, San Francisco.

BOX G.E.P., JENKINS G.M., REINSEL G.C. and LJUNG G.M. (2015), "Time Series Analysis: Forecasting and Control", John Wiley & Sons, Hoboken, N. J., 5th edition.
}
\seealso{
\code{\link{x13}}
}
