% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_workspace.R
\name{get_ts}
\alias{get_ts}
\title{Get the input raw time series}
\usage{
get_ts(x)
}
\arguments{
\item{x}{the object from which to retrieve the time series.}
}
\value{
\code{get_ts()} returns a \code{\link[stats]{ts}} object or list of \code{\link[stats]{ts}} objects:
\itemize{
 \item if \code{x} is a \code{sa_item} or a \code{SA} object, \code{get_ts(x)} returns a single \code{ts} object;
 \item if \code{x} is a \code{multiprocessing} object, \code{get_ts(x)} returns a list of length the number
 of sa_items, each element being a \code{ts} object;
 \item if \code{x} is a \code{workspace} object, \code{get_ts(x)} returns a list of length the number of multiprocessings,
 each element being a list of \code{ts} objects.
}
}
\description{
Generic functions to retrieve the input raw time series of a \code{workspace}, \code{multiprocessing},
\code{sa_item} or \code{SA} object.
}
\examples{
\donttest{
sa_x13 <- x13(ipi_c_eu[, "FR"], spec = "RSA5c")

wk <- new_workspace()
mp <- new_multiprocessing(wk, "sap1")
add_sa_item(wk, "sap1", sa_x13, "X13")
sa_item <- get_object(mp, 1)

  # Extracting the raw time series from an adjusted series:
get_ts(sa_x13) # Returns the ts object ipi_c_eu[, "FR"]

  # Extracting the raw time series from a sa_item:
get_ts(sa_item) # Returns the ts object ipi_c_eu[, "FR"]

  # Extracting all raw time series from a multiprocessing:
# Returns a list of length 1 named "X13" containing the ts object ipi_c_eu[, "FR"]:
get_ts(mp)


  # Extracting all raw time series from a workspace:
# Returns a list of length 1 named "sap1" containing a list
# of length 1 named "X13", containing the ts object ipi_c_eu[, "FR"]
get_ts(wk)
}
}
\seealso{
Other functions to retrieve information from a workspace, multiprocessing or sa_item: \code{\link{count}}, \code{\link{get_model}}, \code{\link{get_name}}.
}
