/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.maths.linearfilters.AbstractFiniteFilter;
import ec.tstoolkit.maths.linearfilters.IFiniteFilter;
import ec.tstoolkit.maths.polynomials.Polynomial;
import java.text.NumberFormat;
import java.util.Arrays;

public class FiniteFilter
extends AbstractFiniteFilter
implements Cloneable {
    private int m_lb;
    private Polynomial m_w;
    private static final double g_epsilon = 1.0E-4;

    public static FiniteFilter add(IFiniteFilter l, double d) {
        int llb = l.getLowerBound();
        int lub = l.getUpperBound();
        int lb = llb < 0 ? llb : 0;
        int ub = lub < 0 ? 0 : lub;
        double[] p = new double[ub - lb + 1];
        for (int i = llb; i <= lub; ++i) {
            p[i - lb] = l.getWeight(i);
        }
        int n = -lb;
        p[n] = p[n] + d;
        return FiniteFilter.promote(p, lb);
    }

    public static FiniteFilter add(IFiniteFilter l, IFiniteFilter r) {
        int i;
        int llb = l.getLowerBound();
        int lub = l.getUpperBound();
        int rlb = r.getLowerBound();
        int rub = r.getUpperBound();
        int lb = llb < rlb ? llb : rlb;
        int ub = lub < rub ? rub : lub;
        double[] p = new double[ub - lb + 1];
        for (i = llb; i <= lub; ++i) {
            p[i - lb] = l.getWeight(i);
        }
        for (i = rlb; i <= rub; ++i) {
            int n = i - lb;
            p[n] = p[n] + r.getWeight(i);
        }
        return FiniteFilter.promote(p, lb);
    }

    public static FiniteFilter multiply(IFiniteFilter l, double d) {
        int lb = l.getLowerBound();
        double[] p = (double[])l.getWeights().clone();
        int i = 0;
        while (i < p.length) {
            int n = i++;
            p[n] = p[n] * d;
        }
        return FiniteFilter.promote(p, lb);
    }

    public static FiniteFilter multiply(IFiniteFilter l, IFiniteFilter r) {
        int llb = l.getLowerBound();
        int rlb = r.getLowerBound();
        double[] lw = l.getWeights();
        double[] rw = r.getWeights();
        Polynomial lp = Polynomial.of(lw);
        Polynomial rp = Polynomial.of(rw);
        Polynomial w = lp.times(rp);
        return new FiniteFilter(w, llb + rlb);
    }

    public static FiniteFilter negate(IFiniteFilter l) {
        int lb = l.getLowerBound();
        double[] p = (double[])l.getWeights().clone();
        for (int i = 0; i < p.length; ++i) {
            p[i] = -p[i];
        }
        return FiniteFilter.promote(p, lb);
    }

    public static FiniteFilter promote(double[] c, int lb) {
        return new FiniteFilter(Polynomial.of(c), lb);
    }

    public static FiniteFilter subtract(IFiniteFilter l, double d) {
        return FiniteFilter.add(l, -d);
    }

    public static FiniteFilter subtract(IFiniteFilter l, IFiniteFilter r) {
        int i;
        int llb = l.getLowerBound();
        int lub = l.getUpperBound();
        int rlb = r.getLowerBound();
        int rub = r.getUpperBound();
        int lb = llb < rlb ? llb : rlb;
        int ub = lub < rub ? rub : lub;
        double[] p = new double[ub - lb + 1];
        for (i = llb; i <= lub; ++i) {
            p[i - lb] = l.getWeight(i);
        }
        for (i = rlb; i <= rub; ++i) {
            int n = i - lb;
            p[n] = p[n] - r.getWeight(i);
        }
        return FiniteFilter.promote(p, lb);
    }

    public FiniteFilter(double[] c, int lb) {
        this.m_lb = lb;
        this.m_w = Polynomial.copyOf(c);
    }

    public FiniteFilter(Polynomial c, int lb) {
        this.m_lb = lb;
        this.m_w = c;
    }

    public FiniteFilter(IFiniteFilter f) {
        double[] w = f.getWeights();
        this.m_w = Polynomial.copyOf(w);
        this.m_lb = f.getLowerBound();
    }

    public FiniteFilter(int n) {
        double[] w = new double[n];
        Arrays.fill(w, 1.0);
        this.m_w = Polynomial.of(w);
    }

    public FiniteFilter(int npast, int nfuture) {
        this.m_lb = -npast;
        double[] w = new double[npast + nfuture + 1];
        Polynomial.of(w);
    }

    public void backShift(int n) {
        this.m_lb -= n;
    }

    public boolean center() {
        int d = this.m_w.getDegree();
        if (d % 2 != 0) {
            return false;
        }
        this.m_lb = -d / 2;
        return true;
    }

    public FiniteFilter clone() {
        try {
            FiniteFilter f = (FiniteFilter)super.clone();
            f.m_w = this.m_w;
            return f;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    @Override
    public int getLength() {
        return this.m_w.getDegree() + 1;
    }

    @Override
    public int getLowerBound() {
        return this.m_lb;
    }

    @Override
    public int getUpperBound() {
        return this.m_lb + this.m_w.getDegree();
    }

    @Override
    public double getWeight(int pos) {
        return this.m_w.get(pos - this.m_lb);
    }

    @Override
    public double[] getWeights() {
        return this.m_w.getCoefficients();
    }

    public boolean isIdentity() {
        return this.m_w.isIdentity();
    }

    public boolean isSymmetric() {
        int d = this.m_w.getDegree();
        if (d % 2 != 0 || d != -this.m_lb) {
            return false;
        }
        for (int i = 0; i < d / 2; ++i) {
            if (!(Math.abs(this.m_w.get(i) - this.m_w.get(d - i)) > 1.0E-4)) continue;
            return false;
        }
        return true;
    }

    @Override
    public FiniteFilter mirror() {
        Polynomial w = this.m_w.mirror();
        int lb = 1 - this.m_lb - (w.getDegree() + 1);
        return new FiniteFilter(w, lb);
    }

    public void mul(double d) {
        this.m_w = this.m_w.times(d);
    }

    public boolean normalize(boolean center) {
        double s = 0.0;
        for (int i = 0; i <= this.m_w.getDegree(); ++i) {
            s += this.m_w.get(i);
        }
        if (s == 0.0) {
            return false;
        }
        if (s != 1.0) {
            this.m_w = this.m_w.divide(s);
        }
        if (center) {
            return this.center();
        }
        return true;
    }

    public void smooth() {
        int n;
        this.m_w = this.m_w.smooth();
        double[] w = this.m_w.getCoefficients();
        for (n = w.length; n > 0 && w[n - 1] == 0.0; --n) {
        }
        if (n == 0) {
            this.m_lb = 0;
            this.m_w = Polynomial.ZERO;
            return;
        }
        int beg = 0;
        while (beg < n && w[beg] == 0.0) {
            ++beg;
            ++this.m_lb;
        }
        if (beg != 0 || n != w.length) {
            int nc = n - beg;
            double[] wc = new double[nc];
            System.arraycopy(w, beg, wc, 0, nc);
            this.m_w = Polynomial.of(wc);
        }
    }

    public String toString() {
        Polynomial p = this.m_w.smooth();
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(4);
        format.setMinimumFractionDigits(4);
        StringBuilder buffer = new StringBuilder(512);
        int curp = this.m_lb;
        int n = p.getDegree();
        int i = 0;
        while (i <= n) {
            double v = Math.abs(p.get(i));
            if (v >= 1.0E-6) {
                if (v > p.get(i)) {
                    buffer.append(" - ");
                } else if (i > 0) {
                    buffer.append(" + ");
                }
                if (v != 1.0 || curp == 0) {
                    buffer.append(format.format(v));
                }
                if (curp < 0) {
                    buffer.append(' ').append('B');
                    if (curp < -1) {
                        buffer.append('^').append(-curp);
                    }
                } else if (curp > 0) {
                    buffer.append(' ').append('F');
                    if (curp > 1) {
                        buffer.append('^').append(curp);
                    }
                }
            }
            ++i;
            ++curp;
        }
        return buffer.toString();
    }
}

