/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.satoolkit.seats.IModelApproximator;
import ec.satoolkit.seats.SeatsContext;
import ec.satoolkit.seats.SeatsModel;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;

@Deprecated
public class DefaultModelApproximator
implements IModelApproximator {
    private char m_status;
    private static final double[] AIRQ = new double[]{-1.50568861051561E7, -4078642.71885349, 1.25495713468045E8, 3.72893488076512E7, -4.79316449488926E8, -1.55227766622531E8, 1.11199260604581E9, 3.89926250516196E8, -1.75105862443012E9, -6.60203090340804E8, 1.98087443551278E9, 7.96938928504665E8, -1.66146607023159E9, -7.07321965792925E8, 1.0510061029552E9, 4.6914829326734E8, -5.04888372223982E8, -2.33997977625452E8, 1.83900005449306E8, 8.76043491537447E7, -5.02818844050958E7, -2.4386669522512E7, 1.01154607380367E7, 4959204.21687316, -1447199.24386675, -716551.068193267, 138950.643779603, 70587.0266796903, -7978.45888823479, -4457.2794695701, 183.67293330126, 161.704844615717, 6.28102914263037, -1.85013363024192, -0.467101412373999, -0.314388900223822};
    private static final double[] AIRM = new double[]{1.95347563065735E7, 1.40869407022632E7, -1.82924843962725E8, -1.24837916382162E8, 7.84012309810082E8, 5.06656270824311E8, -2.03824923561787E9, -1.24723236243656E9, 3.59083883274152E9, 2.07891569193133E9, -4.53585473370324E9, -2.48015536619207E9, 4.2391844675641E9, 2.18248985662395E9, -2.98178573585705E9, -1.4385310311621E9, 1.59018446079529E9, 7.13771251305322E8, -6.4282447023853E8, -2.65666810599684E8, 1.95564418343889E8, 7.33014344799244E7, -4.41316525032554E7, -1.46797381353294E7, 7217478.45147075, 2065102.68195992, -825912.908016856, -194312.700336529, 62692.1279186573, 11348.7961429655, -2901.28263818433, -364.564339836437, 70.7021116258866, 5.00986705245536, -0.806732206713255, -0.129571848439844, -0.150316939442371};
    private static final double[] D2Q = new double[]{-7368.86387334525, 5710.43080817024, 48965.504145987, -27204.0336684033, -140067.644904055, 53806.8353807028, 226611.284963096, -56288.6010543245, -228695.251634143, 32156.8573231266, 149568.75438303, -8389.54361805799, -63758.2467027026, -493.25676347804, 17390.2925238205, 903.967061027686, -2911.11942281865, -225.70146839166, 277.900060158067, 23.681866316816, -13.2508103079524, -0.999194312958687, 0.239589706532146, 0.0113994409953707, -6.95571335187068E-4};
    private static final double[] D2M = new double[]{-616086.458289453, -1932059.65815733, 1888404.63291657, 9787019.10995365, -1114441.8842398, -2.21556751224427E7, -3177476.95176425, 2.95610373631368E7, 7132309.14290129, -2.5792913587434E7, -6937541.06056724, 1.54167965673704E7, 3964374.23488546, -6416573.28297885, -1416866.9210558, 1848617.84825349, 314705.412928108, -358340.765118489, -41054.534775024, 44170.2532829458, 2792.7788714653, -3154.13411558056, -79.0998715967224, 114.532961893102, -0.69086654460248, -0.920391422924575, -0.595788710264705, -0.682655329201659};

    private boolean app_a(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        spec.setQ(2);
        if (spec.getP() > 0 && cur.phi(1) < -0.5) {
            spec.setD(1);
        } else {
            spec.setP(0);
        }
        this.m_status = (char)67;
        sm.setModelSpecification(spec);
        return this.estimateModel(true, sm, info, context);
    }

    private boolean app_b(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        this.m_status = (char)90;
        spec.setQ(1);
        sm.setModelSpecification(spec);
        return this.estimateModel(true, sm, info, context);
    }

    private boolean app_bdd0(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        spec.setP(1);
        spec.setQ(2);
        this.m_status = (char)65;
        sm.setModelSpecification(spec);
        return this.estimateModel(true, sm, info, context);
    }

    private boolean app_bdd1(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        spec.setQ(Math.max(1, spec.getQ() - 1));
        sm.setModelSpecification(spec);
        return this.estimateModel(true, sm, info, context);
    }

    private boolean app_bdd2(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        if (spec.getQ() == 0) {
            spec.setQ(1);
            sm.setModelSpecification(spec);
            return this.estimateModel(true, sm, info, context);
        }
        double rdroot = 0.0;
        Complex[] proots = cur.getRegularMA().roots();
        for (int i = 0; i < proots.length; ++i) {
            double re = proots[i].getRe();
            double im = proots[i].getIm();
            if (im != 0.0 || !(re > 0.0) || !((re = 1.0 / re) > rdroot)) continue;
            rdroot = re;
        }
        spec.setQ(spec.getQ() - 1);
        if (rdroot > 0.5) {
            spec.setD(spec.getD() - 1);
            sm.setMeanCorrection(true);
            this.m_status = (char)67;
        } else {
            spec.setQ(Math.max(1, spec.getQ()));
        }
        sm.setModelSpecification(spec);
        return this.estimateModel(true, sm, info, context);
    }

    private boolean app_bdq(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        if (cur.btheta(1) > 0.0) {
            spec.setBD(1);
            spec.setBQ(1);
        } else {
            spec.setBQ(0);
        }
        sm.setModelSpecification(spec);
        return this.estimateModel(false, sm, info, context);
    }

    private boolean app_c(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        spec.setQ(Math.max(spec.getQ() - 1, 1));
        sm.setModelSpecification(spec);
        return this.estimateModel(true, sm, info, context);
    }

    private boolean app_d(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        spec.setD(2);
        spec.setQ(1);
        spec.setBD(1);
        spec.setBQ(1);
        sm.setMeanCorrection(false);
        this.m_status = (char)69;
        sm.setModelSpecification(spec);
        return this.estimateModel(false, sm, info, context);
    }

    private boolean app_d0(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        if (spec.getQ() > 2) {
            spec.setQ(2);
            this.m_status = (char)73;
        } else if (spec.getQ() > 1) {
            spec.setQ(1);
            this.m_status = (char)72;
        } else {
            spec.setD(1);
            spec.setQ(1);
            spec.setBD(1);
            spec.setBQ(1);
            sm.setMeanCorrection(true);
            this.m_status = (char)70;
        }
        sm.setModelSpecification(spec);
        return this.estimateModel(false, sm, info, context);
    }

    private boolean app_d1(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        boolean ml = true;
        if (spec.getQ() > 2) {
            spec.setQ(2);
            ml = false;
            this.m_status = (char)71;
        } else {
            spec.setQ(1);
        }
        sm.setModelSpecification(spec);
        return this.estimateModel(ml, sm, info, context);
    }

    private boolean app_e(SeatsModel sm, InformationSet info, SeatsContext context) {
        this.app_ef(sm, info, context);
        SarimaModel cur = sm.getSarima().clone();
        if (cur.getSpecification().getBQ() > 0 && cur.btheta(1) > -0.1) {
            cur.setBTheta(1, 0.0);
            cur.adjustSpecification();
        }
        sm.setModel(cur);
        return true;
    }

    private boolean app_ef(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima().clone();
        SarimaSpecification spec = cur.getSpecification();
        sm.setMeanCorrection(true);
        if (spec.getD() == 2) {
            if (spec.getBQ() > 0 && cur.btheta(1) > -0.1) {
                cur.setBTheta(1, -0.1);
            }
            if (spec.getQ() > 0) {
                if (spec.getFrequency() == 12) {
                    double mtheta = -0.5555555555555556 * (cur.btheta(1) + 1.0);
                    if (cur.theta(1) > mtheta) {
                        cur.setTheta(1, mtheta);
                    }
                } else {
                    double mtheta = -0.2727272727272727 * (cur.btheta(1) + 0.1) + 0.6;
                    if (cur.theta(1) > mtheta) {
                        cur.setTheta(1, mtheta);
                    }
                }
            }
        } else {
            cur.setBTheta(1, DefaultModelApproximator.polyval(cur.theta(1), spec.getFrequency(), spec.getD()));
        }
        sm.setModel(cur);
        return true;
    }

    private boolean app_f(SeatsModel sm, InformationSet info, SeatsContext context) {
        if (!this.app_ef(sm, info, context)) {
            return false;
        }
        SarimaModel cur = sm.getSarima().clone();
        if (cur.getSpecification().getBQ() > 0 && cur.btheta(1) > 0.0) {
            cur.setBTheta(1, 0.0);
            cur.adjustSpecification();
        }
        sm.setModel(cur);
        return true;
    }

    private boolean app_g(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        spec.setD(1);
        spec.setQ(1);
        spec.setBD(1);
        spec.setBQ(1);
        sm.setMeanCorrection(true);
        this.m_status = (char)70;
        sm.setModelSpecification(spec);
        return this.estimateModel(false, sm, info, context);
    }

    private boolean app_h(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        spec.setD(1);
        spec.setQ(1);
        spec.setBD(1);
        spec.setBQ(1);
        sm.setMeanCorrection(false);
        this.m_status = (char)70;
        sm.setModelSpecification(spec);
        return this.estimateModel(false, sm, info, context);
    }

    private boolean app_i(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        spec.setQ(1);
        sm.setMeanCorrection(false);
        this.m_status = (char)72;
        return this.estimateModel(false, sm, info, context);
    }

    private boolean app_last(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        spec.setD(2);
        spec.setQ(2);
        spec.setBD(1);
        spec.setBQ(1);
        sm.setMeanCorrection(false);
        this.m_status = (char)68;
        sm.setModelSpecification(spec);
        return this.estimateModel(false, sm, info, context);
    }

    private boolean app_redbp(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        spec.setBP(0);
        spec.setBD(1);
        spec.setBQ(1);
        sm.setModelSpecification(spec);
        return this.estimateModel(false, sm, info, context);
    }

    private boolean app_redp(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        double rdroot = 0.0;
        Complex[] proots = cur.getRegularAR().roots();
        for (int i = 0; i < proots.length; ++i) {
            double re = proots[i].getRe();
            double im = proots[i].getIm();
            if (im != 0.0 || !(re > 0.0) || !((re = 1.0 / re) > rdroot)) continue;
            rdroot = re;
        }
        spec.setP(spec.getP() - 1);
        if (rdroot > 0.5) {
            spec.setD(Math.min(spec.getD() + 1, 2));
            sm.setMeanCorrection(false);
        } else {
            sm.setMeanCorrection(true);
        }
        int q = spec.getQ();
        q = Math.min(q + 1, spec.getD() + spec.getP());
        if (q <= 3) {
            spec.setQ(q);
        } else {
            spec.airline();
        }
        sm.setModelSpecification(spec);
        return this.estimateModel(true, sm, info, context);
    }

    private boolean app_z(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaSpecification spec = sm.getSarima().getSpecification();
        if (spec.getP() == 0 && spec.getBP() == 0 && spec.getQ() == 1 && spec.getBQ() == 1 && (spec.getD() == 1 || spec.getD() == 2) && spec.getBD() == 1) {
            return this.app_f(sm, info, context);
        }
        if (spec.getP() > 0) {
            return this.app_redp(sm, info, context);
        }
        if (spec.getBP() > 0) {
            return this.app_redbp(sm, info, context);
        }
        if (spec.getBD() == 0) {
            if (spec.getBQ() > 0) {
                return this.app_bdq(sm, info, context);
            }
            if (spec.getD() == 2) {
                return this.app_bdd2(sm, info, context);
            }
            if (spec.getD() == 1) {
                return this.app_bdd1(sm, info, context);
            }
            return this.app_bdd0(sm, info, context);
        }
        if (spec.getD() == 0) {
            return this.app_d0(sm, info, context);
        }
        if (spec.getD() == 1) {
            return this.app_d1(sm, info, context);
        }
        return this.app_last(sm, info, context);
    }

    @Override
    public boolean approximate(SeatsModel sm, InformationSet info, SeatsContext context) {
        switch (this.m_status) {
            case 'A': {
                return this.app_a(sm, info, context);
            }
            case 'B': {
                return this.app_b(sm, info, context);
            }
            case 'C': {
                return this.app_c(sm, info, context);
            }
            case 'D': {
                return this.app_d(sm, info, context);
            }
            case 'E': {
                return this.app_e(sm, info, context);
            }
            case 'F': {
                return this.app_f(sm, info, context);
            }
            case 'G': {
                return this.app_g(sm, info, context);
            }
            case 'H': {
                return this.app_h(sm, info, context);
            }
            case 'I': {
                return this.app_i(sm, info, context);
            }
        }
        return this.app_z(sm, info, context);
    }

    private boolean estimateModel(boolean ml, SeatsModel model, InformationSet info, SeatsContext context) {
        return context.getEstimator().estimate(ml, model, info);
    }

    public static double polyval(double theta, int mq, int d) {
        double rslt = 0.0;
        double ptheta = 1.0;
        if (d == 2) {
            if (mq == 4) {
                int i = D2Q.length - 1;
                while (i >= 0) {
                    rslt += D2Q[i] * ptheta;
                    --i;
                    ptheta *= -theta;
                }
            } else {
                int i = D2M.length - 1;
                while (i >= 0) {
                    rslt += D2M[i] * ptheta;
                    --i;
                    ptheta *= -theta;
                }
            }
            if ((rslt = -rslt + 0.075) > 0.98) {
                rslt = 0.98;
            } else if (rslt < -0.98) {
                rslt = -0.98;
            }
        } else {
            if (mq == 4) {
                int i = AIRQ.length - 1;
                while (i >= 0) {
                    rslt += AIRQ[i] * ptheta;
                    --i;
                    ptheta *= theta;
                }
            } else {
                int i = AIRM.length - 1;
                while (i >= 0) {
                    rslt += AIRM[i] * ptheta;
                    --i;
                    ptheta *= theta;
                }
            }
            rslt += 0.01;
            rslt = (rslt = rslt * 100.0 + 1.0) < 0.0 ? (double)((int)(rslt - 0.5)) : (double)((int)(rslt + 0.5));
            rslt /= 100.0;
        }
        return rslt;
    }

    @Override
    public boolean pretest(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        boolean recalc = false;
        if (spec.getBD() == 0 && spec.getBQ() == 1) {
            if (spec.getBP() == 0) {
                if (cur.btheta(1) > 0.0) {
                    spec.setBD(1);
                    recalc = true;
                } else {
                    spec.setBQ(0);
                    recalc = true;
                }
            } else if (cur.bphi(1) < 0.0) {
                spec.setBD(1);
                spec.setBP(0);
                recalc = true;
            }
            if (recalc) {
                sm.setModelSpecification(spec);
                if (this.estimateModel(true, sm, info, context)) {
                    cur = sm.getSarima();
                }
                recalc = false;
            }
        }
        if (spec.getBP() > 0 && cur.bphi(1) > 0.0) {
            recalc = true;
            if (spec.getBD() == 1 && spec.getBQ() == 1) {
                spec.setBP(0);
                sm.setMeanCorrection(true);
            } else if (spec.getBD() == 1 && spec.getBQ() == 0) {
                spec.setBP(0);
                spec.setBQ(1);
                sm.setMeanCorrection(true);
            } else if (spec.getBD() == 0 && spec.getBQ() == 1) {
                if (cur.bphi(1) < 0.1 + cur.btheta(1)) {
                    spec.setBD(1);
                    spec.setBQ(1);
                    sm.setMeanCorrection(false);
                } else {
                    spec.setBP(0);
                    spec.setBQ(0);
                }
            } else {
                spec.setBP(0);
                sm.setMeanCorrection(true);
            }
        }
        if (recalc) {
            sm.setModelSpecification(spec);
            return this.estimateModel(true, sm, info, context);
        }
        return false;
    }

    @Override
    public void startApproximation() {
        this.m_status = (char)90;
    }
}

