/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.arima.IModelEstimator;
import ec.tstoolkit.modelling.arima.IOutliersDetectionModule;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.tramo.ModelComparator;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import java.util.Comparator;

@Deprecated
public class ModelBenchmarking2 {
    private IOutliersDetectionModule outliers_;
    private IModelEstimator estimator_;
    private Comparator<PreprocessingModel> comparator_ = new ModelComparator();

    public void setOutliersDetectionModule(IOutliersDetectionModule outliers) {
        this.outliers_ = outliers;
    }

    public void setEstimator(IModelEstimator estimator) {
        this.estimator_ = estimator;
    }

    public Comparator<PreprocessingModel> getComparator() {
        return this.comparator_;
    }

    public void setComparator(Comparator<PreprocessingModel> cmp) {
        this.comparator_ = cmp;
    }

    public PreprocessingModel process(ModellingContext context) {
        PreprocessingModel pref;
        PreprocessingModel rslt = context.current(true);
        SarimaSpecification spec = rslt.description.getSpecification();
        if (spec.isAirline(context.hasseas)) {
            return rslt;
        }
        boolean hasseas = spec.hasSeasonalPart();
        ModellingContext scontext = new ModellingContext();
        scontext.description = rslt.description.clone();
        scontext.description.setAirline(context.hasseas);
        scontext.description.setMean(false);
        scontext.description.setOutliers(null);
        do {
            scontext.description.setOutliers(null);
            if (this.outliers_ != null) {
                this.outliers_.process(scontext);
            }
            if (this.estimator_.estimate(scontext)) continue;
            return rslt;
        } while (this.simplify(scontext));
        ModellingContext nscontext = null;
        if (!hasseas) {
            nscontext = new ModellingContext();
            nscontext.description = rslt.description.clone();
            SarimaSpecification nsspec = new SarimaSpecification(spec.getFrequency());
            nsspec.setD(1);
            nsspec.setQ(1);
            nscontext.description.setSpecification(nsspec);
            nscontext.description.setMean(false);
            nscontext.description.setOutliers(null);
            do {
                nscontext.description.setOutliers(null);
                if (this.outliers_ != null) {
                    this.outliers_.process(nscontext);
                }
                if (this.estimator_.estimate(nscontext)) continue;
                nscontext = null;
            } while (this.simplify(nscontext));
        }
        if (hasseas) {
            pref = this.compare(rslt, scontext.current(true));
            return pref;
        }
        pref = this.compare(rslt, nscontext.current(true));
        return pref;
    }

    private PreprocessingModel compare(PreprocessingModel f, PreprocessingModel m) {
        return this.comparator_.compare(f, m) > 0 ? m : f;
    }

    private boolean simplify(ModellingContext context) {
        IParametricMapping<SarimaModel> mapper = context.description.defaultMapping();
        if (mapper.getDim() == 0) {
            return false;
        }
        DataBlock p = new DataBlock(mapper.map(context.estimation.getArima()));
        DataBlock pvar = context.estimation.getParametersCovariance().diagonal();
        boolean changed = false;
        for (int i = 0; i < p.getLength(); ++i) {
            if (!(Math.abs(p.get(i) / Math.sqrt(pvar.get(i))) < 1.0)) continue;
            p.set(i, 0.0);
            changed = true;
        }
        if (changed) {
            SarimaModel n = mapper.map(p);
            n.adjustSpecification();
            context.description.setSpecification(n.getSpecification());
            context.estimation = null;
            return true;
        }
        return false;
    }
}

