/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.PreadjustmentType;
import ec.tstoolkit.timeseries.regression.AbstractSingleTsVariable;
import ec.tstoolkit.timeseries.regression.EasterVariable;
import ec.tstoolkit.timeseries.regression.JulianEasterVariable;
import java.util.List;

public class PreprocessingModelBuilder {
    public static boolean updateCalendar(ModelDescription model, boolean usecalendar) {
        List<Variable> cals = model.selectVariables(var -> var.status.needTesting() && var.isCalendar());
        if (cals.isEmpty()) {
            return false;
        }
        boolean changed = false;
        if (usecalendar) {
            for (Variable cal : cals) {
                if (!cal.status.isSelected()) {
                    changed = true;
                }
                cal.status = RegStatus.Accepted;
            }
        } else {
            for (Variable cal : cals) {
                if (cal.status.isSelected()) {
                    changed = true;
                }
                cal.status = RegStatus.Rejected;
            }
        }
        if (changed && model.getPreadjustmentType() == PreadjustmentType.Auto) {
            model.invalidateData();
        }
        return changed;
    }

    public static boolean updateEaster(ModelDescription model, int duration) {
        List<Variable> mhs = model.selectVariables(var -> var.status.needTesting() && var.isMovingHoliday());
        boolean changed = false;
        for (Variable mh : mhs) {
            AbstractSingleTsVariable easter;
            AbstractSingleTsVariable old;
            if (mh.getVariable() instanceof EasterVariable) {
                if (duration == 0) {
                    if (mh.status.isSelected()) {
                        changed = true;
                    }
                    mh.status = RegStatus.Rejected;
                    continue;
                }
                old = (EasterVariable)mh.getVariable();
                if (old == null) continue;
                if (((EasterVariable)old).getDuration() != duration) {
                    easter = new EasterVariable();
                    ((EasterVariable)easter).setType(((EasterVariable)old).getType());
                    ((EasterVariable)easter).setDuration(duration);
                    mh.setVariable(easter);
                    mh.status = RegStatus.Accepted;
                    changed = true;
                } else {
                    changed = !mh.status.isSelected();
                }
                mh.status = RegStatus.Accepted;
                continue;
            }
            if (!(mh.getVariable() instanceof JulianEasterVariable)) continue;
            if (duration == 0) {
                if (mh.status.isSelected()) {
                    changed = true;
                }
                mh.status = RegStatus.Rejected;
                continue;
            }
            old = (JulianEasterVariable)mh.getVariable();
            if (old == null) continue;
            if (((JulianEasterVariable)old).getDuration() != duration) {
                easter = new JulianEasterVariable();
                ((JulianEasterVariable)easter).setDuration(duration);
                mh.setVariable(easter);
                mh.status = RegStatus.Accepted;
                changed = true;
            } else {
                changed = !mh.status.isSelected();
            }
            mh.status = RegStatus.Accepted;
        }
        return changed;
    }
}

