/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.calendars.Utilities;
import ec.tstoolkit.timeseries.regression.AbstractSingleTsVariable;
import ec.tstoolkit.timeseries.regression.IEasterVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.GregorianCalendar;

public class EasterVariable
extends AbstractSingleTsVariable
implements IEasterVariable {
    private static final double[] EMeans_Feb = new double[]{0.00368, 0.002083333, 0.001130435, 2.727273E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final double[] EMeans_Mar = new double[]{0.6576, 0.6450833, 0.6311304, 0.6162727, 0.5999048, 0.583, 0.5661053, 0.549, 0.5318824, 0.514625, 0.4973333, 0.4807143, 0.4643077, 0.4476667, 0.4305455, 0.4136, 0.3975556, 0.382, 0.3654286, 0.3483333, 0.3304, 0.3125, 0.2966667, 0.281, 0.266};
    private static final double[] EMeans_Apr = new double[]{0.33872, 0.3528333, 0.3677391, 0.3834545, 0.4000952, 0.417, 0.4338947, 0.451, 0.4681176, 0.485375, 0.5026667, 0.5192857, 0.5356923, 0.5523333, 0.5694545, 0.5864, 0.6024444, 0.618, 0.6345714, 0.6516667, 0.6696, 0.6875, 0.7033333, 0.719, 0.734};
    private int dur_ = 6;
    private Correction type_ = Correction.Simple;
    private boolean m_e;
    private boolean m_m;

    @Override
    public int getDuration() {
        return this.dur_;
    }

    @Override
    public void setDuration(int value) {
        this.dur_ = value;
    }

    public Correction getType() {
        return this.type_;
    }

    public void setType(Correction value) {
        this.type_ = value;
    }

    public boolean hasEaster() {
        return this.m_e;
    }

    public boolean hasEasterMonday() {
        return this.m_m;
    }

    public void includeEaster(boolean included) {
        this.m_e = included;
        if (!this.m_e) {
            this.m_m = false;
        }
    }

    public void includeEasterMonday(boolean included) {
        this.m_m = included;
        if (this.m_m) {
            this.m_e = true;
        }
    }

    @Override
    public String getDescription(TsFrequency context) {
        StringBuilder builder = new StringBuilder();
        builder.append("Easter [").append(this.dur_).append(']');
        return builder.toString();
    }

    @Override
    public void data(TsPeriod start, DataBlock data) {
        int idx;
        data.set(0.0);
        int freq = start.getFrequency().intValue();
        if (freq != 12 && freq != 4 || this.dur_ < 1 || this.dur_ > 25) {
            return;
        }
        int n = data.getLength();
        int c = 12 / freq;
        int y0 = start.getYear();
        int p0 = start.getPosition() * c;
        if (p0 > 3) {
            p0 -= 12;
            ++y0;
        }
        if ((idx = (3 - p0) / c) > n) {
            return;
        }
        double dur = this.dur_;
        GregorianCalendar easter = new GregorianCalendar();
        int y = y0;
        while (idx <= n) {
            easter.setTime(Utilities.easter(y).getTime());
            int day = easter.get(5);
            int month = easter.get(2);
            if (!this.m_e) {
                --day;
            } else if (this.m_m) {
                if (day == 31) {
                    day = 1;
                    ++month;
                } else {
                    ++day;
                }
            }
            double m = 0.0;
            double a = 0.0;
            if (this.type_ == Correction.Simple) {
                if (month == 2 || day == 0) {
                    m = 0.5;
                    a = -0.5;
                } else if (day >= this.dur_) {
                    m = -0.5;
                    a = 0.5;
                } else {
                    m = (dur - (double)day) / dur - 0.5;
                    a = -m;
                }
            } else {
                double m_av = 0.0;
                double a_av = 0.0;
                if (this.type_ == Correction.PreComputed) {
                    m_av = EMeans_Mar[25 - this.dur_];
                    a_av = EMeans_Apr[25 - this.dur_];
                } else {
                    m_av = (15.0 + dur) / 59.06118;
                    a_av = 1.0 - m_av;
                }
                if (month == 2) {
                    m = 1.0 - m_av;
                    a = -a_av;
                } else if (day >= this.dur_) {
                    m = -m_av;
                    a = 1.0 - a_av;
                } else {
                    m = (dur - (double)day) / dur - m_av;
                    a = (double)day / dur - a_av;
                }
            }
            if (idx - 1 >= 0) {
                data.set(idx - 1, m);
            }
            if (idx < n) {
                data.set(idx, a);
            }
            ++y;
            idx += freq;
        }
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        return domain.getFrequency() != TsFrequency.Yearly;
    }

    public static enum Correction {
        Simple,
        PreComputed,
        Theoretical;

    }
}

