/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.arima.IModelBuilder;
import ec.tstoolkit.modelling.arima.IModelEstimator;
import ec.tstoolkit.modelling.arima.IOutliersDetectionModule;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.ISeriesScaling;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.RegArimaEstimator;
import ec.tstoolkit.modelling.arima.x13.FinalEstimator;
import ec.tstoolkit.modelling.arima.x13.MeanController;
import ec.tstoolkit.modelling.arima.x13.ModelController;
import ec.tstoolkit.modelling.arima.x13.RegressionVariablesTest;
import ec.tstoolkit.sarima.SarimaComponent;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.SarimaFixedMapping;
import ec.tstoolkit.sarima.estimation.SarimaMapping;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.ITsDataInterpolator;
import ec.tstoolkit.timeseries.simplets.TsData;

public class X13Preprocessor
implements IPreprocessor {
    public TsPeriodSelector estimateSpan;
    public IModelBuilder builder;
    public ISeriesScaling scaling;
    public ITsDataInterpolator missing;
    public IPreprocessingModule loglevelTest;
    public IPreprocessingModule tdTest;
    public IPreprocessingModule easterTest;
    public IPreprocessingModule userTest;
    public IOutliersDetectionModule outliers;
    public IPreprocessingModule autoModelling;
    private IPreprocessingModule regressionTest0 = new RegressionVariablesTest(false, 1.96, true);
    public IPreprocessingModule regressionTest1 = new RegressionVariablesTest(1.96, 1.0);
    public IModelEstimator estimator;
    public IModelEstimator finalizer = new FinalEstimator();
    private double pcr_ = 0.95;
    private double cpcr_;
    private double plbox_;
    private double rvr_;
    private double rtval_;
    private int refsens_;
    private int loop_;
    private int round_;
    private boolean acceptAirline = false;
    private PreprocessingModel reference_;
    private static final double FCT = 1.0126582278481011;
    private static final double FCT2 = 1.0;
    private static final double MALIM = 0.001;
    private boolean checkMu_ = true;
    private boolean needAutoModelling_;
    private boolean needOutliers_;
    private boolean mixedModel_ = true;
    public static final int MAXD = 2;
    public static final int MAXBD = 1;
    private double ur_ = 0.95;

    public static IParametricMapping<SarimaModel> createDefaultMapping(ModelDescription desc) {
        SarimaComponent arima = desc.getArimaComponent();
        if (arima.getFixedParametersCount() == 0) {
            return new SarimaMapping(arima.getSpecification(), false);
        }
        return new SarimaFixedMapping(arima.getSpecification(), arima.getParameters(), arima.getFixedConstraints());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreprocessingModel makeProcessing(ModellingContext context) {
        try {
            Object controller;
            block27: {
                block28: {
                    this.clear();
                    this.builder.initialize(context);
                    if (this.scaling != null && !this.scaling.process(context)) {
                        PreprocessingModel preprocessingModel = null;
                        return preprocessingModel;
                    }
                    if (this.missing != null && !context.description.updateMissing(this.missing)) {
                        PreprocessingModel preprocessingModel = null;
                        return preprocessingModel;
                    }
                    if (context.description.isFullySpecified() && this.outliers == null) {
                        IParametricMapping<SarimaModel> mapping = context.description.defaultMapping();
                        ModelDescription model = context.description;
                        RegArimaModel<SarimaModel> regarima = model.buildRegArima();
                        RegArimaEstimator monitor = new RegArimaEstimator(mapping);
                        monitor.getMinimizer().setMaxIter(1);
                        monitor.optimize(regarima);
                        ModelEstimation estimation = new ModelEstimation(regarima, model.getLikelihoodCorrection());
                        estimation.computeLikelihood(mapping.getDim());
                        estimation.updateParametersCovariance(monitor.getParametersCovariance());
                        PreprocessingModel preprocessingModel = new PreprocessingModel(model, estimation);
                        return preprocessingModel;
                    }
                    this.runTransformations(context);
                    this.regAIC(context);
                    this.checkMu(context, true);
                    this.estimator.estimate(context);
                    if (this.needOutliers_) {
                        ProcessingResult changed = this.outliers.process(context);
                        if (context.estimation == null) {
                            this.estimator.estimate(context);
                        }
                        if (changed == ProcessingResult.Changed) {
                            this.regressionTest0.process(context);
                        }
                    }
                    if (!this.needAutoModelling_) break block28;
                    if (context.estimation == null) {
                        this.estimator.estimate(context);
                    }
                    controller = new ModelController();
                    boolean ok = ((ModelController)controller).accept(context);
                    this.reference_ = context.current(false);
                    this.plbox_ = 1.0 - ((ModelController)controller).getLjungBoxTest().getPValue();
                    this.rvr_ = ((ModelController)controller).getRvr();
                    this.rtval_ = ((ModelController)controller).getRTval();
                    if (this.acceptAirline && ok) break block27;
                    this.round_ = 1;
                    this.loop_ = 1;
                    do {
                        ProcessingResult changed;
                        boolean defModel = false;
                        if (this.needAutoModelling_) {
                            ProcessingResult result = this.execAutoModelling(context);
                            boolean bl = defModel = result != ProcessingResult.Changed;
                            if (!defModel) {
                                context.description.setOutliers(null);
                                context.estimation = null;
                                boolean bl2 = this.needOutliers_ = this.outliers != null;
                            }
                            if (context.estimation == null) {
                                this.estimator.estimate(context);
                            }
                            if (!defModel || this.loop_ > 1) {
                                this.regAIC(context);
                            }
                        }
                        if (this.needOutliers_) {
                            this.outliers.process(context);
                            if (context.estimation == null) {
                                this.estimator.estimate(context);
                            }
                        }
                        if (this.outliers != null && this.loop_ <= 2 && !this.pass2(defModel, context)) continue;
                        if (this.regressionTest1 != null && (changed = this.regressionTest1.process(context)) == ProcessingResult.Changed) {
                            if (this.loop_ < 3) {
                                this.loop_ = 3;
                            }
                            if (context.estimation == null) {
                                this.estimator.estimate(context);
                            }
                        }
                        this.checkUnitRoots(context);
                        this.checkMA(context);
                        if (context.automodelling && !context.description.isMean() && Math.abs(this.rtval_) > 2.5 && this.checkMu_) {
                            context.description.setMean(true);
                        }
                        if (this.finalizer.estimate(context)) break block27;
                        if (this.loop_ > 2 || this.outliers == null) continue;
                        this.outliers.reduceSelectivity();
                        this.needOutliers_ = true;
                        this.needAutoModelling_ = true;
                    } while (this.round_++ < 5);
                    break block27;
                    {
                    }
                }
                this.estimator.estimate(context);
            }
            controller = context.current(true);
            return controller;
        }
        catch (Exception err) {
            PreprocessingModel preprocessingModel = null;
            return preprocessingModel;
        }
        finally {
            this.clear();
        }
    }

    public boolean isCheckMu() {
        return this.checkMu_;
    }

    public void setCheckMu(boolean check) {
        if (check != this.checkMu_) {
            this.checkMu_ = check;
            this.regressionTest0 = new RegressionVariablesTest(false, 1.96, check);
        }
    }

    public boolean isMixed() {
        return this.mixedModel_;
    }

    public void setMixed(boolean mixed) {
        this.mixedModel_ = mixed;
    }

    public double getLjungBoxLimit() {
        return this.pcr_;
    }

    public void setLjungBoxLimit(double val) {
        this.pcr_ = val;
    }

    protected boolean runTransformations(ModellingContext context) {
        if (this.loglevelTest != null) {
            this.loglevelTest.process(context);
        }
        return true;
    }

    private ProcessingResult execAutoModelling(ModellingContext context) {
        return this.autoModelling.process(context);
    }

    @Override
    public PreprocessingModel process(TsData originalTs, ModellingContext context) {
        if (context == null) {
            context = new ModellingContext();
        }
        context.description = new ModelDescription(originalTs, this.estimateSpan == null ? null : originalTs.getDomain().select(this.estimateSpan));
        this.initContext(context);
        PreprocessingModel rslt = this.makeProcessing(context);
        if (rslt != null) {
            rslt.info_ = context.information;
            rslt.addProcessingInformation(context.processingLog);
        }
        return rslt;
    }

    private void initContext(ModellingContext context) {
        context.automodelling = this.autoModelling != null;
        context.hasseas = context.description.getFrequency() > 1;
    }

    private void clear() {
        this.loop_ = 0;
        this.cpcr_ = this.pcr_;
        this.refsens_ = 0;
        this.reference_ = null;
        this.plbox_ = 0.0;
        this.rvr_ = 0.0;
        this.rtval_ = 0.0;
        this.needAutoModelling_ = this.autoModelling != null;
        this.needOutliers_ = this.outliers != null;
    }

    private boolean pass2(boolean defModel, ModellingContext context) {
        int ichk = 0;
        int naut = context.description.getOutliers().size();
        int naut0 = this.reference_.description.getOutliers().size();
        SarimaSpecification spec0 = this.reference_.description.getSpecification();
        SarimaSpecification spec = context.description.getSpecification();
        SarimaModel arima = context.estimation.getArima();
        boolean mu0 = this.reference_.description.isEstimatedMean();
        boolean mu = context.description.isEstimatedMean();
        ModelController controller = new ModelController();
        controller.accept(context);
        double rvr = controller.getRvr();
        double plbox = 1.0 - controller.getLjungBoxTest().getPValue();
        if (!(naut0 > naut || spec0.equals((Object)spec) && mu0 == mu)) {
            if (plbox < 0.95 && this.plbox_ < 0.75 && this.rvr_ < rvr) {
                ichk = 1;
            } else if (this.loop_ == 1 && plbox >= 0.95 && this.plbox_ < 0.95) {
                ichk = 2;
            } else if (plbox < 0.95 && this.plbox_ < 0.75 && this.plbox_ < plbox && this.rvr_ < 1.0126582278481011 * rvr) {
                ichk = 3;
            } else if (plbox >= 0.95 && this.plbox_ < 0.95 && this.rvr_ < 1.0 * rvr) {
                ichk = 4;
            } else if (spec.getD() == 0 && spec.getBD() == 1 && spec.getP() == 1 && spec.getBP() == 0 && spec.getQ() == 1 && spec.getBQ() == 1 && arima.phi(1) < -0.82) {
                ichk = 5;
            } else if (spec.getD() == 1 && spec.getBD() == 0 && spec.getP() == 0 && spec.getBP() == 1 && spec.getQ() == 1 && spec.getBQ() == 1 && arima.bphi(1) < -0.65) {
                ichk = 6;
            }
        }
        if (ichk > 0) {
            context.description = this.reference_.description;
            context.estimation = this.reference_.estimation;
            plbox = this.plbox_;
            rvr = this.rvr_;
            defModel = true;
        } else {
            this.rtval_ = controller.getRTval();
            this.rvr_ = rvr;
            this.plbox_ = plbox;
            this.reference_ = context.current(false);
        }
        this.cpcr_ = this.loop_ == 1 ? (this.cpcr_ += 0.025) : (this.cpcr_ += 0.015);
        ++this.loop_;
        if (plbox <= this.cpcr_) {
            return true;
        }
        boolean ncv = false;
        if (this.loop_ == 2 && this.outliers != null) {
            ncv = this.outliers.reduceSelectivity();
            this.needOutliers_ = true;
        }
        boolean bl = this.needAutoModelling_ = !defModel;
        if (this.loop_ > 2 || !ncv) {
            this.lastSolution(context);
            if (this.loop_ == 2) {
                this.loop_ = 3;
            }
        }
        return false;
    }

    private void lastSolution(ModellingContext context) {
        SarimaSpecification nspec = context.description.getSpecification();
        switch (nspec.getFrequency()) {
            case 2: {
                nspec.setP(1);
                break;
            }
            case 3: {
                nspec.setP(2);
                break;
            }
            default: {
                nspec.setP(3);
            }
        }
        if (nspec.getBD() > 0 || nspec.getFrequency() == 1) {
            nspec.setBP(0);
        }
        if (this.mixedModel_) {
            nspec.setQ(1);
        } else {
            nspec.setQ(0);
        }
        if (nspec.getFrequency() > 1) {
            nspec.setBQ(1);
        }
        context.description.setSpecification(nspec);
        this.estimator.estimate(context);
        this.needAutoModelling_ = false;
        if (this.outliers != null) {
            this.outliers.setSelectivity(0);
            this.needOutliers_ = true;
        }
    }

    private ProcessingResult regAIC(ModellingContext context) {
        ProcessingResult rslt = ProcessingResult.Unchanged;
        if (this.tdTest != null && this.tdTest.process(context) == ProcessingResult.Changed) {
            rslt = ProcessingResult.Changed;
        }
        if (this.easterTest != null && this.easterTest.process(context) == ProcessingResult.Changed) {
            rslt = ProcessingResult.Changed;
        }
        if (this.userTest != null && this.userTest.process(context) == ProcessingResult.Changed) {
            rslt = ProcessingResult.Changed;
        }
        return rslt;
    }

    private ProcessingResult checkMu(ModellingContext context, boolean initial) {
        if (!this.checkMu_) {
            return ProcessingResult.Unchanged;
        }
        MeanController meanTest = new MeanController(initial ? 1.96 : 1.6);
        return meanTest.process(context);
    }

    private boolean reduceModel(ModellingContext context) {
        return false;
    }

    private void checkUnitRoots(ModellingContext context) {
        SarimaModel m = context.estimation.getArima();
        SarimaSpecification nspec = m.getSpecification();
        boolean ok = true;
        if (nspec.getP() > 0 && nspec.getD() < 2 && 0 != this.searchur(m.getRegularAR().mirror().roots())) {
            nspec.setP(nspec.getP() - 1);
            nspec.setD(nspec.getD() + 1);
            ok = false;
        }
        if (nspec.getBP() > 0 && nspec.getBD() < 1 && 0 != this.searchur(m.getSeasonalAR().mirror().roots())) {
            nspec.setBP(nspec.getBP() - 1);
            nspec.setBD(nspec.getBD() + 1);
            ok = false;
        }
        if (!ok) {
            context.description.setSpecification(nspec);
            this.redoEstimation(context);
        }
    }

    private void redoEstimation(ModellingContext context) {
        this.estimator.estimate(context);
        if (context.description.isEstimatedMean()) {
            this.checkMu(context, false);
        }
        if (!context.description.getOutliers().isEmpty()) {
            context.description.setOutliers(null);
            context.estimation = null;
        }
        if (context.estimation == null) {
            this.estimator.estimate(context);
        }
        if (this.outliers != null) {
            this.outliers.process(context);
        }
        if (context.estimation == null) {
            this.estimator.estimate(context);
        }
        ModelController controller = new ModelController();
        controller.accept(context);
        this.rtval_ = controller.getRTval();
        this.rvr_ = controller.getRvr();
        this.plbox_ = 1.0 - controller.getLjungBoxTest().getPValue();
        this.reference_ = context.current(false);
    }

    private int searchur(Complex[] r) {
        if (r == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < r.length; ++i) {
            double cdim = Math.abs(r[i].getIm());
            double vcur = r[i].abs();
            if (!(vcur > this.ur_) || !(cdim <= 0.05) || !(r[i].getRe() > 0.0)) continue;
            ++n;
        }
        return n;
    }

    private void checkMA(ModellingContext context) {
        SarimaModel m = context.estimation.getArima();
        SarimaSpecification nspec = m.getSpecification();
        if (nspec.getQ() == 0 || nspec.getD() == 0) {
            return;
        }
        double ma = m.getRegularMA().evaluateAt(1.0);
        if (Math.abs(ma) < 0.001) {
            nspec.setQ(nspec.getQ() - 1);
            nspec.setD(nspec.getD() - 1);
            context.description.setSpecification(nspec);
            context.description.setMean(true);
            this.redoEstimation(context);
        }
    }
}

