/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.AbstractTramoModule;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.sarima.estimation.SarimaInitializer;

public class LogLevelTest
extends AbstractTramoModule
implements IPreprocessingModule {
    private static final String LOG_LEVEL = "Log/level test";
    private static final String LOGS = "Logs chosen";
    private static final String LEVELS = "Levels chosen";
    private double level_;
    private double log_ = 1.0;
    private double slog_;
    private double logpreference_;
    private RegArimaEstimation<SarimaModel> e_;
    private RegArimaEstimation<SarimaModel> el_;

    public RegArimaModel<SarimaModel> buildModel(int ifreq, double[] data, boolean seas) {
        SarimaSpecification spec = new SarimaSpecification(ifreq);
        spec.airline(seas);
        RegArimaModel<SarimaModel> m = new RegArimaModel<SarimaModel>(new SarimaModel(spec), new DataBlock(data));
        m.setMeanCorrection(true);
        return m;
    }

    public void clear() {
        this.level_ = 0.0;
        this.log_ = 1.0;
        this.e_ = null;
        this.el_ = null;
    }

    public RegArimaEstimation<SarimaModel> getLevelEstimation() {
        return this.e_;
    }

    public double getLevelLL() {
        return this.level_;
    }

    public RegArimaEstimation<SarimaModel> getLogEstimation() {
        return this.el_;
    }

    public double getLogLL() {
        return this.log_;
    }

    public double getLogPreference() {
        return this.logpreference_;
    }

    public boolean isChoosingLog() {
        return this.el_ == null ? false : this.log_ + this.logpreference_ < this.level_;
    }

    public void setLogPreference(double value) {
        this.logpreference_ = value;
    }

    public double getLogCorrection() {
        return this.slog_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessingResult process(ModellingContext context) {
        try {
            this.addStartInfo(context);
            this.clear();
            ModelDescription curModel = context.description;
            if (curModel.getTransformation() != DefaultTransformationType.Auto) {
                ProcessingResult processingResult = ProcessingResult.Unprocessed;
                return processingResult;
            }
            context.estimation = null;
            int ifreq = curModel.getFrequency();
            double[] data = curModel.getY();
            RegArimaModel<SarimaModel> reg = this.buildModel(ifreq, data, context.hasseas);
            SarimaInitializer initializer = new SarimaInitializer();
            initializer.useDefaultIfFailed(false);
            GlsSarimaMonitor monitor = this.getMonitor(initializer);
            this.e_ = monitor.process(reg);
            if (this.e_ != null) {
                this.level_ = Math.log(this.e_.likelihood.getSsqErr() * this.e_.likelihood.getFactor());
            }
            double[] ldata = (double[])data.clone();
            this.slog_ = 0.0;
            for (int i = 0; i < ldata.length; ++i) {
                if (ldata[i] <= 0.0) {
                    curModel.setTransformation(DefaultTransformationType.None);
                    ProcessingResult processingResult = ProcessingResult.Changed;
                    return processingResult;
                }
                ldata[i] = Math.log(ldata[i]);
                this.slog_ += ldata[i];
            }
            this.slog_ /= (double)ldata.length;
            reg = this.buildModel(ifreq, ldata, context.hasseas);
            this.el_ = monitor.process(reg);
            if (this.el_ == null) {
                curModel.setTransformation(DefaultTransformationType.None);
                ProcessingResult processingResult = ProcessingResult.Changed;
                return processingResult;
            }
            this.log_ = Math.log(this.el_.likelihood.getSsqErr() * this.el_.likelihood.getFactor()) + 2.0 * this.slog_;
            curModel.setTransformation(this.getTransformation());
            ProcessingResult processingResult = ProcessingResult.Changed;
            return processingResult;
        }
        finally {
            this.addInfo(context.information);
            this.addEndInfo(context);
        }
    }

    public DefaultTransformationType getTransformation() {
        return this.isChoosingLog() ? DefaultTransformationType.Log : DefaultTransformationType.None;
    }

    private void addInfo(InformationSet information) {
        InformationSet subset = information.subSet("transformation");
        subset.set("level", Double.valueOf(this.level_));
        subset.set("log", Double.valueOf(this.log_));
    }

    public boolean hasChangedModel() {
        return true;
    }

    private void addEndInfo(ModellingContext context) {
    }

    private void addStartInfo(ModellingContext context) {
    }

    private void addLogInfo(ModellingContext context) {
    }

    private void addLevelInfo(ModellingContext context) {
    }
}

