/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.ssf.ISsfData;

public class SsfData
implements ISsfData,
Cloneable {
    private final double[] m_data;
    private final double[] m_a0;

    public SsfData(double[] data, double[] a0) {
        this.m_data = (double[])data.clone();
        this.m_a0 = (double[])(a0 != null ? (double[])a0.clone() : null);
    }

    public SsfData(IReadDataBlock data, IReadDataBlock a0) {
        this.m_data = new double[data.getLength()];
        data.copyTo(this.m_data, 0);
        if (a0 != null) {
            this.m_a0 = new double[a0.getLength()];
            a0.copyTo(this.m_a0, 0);
        } else {
            this.m_a0 = null;
        }
    }

    public SsfData clone() {
        try {
            SsfData data = (SsfData)super.clone();
            return data;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    @Override
    public double get(int n) {
        return n >= this.m_data.length ? Double.NaN : this.m_data[n];
    }

    @Override
    public int getCount() {
        return this.m_data.length;
    }

    @Override
    public double[] getInitialState() {
        return this.m_a0;
    }

    @Override
    public int getObsCount() {
        int n = 0;
        for (int i = 0; i < this.m_data.length; ++i) {
            if (Double.isNaN(this.m_data[i])) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public boolean hasMissingValues() {
        for (int i = 0; i < this.m_data.length; ++i) {
            if (!Double.isNaN(this.m_data[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMissing(int pos) {
        return pos >= this.m_data.length || Double.isNaN(this.m_data[pos]);
    }
}

