/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.AbstractModelController;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.ModelComparator;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.GregorianCalendarVariables;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.ArrayList;
import java.util.Optional;

public class TDController
extends AbstractModelController {
    private TradingDaysType td;
    private LengthOfPeriodType lp;
    private double ptd = 0.01;

    public TDController(double ptd) {
        this.ptd = ptd;
        this.td = TradingDaysType.WorkingDays;
        this.lp = LengthOfPeriodType.None;
    }

    public TDController(TradingDaysType td, LengthOfPeriodType lp, double ptd) {
        this.td = td;
        this.lp = lp;
        this.ptd = ptd;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        PreprocessingModel ncurrent;
        if (context.description.contains(var -> var.status.isSelected() && var.isCalendar())) {
            return ProcessingResult.Unchanged;
        }
        if (!this.needProcessing(context)) {
            return ProcessingResult.Unchanged;
        }
        ModelDescription nmodel = this.newModel(context);
        ModellingContext ncontext = new ModellingContext();
        ncontext.description = nmodel;
        ncontext.description.setOutliers(null);
        if (!this.estimate(ncontext, true)) {
            return ProcessingResult.Failed;
        }
        PreprocessingModel current = context.tmpModel();
        int cmp = new ModelComparator().compare(current, ncurrent = ncontext.tmpModel());
        if (cmp < 1) {
            return ProcessingResult.Unchanged;
        }
        this.transferInformation(ncontext, context);
        return ProcessingResult.Changed;
    }

    private boolean needProcessing(ModellingContext context) {
        int i;
        double[] res = context.estimation.getLikelihood().getResiduals();
        RegModel reg = new RegModel();
        reg.setY(new DataBlock(res));
        GregorianCalendarVariables tdvars = this.tdvars(context);
        tdvars.setDayOfWeek(this.td);
        int ntd = this.td.getVariablesCount();
        TsDomain edomain = context.description.getEstimationDomain();
        edomain = edomain.drop(edomain.getLength() - res.length, 0);
        ArrayList<DataBlock> bvars = new ArrayList<DataBlock>(ntd);
        for (i = 0; i < ntd; ++i) {
            bvars.add(new DataBlock(edomain.getLength()));
        }
        tdvars.data(edomain, bvars);
        for (i = 0; i < ntd; ++i) {
            DataBlock cur = (DataBlock)bvars.get(i);
            reg.addX(cur);
        }
        Ols ols = new Ols();
        if (!ols.process(reg)) {
            return false;
        }
        JointRegressionTest test = new JointRegressionTest(this.ptd);
        return test.accept(ols.getLikelihood(), 0, 0, ntd, null);
    }

    private ModelDescription newModel(ModellingContext context) {
        ModelDescription ndesc = context.description.clone();
        GregorianCalendarVariables tdvars = this.tdvars(context);
        tdvars.setDayOfWeek(this.td);
        ndesc.removeVariable(var -> var.isCalendar());
        ndesc.addVariable(Variable.calendarVariable(tdvars, RegStatus.Accepted));
        return ndesc;
    }

    private GregorianCalendarVariables tdvars(ModellingContext context) {
        Optional<Variable> found = context.description.variables().filter(var -> var.isCalendar()).findAny();
        if (found.isPresent()) {
            return ((GregorianCalendarVariables)found.get().getVariable()).clone();
        }
        return GregorianCalendarVariables.getDefault(TradingDaysType.None);
    }
}

