/*
 * Decompiled with CFR 0.152.
 */
package demetra.xml.calendar;

import demetra.xml.XmlWeightedItem;
import demetra.xml.calendar.AbstractXmlCalendar;
import ec.tstoolkit.timeseries.calendars.CompositeGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.GregorianCalendarManager;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.utilities.WeightedItem;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="compositeCalendar")
@XmlType(name="compositeCalendarType")
public class XmlCompositeCalendar
extends AbstractXmlCalendar {
    static final String NAME = "compositeCalendarType";
    @XmlElement(name="wCalendar")
    public XmlWeightedItem[] wcalendars;

    public static XmlCompositeCalendar create(String code, GregorianCalendarManager mgr) {
        IGregorianCalendarProvider cal = (IGregorianCalendarProvider)mgr.get(code);
        if (cal == null || !(cal instanceof CompositeGregorianCalendarProvider)) {
            return null;
        }
        CompositeGregorianCalendarProvider t = (CompositeGregorianCalendarProvider)cal;
        XmlCompositeCalendar xcal = new XmlCompositeCalendar();
        xcal.name = code;
        int n = t.getCount();
        if (n > 0) {
            xcal.wcalendars = new XmlWeightedItem[n];
            int i = 0;
            for (WeightedItem item : t.items()) {
                XmlWeightedItem witem = new XmlWeightedItem();
                witem.weight = item.weight;
                witem.item = (String)item.item;
                if (witem.item == null) {
                    return null;
                }
                xcal.wcalendars[i++] = witem;
            }
        }
        return xcal;
    }

    @Override
    public boolean addTo(GregorianCalendarManager mgr) {
        CompositeGregorianCalendarProvider composite = new CompositeGregorianCalendarProvider(mgr);
        if (this.wcalendars != null) {
            for (int i = 0; i < this.wcalendars.length; ++i) {
                String calendar = this.wcalendars[i].item;
                if (calendar == null) {
                    return false;
                }
                composite.add(new WeightedItem((Object)calendar, this.wcalendars[i].weight));
            }
        }
        if (this.name != null) {
            mgr.set(this.name, (Object)composite);
            return true;
        }
        return false;
    }
}

