/*
 * Decompiled with CFR 0.152.
 */
package demetra.workspace.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IO {
    @Nonnull
    public static Optional<File> getFile(@Nonnull Path path) {
        try {
            return Optional.of(path.toFile());
        }
        catch (UnsupportedOperationException ex) {
            return Optional.empty();
        }
    }

    @Nonnull
    public static Optional<InputStream> getResourceAsStream(@Nonnull Class<?> type, @Nonnull String name) {
        return Optional.ofNullable(type.getResourceAsStream(name));
    }

    @Nonnull
    public static <X extends Throwable> void ensureClosed(@Nonnull X exception, @Nonnull Closeable closeable) {
        Objects.requireNonNull(exception);
        try {
            closeable.close();
        }
        catch (IOException suppressed) {
            try {
                exception.addSuppressed(suppressed);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nonnull
    static <S, R, VALUE> Function<S, VALUE> valueOf(@Nonnull Function<? super S, ? extends R> opener, @Nonnull Function<? super R, ? extends VALUE> reader, @Nonnull Consumer<? super R> closer) {
        Objects.requireNonNull(opener);
        Objects.requireNonNull(reader);
        Objects.requireNonNull(closer);
        return source -> {
            Object resource = opener.applyWithIO((Object)source);
            try (Closeable c = () -> closer.acceptWithIO((Object)resource);){
                Object r = reader.applyWithIO((Object)resource);
                return r;
            }
        };
    }

    @Nonnull
    static <S, R, FLOW extends AutoCloseable> Function<S, FLOW> flowOf(@Nonnull Function<? super S, ? extends R> opener, @Nonnull Function<? super R, ? extends FLOW> reader, @Nonnull Consumer<? super R> closer) {
        Objects.requireNonNull(opener);
        Objects.requireNonNull(reader);
        Objects.requireNonNull(closer);
        return source -> {
            Object resource = opener.applyWithIO((Object)source);
            try {
                return (AutoCloseable)reader.applyWithIO((Object)resource);
            }
            catch (IOException | Error | RuntimeException e) {
                IO.ensureClosed(e, () -> closer.acceptWithIO((Object)resource));
                throw e;
            }
        };
    }

    private IO() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    private static @interface JdkWithIO {
        public String value() default "";
    }

    public static final class Stream {
        @Nonnull
        public static <T extends Closeable, R> java.util.stream.Stream<R> open(@Nonnull Supplier<T> source, @Nonnull Function<? super T, java.util.stream.Stream<R>> streamer) throws IOException {
            return Stream.asParser(streamer).applyWithIO(source);
        }

        @Nonnull
        public static <T> java.util.stream.Stream<T> generateUntilNull(@Nonnull Supplier<T> generator) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Stream.asIterator(generator), 272), false);
        }

        private static <C extends Closeable, R> Function<Supplier<C>, java.util.stream.Stream<R>> asParser(Function<? super C, java.util.stream.Stream<R>> streamer) {
            return IO.flowOf(source -> (Closeable)source.getWithIO(), resource -> (java.util.stream.Stream)((java.util.stream.Stream)streamer.applyWithIO((Object)resource)).onClose(Runnable.unchecked(resource::close)), Closeable::close);
        }

        @Nonnull
        private static <T> Iterator<T> asIterator(final @Nonnull Supplier<T> nextSupplier) {
            Objects.requireNonNull(nextSupplier);
            return new Iterator<T>(){
                T nextElement = null;

                @Override
                public boolean hasNext() {
                    if (this.nextElement != null) {
                        return true;
                    }
                    try {
                        this.nextElement = nextSupplier.getWithIO();
                        return this.nextElement != null;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                @Override
                public T next() {
                    if (this.nextElement != null || this.hasNext()) {
                        Object line = this.nextElement;
                        this.nextElement = null;
                        return line;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        private Stream() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static interface Resource<K>
    extends ResourceLoader<K>,
    ResourceStorer<K> {
    }

    public static interface ResourceStorer<K>
    extends Closeable {
        public void store(@Nonnull K var1, @Nonnull OutputStream var2) throws IOException, IllegalStateException;
    }

    public static interface ResourceLoader<K>
    extends Closeable {
        @Nonnull
        public InputStream load(@Nonnull K var1) throws IOException, IllegalStateException;

        @Nonnull
        public static <K> ResourceLoader<K> of(@Nonnull Function<? super K, ? extends InputStream> loader) {
            return ResourceLoader.of(loader, Runnable.noOp().asCloseable());
        }

        @Nonnull
        public static <K> ResourceLoader<K> of(final @Nonnull Function<? super K, ? extends InputStream> loader, final @Nonnull Closeable closer) {
            Objects.requireNonNull(loader);
            Objects.requireNonNull(closer);
            return new ResourceLoader<K>(){
                boolean closed = false;

                @Override
                public InputStream load(K key) throws IOException {
                    Objects.requireNonNull(key);
                    if (this.closed) {
                        throw new IllegalStateException("Closed");
                    }
                    InputStream result = (InputStream)loader.applyWithIO(key);
                    if (result == null) {
                        throw new IOException("Null stream");
                    }
                    return result;
                }

                @Override
                public void close() throws IOException {
                    this.closed = true;
                    closer.close();
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Consumer<T> {
        public void acceptWithIO(T var1) throws IOException;

        @Nonnull
        default public Consumer<T> andThen(@Nonnull Consumer<? super T> after) {
            Objects.requireNonNull(after);
            return t -> {
                this.acceptWithIO(t);
                after.acceptWithIO(t);
            };
        }

        @Nonnull
        default public java.util.function.Consumer<T> asUnchecked() {
            return t -> {
                try {
                    this.acceptWithIO(t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }

        @Nonnull
        public static <T> java.util.function.Consumer<T> unchecked(@Nonnull Consumer<T> o) {
            return o.asUnchecked();
        }

        @Nonnull
        public static <T> Consumer<T> checked(@Nonnull java.util.function.Consumer<T> consumer) {
            return o -> {
                try {
                    consumer.accept(o);
                }
                catch (UncheckedIOException ex) {
                    throw ex.getCause();
                }
            };
        }

        @Nonnull
        public static <T> Consumer<T> throwing(@Nonnull java.util.function.Supplier<? extends IOException> ex) {
            Objects.requireNonNull(ex);
            return o -> {
                throw (IOException)ex.get();
            };
        }

        @Nonnull
        public static <T> Consumer<T> noOp() {
            return o -> {};
        }
    }

    @FunctionalInterface
    public static interface Predicate<T> {
        public boolean testWithIO(T var1) throws IOException;

        @Nonnull
        default public Predicate<T> and(@Nonnull Predicate<? super T> other) {
            Objects.requireNonNull(other);
            return t -> this.testWithIO(t) && other.testWithIO(t);
        }

        @Nonnull
        default public Predicate<T> negate() {
            return t -> !this.testWithIO(t);
        }

        @Nonnull
        default public Predicate<T> or(@Nonnull Predicate<? super T> other) {
            Objects.requireNonNull(other);
            return t -> this.testWithIO(t) || other.testWithIO(t);
        }

        @Nonnull
        default public java.util.function.Predicate<T> asUnchecked() {
            return t -> {
                try {
                    return this.testWithIO(t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }

        @Nonnull
        public static <T> java.util.function.Predicate<T> unchecked(@Nonnull Predicate<T> o) {
            return o.asUnchecked();
        }

        @Nonnull
        public static <T> Predicate<T> checked(@Nonnull java.util.function.Predicate<T> predicate) {
            Objects.requireNonNull(predicate);
            return o -> {
                try {
                    return predicate.test(o);
                }
                catch (UncheckedIOException ex) {
                    throw ex.getCause();
                }
            };
        }

        @Nonnull
        public static <T> Predicate<T> throwing(@Nonnull java.util.function.Supplier<? extends IOException> ex) {
            Objects.requireNonNull(ex);
            return o -> {
                throw (IOException)ex.get();
            };
        }

        @Nonnull
        public static <T> Predicate<T> isEqual(Object targetRef) {
            return null == targetRef ? Objects::isNull : object -> targetRef.equals(object);
        }

        @Nonnull
        public static <T> Predicate<T> of(boolean r) {
            return o -> r;
        }
    }

    @FunctionalInterface
    public static interface Function<T, R> {
        public R applyWithIO(T var1) throws IOException;

        @Nonnull
        default public <V> Function<V, R> compose(@Nonnull Function<? super V, ? extends T> before) {
            Objects.requireNonNull(before);
            return v -> this.applyWithIO(before.applyWithIO((Object)v));
        }

        @Nonnull
        default public <V> Function<T, V> andThen(@Nonnull Function<? super R, ? extends V> after) {
            Objects.requireNonNull(after);
            return t -> after.applyWithIO((R)this.applyWithIO(t));
        }

        @Nonnull
        default public java.util.function.Function<T, R> asUnchecked() {
            return t -> {
                try {
                    return this.applyWithIO(t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }

        @Nonnull
        public static <T, R> java.util.function.Function<T, R> unchecked(@Nonnull Function<T, R> o) {
            return o.asUnchecked();
        }

        @Nonnull
        public static <T, R> Function<T, R> checked(@Nonnull java.util.function.Function<T, R> func) {
            Objects.requireNonNull(func);
            return o -> {
                try {
                    return func.apply(o);
                }
                catch (UncheckedIOException ex) {
                    throw ex.getCause();
                }
            };
        }

        @Nonnull
        public static <T, R> Function<T, R> throwing(@Nonnull java.util.function.Supplier<? extends IOException> ex) {
            Objects.requireNonNull(ex);
            return o -> {
                throw (IOException)ex.get();
            };
        }

        @Nonnull
        public static <T> Function<T, T> identity() {
            return t -> t;
        }

        @Nonnull
        public static <T, R> Function<T, R> of(@Nullable R r) {
            return o -> r;
        }
    }

    @FunctionalInterface
    public static interface Supplier<T> {
        public T getWithIO() throws IOException;

        @Nonnull
        default public java.util.function.Supplier<T> asUnchecked() {
            return () -> {
                try {
                    return this.getWithIO();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }

        @Nonnull
        public static <T> java.util.function.Supplier<T> unchecked(@Nonnull Supplier<T> o) {
            return o.asUnchecked();
        }

        @Nonnull
        public static <T> Supplier<T> checked(@Nonnull java.util.function.Supplier<T> o) {
            Objects.requireNonNull(o);
            return () -> {
                try {
                    return o.get();
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
            };
        }

        @Nonnull
        public static <T> Supplier<T> throwing(@Nonnull java.util.function.Supplier<? extends IOException> ex) {
            Objects.requireNonNull(ex);
            return () -> {
                throw (IOException)ex.get();
            };
        }

        @Nonnull
        public static <T> Supplier<T> of(@Nullable T t) {
            return () -> t;
        }
    }

    @FunctionalInterface
    public static interface Runnable {
        public void runWithIO() throws IOException;

        @Nonnull
        default public Closeable asCloseable() {
            return this::runWithIO;
        }

        @Nonnull
        default public java.lang.Runnable asUnchecked() {
            return () -> {
                try {
                    this.runWithIO();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }

        @Nonnull
        public static java.lang.Runnable unchecked(@Nonnull Runnable o) {
            return o.asUnchecked();
        }

        @Nonnull
        public static Runnable checked(@Nonnull java.lang.Runnable o) {
            return () -> {
                try {
                    o.run();
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
            };
        }

        @Nonnull
        public static Runnable throwing(@Nonnull java.util.function.Supplier<? extends IOException> ex) {
            Objects.requireNonNull(ex);
            return () -> {
                throw (IOException)ex.get();
            };
        }

        @Nonnull
        public static Runnable noOp() {
            return () -> {};
        }
    }
}

