/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITsModifier;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import java.util.function.Predicate;

public class TsVariableList
implements Cloneable {
    private ArrayList<ITsVariable> vars_ = new ArrayList();

    public static ITsVariable getRoot(ITsVariable var) {
        ITsVariable current = var;
        while (current instanceof ITsModifier) {
            ITsModifier modifier = (ITsModifier)current;
            current = modifier.getVariable();
        }
        return current;
    }

    public void add(ITsVariable var) {
        this.vars_.add(var);
    }

    public TsVariableSelection<ITsVariable> all() {
        TsVariableSelection<ITsVariable> sel = new TsVariableSelection<ITsVariable>();
        int pos = 0;
        for (ITsVariable item : this.vars_) {
            sel.add(item, pos);
            pos += item.getDim();
        }
        return sel;
    }

    public TsVariableList clone() {
        try {
            TsVariableList list = (TsVariableList)super.clone();
            list.vars_ = new ArrayList();
            for (ITsVariable var : this.vars_) {
                list.vars_.add(var);
            }
            return list;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public <T extends ITsVariable> int getCompatibleCount(Class<T> type) {
        int n = 0;
        for (ITsVariable group : this.vars_) {
            if (!type.isAssignableFrom(group.getClass())) continue;
            n += group.getDim();
        }
        return n;
    }

    public <T extends ITsVariable> int getCount(Class<T> type) {
        int n = 0;
        for (ITsVariable group : this.vars_) {
            if (!type.isInstance(group)) continue;
            n += group.getDim();
        }
        return n;
    }

    public TsDomain getDomain() {
        TsDomain domain = null;
        for (ITsVariable item : this.vars_) {
            TsDomain curdomain = item.getDefinitionDomain();
            if (curdomain == null) continue;
            if (domain == null) {
                domain = curdomain;
                continue;
            }
            if (domain.getFrequency() != curdomain.getFrequency()) {
                throw new TsException("Incompatible frequencies");
            }
            domain = domain.intersection(curdomain);
        }
        return domain;
    }

    public TsFrequency getFrequency() {
        TsFrequency freq = TsFrequency.Undefined;
        for (ITsVariable item : this.vars_) {
            TsFrequency curfreq = item.getDefinitionFrequency();
            if (curfreq == TsFrequency.Undefined) continue;
            if (freq == TsFrequency.Undefined) {
                freq = curfreq;
                continue;
            }
            if (freq == curfreq) continue;
            throw new TsException("Incompatible frequencies");
        }
        return freq;
    }

    public int getItemPosition(int idx) {
        int pos = 0;
        for (int i = 0; i < idx; ++i) {
            pos += this.vars_.get(i).getDim();
        }
        return pos;
    }

    public int getItemPosition(ITsVariable var) {
        int pos = 0;
        for (ITsVariable item : this.vars_) {
            if (item == var) {
                return pos;
            }
            pos += item.getDim();
        }
        return -1;
    }

    public int getVariablesCount() {
        int n = 0;
        for (ITsVariable group : this.vars_) {
            n += group.getDim();
        }
        return n;
    }

    public boolean isEmpty() {
        return this.vars_.isEmpty();
    }

    public ITsVariable[] items() {
        return Jdk6.Collections.toArray(this.vars_, ITsVariable.class);
    }

    public <T extends ITsVariable> TsVariableSelection<T> select(Class<T> type) {
        int cur = 0;
        TsVariableSelection<ITsVariable> sel = new TsVariableSelection<ITsVariable>();
        for (ITsVariable group : this.vars_) {
            if (type.isInstance(group)) {
                sel.add(group, cur);
            }
            cur += group.getDim();
        }
        return sel;
    }

    public <T extends ITsVariable> TsVariableSelection<ITsVariable> selectCompatible(Class<T> type) {
        int cur = 0;
        TsVariableSelection<ITsVariable> sel = new TsVariableSelection<ITsVariable>();
        for (ITsVariable group : this.vars_) {
            if (type.isInstance(TsVariableList.getRoot(group))) {
                sel.add(group, cur);
            }
            cur += group.getDim();
        }
        return sel;
    }

    public TsVariableSelection<IOutlierVariable> select(OutlierType type) {
        int cur = 0;
        TsVariableSelection<IOutlierVariable> sel = new TsVariableSelection<IOutlierVariable>();
        for (ITsVariable group : this.vars_) {
            if (group instanceof IOutlierVariable) {
                IOutlierVariable o = (IOutlierVariable)group;
                if (type == OutlierType.Undefined || o.getOutlierType() == type) {
                    sel.add(o, cur);
                }
            }
            cur += group.getDim();
        }
        return sel;
    }

    public void clear() {
        this.vars_.clear();
    }

    public TsVariableSelection<ITsVariable> select(Predicate<ITsVariable> selector) {
        int cur = 0;
        TsVariableSelection<ITsVariable> sel = new TsVariableSelection<ITsVariable>();
        for (ITsVariable group : this.vars_) {
            if (selector.test(group)) {
                sel.add(group, cur);
            }
            cur += group.getDim();
        }
        return sel;
    }

    @Deprecated
    public static interface ISelector {
        public boolean accept(ITsVariable var1);
    }
}

