/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlockStorage;
import ec.tstoolkit.ssf.ArrayState;
import ec.tstoolkit.ssf.FastArrayState;
import ec.tstoolkit.ssf.FastState;
import ec.tstoolkit.ssf.IArrayFilteringResults;
import ec.tstoolkit.ssf.IFastArrayFilteringResults;
import ec.tstoolkit.ssf.IFastFilteringResults;
import ec.tstoolkit.ssf.IFilteringResults;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.ResidualsCumulator;
import ec.tstoolkit.ssf.State;

public class PredictionErrorDecomposition
extends ResidualsCumulator
implements IFilteringResults,
IFastFilteringResults,
IFastArrayFilteringResults,
IArrayFilteringResults {
    private double[] m_res;
    private boolean m_bres;
    private boolean m_open;

    public PredictionErrorDecomposition(boolean bres) {
        this.m_bres = bres;
    }

    private void checkSize(int pos) {
        if (this.m_res != null && pos < this.m_res.length) {
            return;
        }
        double[] tmp = new double[DataBlockStorage.calcSize(pos + 1)];
        int l = 0;
        if (this.m_res != null) {
            l = this.m_res.length;
            System.arraycopy(this.m_res, 0, tmp, 0, l);
        }
        for (int i = l; i < tmp.length; ++i) {
            tmp[i] = Double.NaN;
        }
        this.m_res = tmp;
    }

    public boolean isOpen() {
        return this.m_open;
    }

    @Override
    public void close() {
        this.m_open = false;
    }

    public boolean hasResiduals() {
        return this.m_bres;
    }

    @Override
    public void prepare(ISsf ssf, ISsfData data) {
        if (!this.m_open) {
            this.init(ssf, data.getCount());
        } else if (this.m_bres) {
            this.checkSize(data.getCount());
        }
    }

    protected void init(ISsf ssf, int len) {
        this.clear();
        this.m_open = true;
        if (this.m_bres) {
            this.m_res = new double[len];
            for (int i = 0; i < this.m_res.length; ++i) {
                this.m_res[i] = Double.NaN;
            }
        } else {
            this.m_res = null;
        }
    }

    public double[] residuals(boolean bClean) {
        if (this.m_res == null) {
            return null;
        }
        if (!bClean) {
            return this.m_res;
        }
        int n = 0;
        for (int i = 0; i < this.m_res.length; ++i) {
            if (Double.isNaN(this.m_res[i])) continue;
            ++n;
        }
        if (n == this.m_res.length) {
            return this.m_res;
        }
        double[] res = new double[n];
        int j = 0;
        for (int i = 0; i < this.m_res.length; ++i) {
            if (Double.isNaN(this.m_res[i])) continue;
            res[j++] = this.m_res[i];
        }
        return res;
    }

    @Override
    public void save(int t, ArrayState state) {
        if (!state.isMissing()) {
            this.add(state.e, state.r * state.r);
            if (this.m_bres) {
                this.checkSize(t);
                this.m_res[t] = state.e / state.r;
            }
        }
    }

    @Override
    public void save(int t, FastArrayState state) {
        this.add(state.e, state.r * state.r);
        if (this.m_bres) {
            this.checkSize(t);
            this.m_res[t] = state.e / state.r;
        }
    }

    @Override
    public void save(int t, FastState state) {
        this.add(state.e, state.f);
        if (this.m_bres) {
            this.checkSize(t);
            this.m_res[t] = state.e / Math.sqrt(state.f);
        }
    }

    @Override
    public void save(int t, State state) {
        if (!state.isMissing()) {
            this.add(state.e, state.f);
            if (this.m_bres) {
                this.checkSize(t);
                this.m_res[t] = state.e / Math.sqrt(state.f);
            }
        }
    }

    public void setResiduals(boolean value) {
        this.m_bres = value;
    }
}

