/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ucarima;

import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.ucarima.SimpleModelDecomposer;

public class MaDecomposer
extends SimpleModelDecomposer {
    @Override
    protected void calc() {
        BackFilter AR2 = this.m_model.getAR();
        Polynomial ar = AR2.getPolynomial();
        Polynomial q = this.m_model.getMA().getPolynomial();
        if (q.getDegree() <= ar.getDegree()) {
            this.m_s = null;
            this.m_n = this.m_model;
        } else {
            BackFilter U = this.m_model.getNonStationaryAR();
            BackFilter P = this.m_model.getStationaryAR();
            Polynomial p = P.getPolynomial();
            Polynomial.Division div = Polynomial.divide(q, ar);
            Polynomial r = div.getQuotient();
            double cq = q.get(q.getDegree());
            double cp = ar.get(ar.getDegree());
            double cr = r.get(r.getDegree());
            double c0 = r.get(0);
            r = r.times(cq / (cr * cp));
            BackFilter fr = new BackFilter(r);
            SymmetricFilter sq = SymmetricFilter.createFromFilter(new BackFilter(q));
            SymmetricFilter sr = SymmetricFilter.createFromFilter(new BackFilter(r));
            SymmetricFilter spr = SymmetricFilter.createFromFilter(AR2.times(fr));
            SymmetricFilter ss = spr.minus(sq);
            this.m_s = new ArimaModel(null, null, sr);
            this.m_n = new ArimaModel(P, U, ss);
        }
    }
}

