/*
 * Decompiled with CFR 0.152.
 */
package jdr.spec.x13;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.x11.CalendarSigma;
import ec.satoolkit.x11.SeasonalFilterOption;
import ec.satoolkit.x11.X11Exception;
import ec.satoolkit.x11.X11Specification;

public class X11Spec {
    private final X11Specification core;
    private int freq;
    private final boolean preprocessing;

    public int getFreq() {
        return this.freq;
    }

    public void setFreq(int freq) {
        this.freq = freq;
    }

    public X11Spec(X11Specification spec, int freq, boolean preprocessing) {
        this.core = spec;
        this.freq = freq;
        this.preprocessing = preprocessing;
    }

    public String getMode() {
        return this.core.getMode().name();
    }

    public void setMode(String value) {
        this.core.setMode(DecompositionMode.valueOf((String)value));
    }

    public int getForecastHorizon() {
        return this.core.getForecastHorizon();
    }

    public int getBackcastHorizon() {
        return this.core.getBackcastHorizon();
    }

    public boolean isSeasonal() {
        return this.core.isSeasonal();
    }

    public void setSeasonal(boolean value) {
        this.core.setSeasonal(value);
    }

    public void setForecastHorizon(int value) {
        this.core.setForecastHorizon(value);
    }

    public void setBackcastHorizon(int value) {
        this.core.setBackcastHorizon(value);
    }

    public double getLSigma() {
        return this.core.getLowerSigma();
    }

    public void setLSigma(double value) {
        this.core.setLowerSigma(value);
    }

    public double getUSigma() {
        return this.core.getUpperSigma();
    }

    public void setUSigma(double value) {
        this.core.setUpperSigma(value);
    }

    public String getSeasonalMA() {
        if (this.core.getSeasonalFilters() == null) {
            return SeasonalFilterOption.Msr.name();
        }
        return this.core.getSeasonalFilters()[0].name();
    }

    public void setSeasonalMA(String ma) {
        this.core.setSeasonalFilter(SeasonalFilterOption.valueOf((String)ma));
    }

    public String[] getFullSeasonalMA() {
        SeasonalFilterOption[] filters = this.core.getSeasonalFilters();
        if (filters == null || this.freq == 0) {
            return null;
        }
        if (filters.length == this.freq) {
            String[] nfilters = new String[this.freq];
            for (int i = 0; i < this.freq; ++i) {
                nfilters[i] = filters[i].name();
            }
            return nfilters;
        }
        String option = filters[0].name();
        String[] nfilters = new String[this.freq];
        for (int i = 0; i < this.freq; ++i) {
            nfilters[i] = option;
        }
        return nfilters;
    }

    public void setFullSeasonalMA(String[] value) {
        SeasonalFilterOption[] filters = new SeasonalFilterOption[value.length];
        for (int i = 0; i < filters.length; ++i) {
            filters[i] = SeasonalFilterOption.valueOf((String)value[i]);
        }
        this.core.setSeasonalFilters(filters);
    }

    public boolean isAutoTrendMA() {
        return this.core.isAutoHenderson();
    }

    public void setAutoTrendMA(boolean value) {
        if (value) {
            this.core.setHendersonFilterLength(0);
        } else {
            this.core.setHendersonFilterLength(13);
        }
    }

    public int getTrendMA() {
        return this.core.getHendersonFilterLength() == 0 ? 13 : this.core.getHendersonFilterLength();
    }

    public void setTrendMA(int value) {
        if (value <= 1 || value > 101 || value % 2 == 0) {
            throw new X11Exception("Invalid value for henderson filter");
        }
        this.core.setHendersonFilterLength(value);
    }

    public CalendarSigma getCalendarSigma() {
        return this.core.getCalendarSigma();
    }

    public void setExcludefcst(boolean value) {
        this.core.setExcludefcst(value);
    }

    public boolean isExcludefcst() {
        return this.core.isExcludefcst();
    }
}

