/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.mapping;

import demetra.information.InformationMapping;
import ec.tstoolkit.information.StatisticalTest;
import ec.tstoolkit.stats.NiidTests;
import ec.tstoolkit.stats.RunsTestKind;
import ec.tstoolkit.stats.TestofUpDownRuns;

public final class ResidualsInfo {
    public static final String RESIDUALS = "residuals";
    public static final String RES_DATA = "res";
    public static final String RES_STDERR = "stderr";
    public static final String RES_MEAN = "mean";
    public static final String RES_SKEWNESS = "skewness";
    public static final String RES_KURTOSIS = "kurtosis";
    public static final String RES_DH = "dh";
    public static final String RES_LB = "lb";
    public static final String RES_LB2 = "lb2";
    public static final String RES_SEASLB = "seaslb";
    public static final String RES_BP = "bp";
    public static final String RES_BP2 = "bp2";
    public static final String RES_SEASBP = "seasbp";
    public static final String RES_UD_NUMBER = "nruns";
    public static final String RES_UD_LENGTH = "lruns";
    private static final InformationMapping<NiidTests> MAPPING = new InformationMapping<NiidTests>(NiidTests.class);

    public static InformationMapping<NiidTests> getMapping() {
        return MAPPING;
    }

    private ResidualsInfo() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        MAPPING.set(RES_DATA, double[].class, source -> source.getStatistics().observations());
        MAPPING.set(RES_MEAN, StatisticalTest.class, source -> StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)source.getMeanTest()));
        MAPPING.set(RES_SKEWNESS, StatisticalTest.class, source -> StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)source.getSkewness()));
        MAPPING.set(RES_KURTOSIS, StatisticalTest.class, source -> StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)source.getKurtosis()));
        MAPPING.set(RES_DH, StatisticalTest.class, source -> StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)source.getNormalityTest()));
        MAPPING.set(RES_LB, StatisticalTest.class, source -> StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)source.getLjungBox()));
        MAPPING.set(RES_LB2, StatisticalTest.class, source -> StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)source.getLjungBoxOnSquare()));
        MAPPING.set(RES_SEASLB, StatisticalTest.class, source -> StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)source.getSeasonalLjungBox()));
        MAPPING.set(RES_BP, StatisticalTest.class, source -> StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)source.getBoxPierce()));
        MAPPING.set(RES_BP2, StatisticalTest.class, source -> StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)source.getBoxPierceOnSquare()));
        MAPPING.set(RES_SEASBP, StatisticalTest.class, source -> StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)source.getSeasonalBoxPierce()));
        MAPPING.set(RES_UD_NUMBER, StatisticalTest.class, source -> {
            TestofUpDownRuns ud = source.getUpAndDownRuns();
            if (ud == null) {
                return null;
            }
            ud.setKind(RunsTestKind.Number);
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ud);
        });
        MAPPING.set(RES_UD_LENGTH, StatisticalTest.class, source -> {
            TestofUpDownRuns ud = source.getUpAndDownRuns();
            if (ud == null) {
                return null;
            }
            ud.setKind(RunsTestKind.Length);
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ud);
        });
    }
}

