/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockStorage;
import ec.tstoolkit.maths.matrices.MatrixStorage;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.FastState;
import ec.tstoolkit.ssf.FilteredData;
import ec.tstoolkit.ssf.IFastFilteringResults;
import ec.tstoolkit.ssf.IFilteringResults;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.State;
import ec.tstoolkit.utilities.Arrays2;

public class VarianceFilter
implements IFilteringResults,
IFastFilteringResults {
    ISsf m_ssf;
    MatrixStorage m_P;
    DataBlockStorage m_C;
    DataBlockStorage m_L;
    double[] m_f;
    boolean[] m_nd;
    int m_n;
    int m_dim;
    boolean m_bC = false;
    boolean m_bP = false;
    boolean m_bL = false;
    boolean m_open;

    public VarianceFilter() {
        this.m_bC = false;
        this.m_bL = false;
    }

    public VarianceFilter(boolean hasC) {
        this.m_bC = hasC;
        this.m_bL = false;
    }

    public DataBlock C(int t) {
        return this.m_C == null ? null : this.m_C.block(t);
    }

    protected void checkSize(int n) {
        if (this.m_n >= n) {
            return;
        }
        this.m_n = n;
        if (this.m_f.length >= n) {
            return;
        }
        int sz = DataBlockStorage.calcSize(n);
        double[] tmp = new double[sz];
        Arrays2.copy(this.m_f, tmp, this.m_f.length);
        this.m_f = tmp;
        boolean[] btmp = new boolean[sz];
        System.arraycopy(this.m_nd, 0, btmp, 0, this.m_nd.length);
        this.m_nd = btmp;
        if (this.m_bC) {
            this.m_C.resize(sz);
        }
        if (this.m_bL) {
            this.m_L.resize(sz);
        } else if (this.m_bP) {
            this.m_P.resize(sz);
        }
    }

    public void clear() {
        this.m_n = 0;
        this.m_dim = 0;
        this.m_P = null;
        this.m_C = null;
        this.m_L = null;
        this.m_f = null;
        this.m_nd = null;
    }

    @Override
    public void close() {
        this.m_open = false;
    }

    public double F(int t) {
        return this.m_f[t];
    }

    public int getSize() {
        return this.m_n;
    }

    public int getStateDim() {
        return this.m_dim;
    }

    protected void init(ISsf ssf, int n) {
        this.clear();
        this.m_open = true;
        this.m_ssf = ssf;
        this.m_dim = ssf.getStateDim();
        this.m_n = n;
        this.m_f = new double[DataBlockStorage.calcSize(n)];
        this.m_nd = new boolean[DataBlockStorage.calcSize(n)];
        if (this.m_bC) {
            this.m_C = new DataBlockStorage(this.m_dim, this.m_n);
        }
        if (this.m_bL) {
            this.m_L = new DataBlockStorage(this.m_dim, this.m_n);
        } else if (this.m_bP) {
            this.m_P = new MatrixStorage(this.m_dim, this.m_n);
        }
    }

    public boolean isMissing(int t) {
        return this.m_nd[t];
    }

    public boolean isOpen() {
        return this.m_open;
    }

    public boolean isSavingC() {
        return this.m_bC;
    }

    public boolean isSavingL() {
        return this.m_bL;
    }

    public boolean isSavingP() {
        return this.m_bP;
    }

    public DataBlock L(int t) {
        return this.m_L == null ? null : this.m_L.block(t);
    }

    public SubMatrix P(int t) {
        if (this.m_P == null) {
            return null;
        }
        return this.m_P.matrix(t);
    }

    @Override
    public void prepare(ISsf ssf, ISsfData data) {
        if (!this.m_open) {
            this.init(ssf, data.getCount());
        } else {
            this.checkSize(data.getCount());
        }
    }

    public void process(FilteredData fdata, int startpos, double[] data, double[] initialstate) {
        DataBlock a = new DataBlock(this.m_dim);
        if (initialstate != null) {
            a.copyFrom(initialstate, 0);
        }
        int imax = this.m_n - 1;
        double e = 0.0;
        for (int i = startpos; i < imax; ++i) {
            fdata.m_e[i] = e = data[i] - this.m_ssf.ZX(i, a);
            if (fdata.m_bA) {
                fdata.A(i).copy(a);
            }
            this.m_ssf.TX(i, a);
            if (this.m_nd[i]) continue;
            double c = e / this.m_f[i];
            a.addAY(c, this.C(i));
        }
        fdata.m_e[imax] = e = data[imax] - this.m_ssf.ZX(imax, a);
        if (fdata.m_bA) {
            fdata.A(imax).copy(a);
        }
    }

    @Override
    public void save(int t, FastState state) {
        this.m_f[t] = state.f;
        if (this.m_bC) {
            this.m_C.save(t, state.C);
        }
        if (this.m_bL) {
            this.m_L.save(t, state.L);
        }
    }

    @Override
    public void save(int t, State state) {
        this.m_f[t] = state.f;
        this.m_nd[t] = state.isMissing();
        if (this.m_bC) {
            this.m_C.save(t, state.C);
        }
        if (this.m_bP) {
            this.m_P.save(t, state.P);
        }
    }

    public void setSavingC(boolean value) {
        this.m_bC = value;
    }

    public void setSavingL(boolean value) {
        this.m_bL = value;
        if (this.m_bL) {
            this.m_bP = false;
        }
    }

    public void setSavingP(boolean value) {
        this.m_bP = value;
        if (this.m_bP) {
            this.m_bL = false;
        }
    }
}

