/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit;

import ec.tstoolkit.utilities.IModifiable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MetaData
implements Map<String, String>,
Cloneable,
IModifiable {
    public static final String DESCRIPTION = "@description";
    public static final String OWNER = "@owner";
    public static final String SOURCE = "@source";
    public static final String ID = "@id";
    public static final String DATE = "@timestamp";
    public static final String DOCUMENT = "@document";
    public static final String SUMMARY = "@summary";
    public static final String NOTE = "@note";
    public static final String TODO = "@todo";
    public static final String ALGORITHM = "@algorithm";
    public static final String QUALITY = "@quality";
    private final Map<String, String> props_ = new HashMap<String, String>();
    private boolean dirty_;

    public MetaData() {
        this(new HashMap<String, String>());
    }

    public MetaData(Map<String, String> dic) {
        this.props_.putAll(dic);
    }

    private String normalizeKey(String key) {
        return key.toLowerCase();
    }

    public MetaData clone() {
        MetaData result = new MetaData();
        result.props_.putAll(this.props_);
        return result;
    }

    public void copy(MetaData md) {
        this.clear();
        this.props_.putAll(md.props_);
    }

    @Deprecated
    public void set(String name, String value) {
        this.put(name, value);
        this.dirty_ = true;
    }

    @Override
    public int size() {
        return this.props_.size();
    }

    @Override
    public boolean isEmpty() {
        return this.props_.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String ? this.props_.containsKey(this.normalizeKey((String)key)) : false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.props_.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return key instanceof String ? this.props_.get(this.normalizeKey((String)key)) : null;
    }

    @Override
    public String put(String key, String value) {
        this.dirty_ = true;
        return this.props_.put(this.normalizeKey(key), value);
    }

    @Override
    public String remove(Object key) {
        this.dirty_ = true;
        return key instanceof String ? this.props_.remove(this.normalizeKey((String)key)) : null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.dirty_ = true;
        for (Map.Entry<? extends String, ? extends String> o : m.entrySet()) {
            this.put(o.getKey(), o.getValue());
        }
    }

    @Override
    public void clear() {
        this.dirty_ = true;
        this.props_.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.props_.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.props_.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return Collections.unmodifiableSet(this.props_.entrySet());
    }

    @Override
    public boolean isDirty() {
        return this.dirty_;
    }

    @Override
    public void resetDirty() {
        this.dirty_ = false;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof MetaData && this.equals((MetaData)obj);
    }

    private boolean equals(MetaData other) {
        return this.dirty_ == other.dirty_ && this.props_.equals(other.props_);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.props_, this.dirty_);
    }

    public static boolean isNullOrEmpty(MetaData md) {
        return md == null || md.isEmpty();
    }
}

