/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.simplets.PeriodIterator;
import ec.tstoolkit.timeseries.simplets.TsData;

public final class MsrTable {
    private static double[] C = new double[]{1.0, 1.02584, 1.01779, 1.01383, 1.0, 3.0, 1.55291, 1.30095};
    private double[] m_rs;
    private double[] m_ri;
    private int[] m_n;

    public static MsrTable create(TsData ss, TsData is, boolean mul) {
        MsrTable rms = new MsrTable();
        int freq = ss.getFrequency().intValue();
        rms.m_rs = new double[freq];
        rms.m_ri = new double[freq];
        rms.m_n = new int[freq];
        PeriodIterator bs = new PeriodIterator(ss);
        PeriodIterator bi = new PeriodIterator(is);
        int tell = 0;
        while (bi.hasMoreElements()) {
            double ci = 0.0;
            double cs = 0.0;
            DataBlock bdi = bi.nextElement().data;
            DataBlock bds = bs.nextElement().data;
            int nc = bdi.getLength();
            for (int i = 1; i < nc; ++i) {
                double x0 = bdi.get(i - 1);
                double x1 = bdi.get(i);
                double d = x1 - x0;
                if (mul) {
                    d /= x0;
                }
                ci += Math.abs(d);
                x0 = bds.get(i - 1);
                x1 = bds.get(i);
                d = x1 - x0;
                if (mul) {
                    d /= x0;
                }
                cs += Math.abs(d);
            }
            rms.m_ri[tell] = ci / (double)(nc - 1) * MsrTable.fis(nc - 1);
            rms.m_rs[tell] = cs / (double)(nc - 1) * MsrTable.cs(nc - 1);
            rms.m_n[tell++] = nc - 1;
        }
        return rms;
    }

    private static double cs(int n) {
        if (n < 2) {
            return 1.0;
        }
        if (n < 6) {
            return C[n + 2];
        }
        return (double)n * 1.732051 / (8.485281 + (double)(n - 6) * 1.732051);
    }

    private static double fis(int n) {
        if (n < 2) {
            return 1.0;
        }
        if (n < 6) {
            return C[n - 2];
        }
        return (double)n * 12.247449 / (73.239334 + (double)(n - 6) * 12.247449);
    }

    private MsrTable() {
    }

    private MsrTable(double[] rs, double[] ri, int[] n) {
        this.m_rs = rs;
        this.m_ri = ri;
        if (n != null) {
            this.m_n = n;
        }
    }

    public int getCount() {
        return this.m_ri.length;
    }

    public double getGlobalMsr() {
        double ri = 0.0;
        double rs = 0.0;
        for (int i = 0; i < this.m_ri.length; ++i) {
            ri += this.m_ri[i] * (double)this.m_n[i];
            rs += this.m_rs[i] * (double)this.m_n[i];
        }
        return ri / rs;
    }

    public double[] getMeanIrregularEvolutions() {
        return this.m_ri;
    }

    public double[] getMeanSeasonalEvolutions() {
        return this.m_rs;
    }

    public double getRMS(int idx) {
        return this.m_ri[idx] / this.m_rs[idx];
    }
}

