/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.tdvar;

import be.nbb.demetra.mtd.MovingTradingDaysSaProcessor;
import be.nbb.demetra.mtd.MovingTradingDaysSaResults;
import be.nbb.demetra.mtd.MovingTradingDaysSpecification;
import be.nbb.demetra.tvtd.TimeVaryingTradingDaysSaProcessor;
import be.nbb.demetra.tvtd.TimeVaryingTradingDaysSaResults;
import be.nbb.demetra.tvtd.TimeVaryingTradingDaysSpecification;
import demetra.algorithm.IProcResults;
import demetra.information.InformationMapping;
import ec.satoolkit.x11.SeasonalFilterFactory;
import ec.satoolkit.x11.X11Specification;
import ec.tstoolkit.jdr.mapping.SarimaInfo;
import ec.tstoolkit.jdr.regarima.RegArimaInfo;
import ec.tstoolkit.jdr.sa.SaDecompositionInfo;
import ec.tstoolkit.jdr.x11.MstatisticsInfo;
import ec.tstoolkit.jdr.x11.X11DecompositionInfo;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.modelling.arima.tramo.TramoSpecification;
import ec.tstoolkit.modelling.arima.x13.RegArimaSpecification;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MovingTradingDays {
    public static Results movingWindow(TsData s, int windowLength, int smoothingLength, String preprocessing, String option, boolean reestimate) {
        MovingTradingDaysSpecification mtdSpec = MovingTradingDays.mtdSpec(windowLength, smoothingLength, reestimate);
        X11Specification xspec = new X11Specification();
        boolean air = option.endsWith("a");
        if (air) {
            option = option.substring(0, option.length() - 1);
        }
        if (preprocessing.equalsIgnoreCase("TRAMO")) {
            TramoSpecification spec = TramoSpecification.fromString((String)option).clone();
            if (spec == null) {
                return null;
            }
            if (air) {
                spec.setUsingAutoModel(false);
                spec.getArima().airline();
            }
            return new Results(MovingTradingDaysSaProcessor.process((TsData)s, (TramoSpecification)spec, (MovingTradingDaysSpecification)mtdSpec, (X11Specification)xspec, null));
        }
        if (preprocessing.equalsIgnoreCase("REGARIMA")) {
            RegArimaSpecification spec = RegArimaSpecification.fromString((String)option);
            if (spec == null) {
                return null;
            }
            if (air) {
                spec.setUsingAutoModel(false);
                spec.getArima().airline();
            }
            return new Results(MovingTradingDaysSaProcessor.process((TsData)s, (RegArimaSpecification)spec, (MovingTradingDaysSpecification)mtdSpec, (X11Specification)xspec, null));
        }
        return null;
    }

    public static Results2 timeVarying(TsData s, boolean contrasts, String preprocessing, String option) {
        TimeVaryingTradingDaysSpecification mtdSpec = new TimeVaryingTradingDaysSpecification();
        mtdSpec.setOnContrast(contrasts);
        X11Specification xspec = new X11Specification();
        boolean air = option.endsWith("a");
        if (air) {
            option = option.substring(0, option.length() - 1);
        }
        if (preprocessing.equalsIgnoreCase("TRAMO")) {
            TramoSpecification spec = TramoSpecification.fromString((String)option).clone();
            if (spec == null) {
                return null;
            }
            if (air) {
                spec.setUsingAutoModel(false);
                spec.getArima().airline();
            }
            return new Results2(TimeVaryingTradingDaysSaProcessor.process((TsData)s, (TramoSpecification)spec, (TimeVaryingTradingDaysSpecification)mtdSpec, (X11Specification)xspec, null));
        }
        if (preprocessing.equalsIgnoreCase("REGARIMA")) {
            RegArimaSpecification spec = RegArimaSpecification.fromString((String)option);
            if (spec == null) {
                return null;
            }
            if (air) {
                spec.setUsingAutoModel(false);
                spec.getArima().airline();
            }
            return new Results2(TimeVaryingTradingDaysSaProcessor.process((TsData)s, (RegArimaSpecification)spec, (TimeVaryingTradingDaysSpecification)mtdSpec, (X11Specification)xspec, null));
        }
        return null;
    }

    public static MovingTradingDaysSpecification mtdSpec(int windowLength, int smoothingLength, boolean reestimate) {
        SymmetricFilter sfilter = SeasonalFilterFactory.S3X3;
        switch (smoothingLength) {
            case 3: {
                sfilter = SeasonalFilterFactory.S3X1;
                break;
            }
            case 5: {
                sfilter = SeasonalFilterFactory.S3X3;
                break;
            }
            case 7: {
                sfilter = SeasonalFilterFactory.S3X5;
                break;
            }
            case 11: {
                sfilter = SeasonalFilterFactory.S3X9;
            }
        }
        MovingTradingDaysSpecification mspec = new MovingTradingDaysSpecification();
        mspec.setWindowLength(windowLength);
        mspec.setReestimate(reestimate);
        mspec.setSmoother(sfilter);
        return mspec;
    }

    private MovingTradingDays() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Results2
    implements IProcResults {
        private static final String REGARIMA = "regarima";
        private static final String TD = "tvtd.tdenolp";
        private static final String TDE = "tvtd.tde";
        private static final String LIN = "tvtd.partiallinearizedseries";
        private static final String COEF = "tvtd.coefficients";
        private static final String ECOEF = "tvtd.stdecoefficients";
        private final TimeVaryingTradingDaysSaResults core;
        private static final InformationMapping<Results2> MAPPING = new InformationMapping<Results2>(Results2.class);

        @Override
        public boolean contains(String id) {
            return MAPPING.contains(id);
        }

        @Override
        public Map<String, Class> getDictionary() {
            LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
            MAPPING.fillDictionary(null, dic, true);
            return dic;
        }

        @Override
        public <T> T getData(String id, Class<T> tclass) {
            return MAPPING.getData(this, id, tclass);
        }

        public static final InformationMapping<Results2> getMapping() {
            return MAPPING;
        }

        public Results2(TimeVaryingTradingDaysSaResults core) {
            this.core = core;
        }

        public TimeVaryingTradingDaysSaResults getCore() {
            return this.core;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Results2)) {
                return false;
            }
            Results2 other = (Results2)o;
            TimeVaryingTradingDaysSaResults this$core = this.getCore();
            TimeVaryingTradingDaysSaResults other$core = other.getCore();
            return !(this$core == null ? other$core != null : !this$core.equals(other$core));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TimeVaryingTradingDaysSaResults $core = this.getCore();
            result = result * 59 + ($core == null ? 43 : $core.hashCode());
            return result;
        }

        public String toString() {
            return "MovingTradingDays.Results2(core=" + this.getCore() + ")";
        }

        static {
            MAPPING.delegate(REGARIMA, RegArimaInfo.getMapping(), r -> r.core.getPreprocessing());
            MAPPING.set(TD, TsData.class, r -> {
                TsData s = r.core.getTimeVaryingTradingDaysCorrection().getTdEffect().clone();
                r.core.getPreprocessing().backTransform(s, false, false);
                return s;
            });
            MAPPING.set(TDE, TsData.class, r -> {
                TsData s = r.core.getTimeVaryingTradingDaysCorrection().getFullTdEffect().clone();
                r.core.getPreprocessing().backTransform(s, false, false);
                return s;
            });
            MAPPING.set(LIN, TsData.class, r -> r.core.getTimeVaryingTradingDaysCorrection().getPartialLinearizedSeries());
            MAPPING.set(COEF, Matrix.class, r -> r.core.getTimeVaryingTradingDaysCorrection().getTdCoefficients());
            MAPPING.set(ECOEF, Matrix.class, r -> r.core.getTimeVaryingTradingDaysCorrection().getStdeTdCoefficients());
            MAPPING.set("tvtd.aic", Double.class, r -> r.core.getTimeVaryingTradingDaysCorrection().getAic());
            MAPPING.set("tvtd.aic0", Double.class, r -> r.core.getTimeVaryingTradingDaysCorrection().getAic0());
            MAPPING.delegate("tvtd.arima", SarimaInfo.getMapping(), r -> r.core.getTimeVaryingTradingDaysCorrection().getArima());
            MAPPING.delegate("tvtd.arima0", SarimaInfo.getMapping(), r -> r.core.getTimeVaryingTradingDaysCorrection().getArima0());
            MAPPING.delegate("decomposition", X11DecompositionInfo.getMapping(), r -> r.core.getDecomposition());
            MAPPING.delegate("mstatistics", MstatisticsInfo.getMapping(), r -> r.core.getMstatistics());
            MAPPING.delegate(null, SaDecompositionInfo.getMapping(), r -> r.core.getFinalDecomposition());
        }
    }

    public static final class Results
    implements IProcResults {
        private static final String REGARIMA = "regarima";
        private static final String TD = "mtd.tdenolp";
        private static final String TDE = "mtd.tde";
        private static final String LIN = "mtd.partiallinearizedseries";
        private static final String RAWCOEF = "mtd.rawcoefficients";
        private static final String SMOOTHCOEF = "mtd.smoothedcoefficients";
        private final MovingTradingDaysSaResults core;
        private static final InformationMapping<Results> MAPPING = new InformationMapping<Results>(Results.class);

        @Override
        public boolean contains(String id) {
            return MAPPING.contains(id);
        }

        @Override
        public Map<String, Class> getDictionary() {
            LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
            MAPPING.fillDictionary(null, dic, true);
            return dic;
        }

        @Override
        public <T> T getData(String id, Class<T> tclass) {
            return MAPPING.getData(this, id, tclass);
        }

        public static final InformationMapping<Results> getMapping() {
            return MAPPING;
        }

        public Results(MovingTradingDaysSaResults core) {
            this.core = core;
        }

        public MovingTradingDaysSaResults getCore() {
            return this.core;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Results)) {
                return false;
            }
            Results other = (Results)o;
            MovingTradingDaysSaResults this$core = this.getCore();
            MovingTradingDaysSaResults other$core = other.getCore();
            return !(this$core == null ? other$core != null : !this$core.equals(other$core));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MovingTradingDaysSaResults $core = this.getCore();
            result = result * 59 + ($core == null ? 43 : $core.hashCode());
            return result;
        }

        public String toString() {
            return "MovingTradingDays.Results(core=" + this.getCore() + ")";
        }

        static {
            MAPPING.delegate(REGARIMA, RegArimaInfo.getMapping(), r -> r.core.getPreprocessing());
            MAPPING.set(TD, TsData.class, r -> {
                TsData s = r.core.getMovingTradingDaysCorrection().getTdEffect().clone();
                r.core.getPreprocessing().backTransform(s, false, false);
                return s;
            });
            MAPPING.set(TDE, TsData.class, r -> {
                TsData s = r.core.getMovingTradingDaysCorrection().getFullTdEffect().clone();
                r.core.getPreprocessing().backTransform(s, false, false);
                return s;
            });
            MAPPING.set(LIN, TsData.class, r -> r.core.getMovingTradingDaysCorrection().getPartialLinearizedSeries());
            MAPPING.set(RAWCOEF, Matrix.class, r -> r.core.getMovingTradingDaysCorrection().getRawCoefficients());
            MAPPING.set(SMOOTHCOEF, Matrix.class, r -> r.core.getMovingTradingDaysCorrection().getSmoothedCoefficients());
            MAPPING.delegate("decomposition", X11DecompositionInfo.getMapping(), r -> r.core.getDecomposition());
            MAPPING.delegate("mstatistics", MstatisticsInfo.getMapping(), r -> r.core.getMstatistics());
            MAPPING.delegate(null, SaDecompositionInfo.getMapping(), r -> r.core.getFinalDecomposition());
        }
    }
}

