/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.analysis;

import ec.tstoolkit.timeseries.analysis.DiagnosticTsFunction;
import ec.tstoolkit.timeseries.simplets.TsDataFunction;

public enum DiagnosticInfo {
    AbsoluteDifference,
    RelativeDifference,
    PeriodToPeriodGrowthDifference,
    PeriodToPeriodDifference,
    AnnualGrowthDifference,
    AnnualDifference;


    public DiagnosticTsFunction asFunction() {
        switch (this) {
            case AbsoluteDifference: {
                return (ref, s, pos) -> ref.get(pos) - s.get(pos);
            }
            case RelativeDifference: {
                return (ref, s, pos) -> {
                    double T2 = ref.get(pos);
                    return 100.0 * (T2 - s.get(pos)) / T2;
                };
            }
            case PeriodToPeriodGrowthDifference: {
                return (ref, s, pos) -> 100.0 * (ref.get(pos) / ref.get(pos - 1) - s.get(pos) / s.get(pos - 1));
            }
            case PeriodToPeriodDifference: {
                return (ref, s, pos) -> ref.get(pos) - ref.get(pos - 1) - (s.get(pos) - s.get(pos - 1));
            }
            case AnnualGrowthDifference: {
                return (ref, s, pos) -> {
                    int lag = ref.getFrequency().intValue();
                    return 100.0 * (ref.get(pos) / ref.get(pos - lag) - s.get(pos) / s.get(pos - lag));
                };
            }
            case AnnualDifference: {
                return (ref, s, pos) -> {
                    int lag = ref.getFrequency().intValue();
                    return ref.get(pos) - ref.get(pos - lag) - (s.get(pos) - s.get(pos - lag));
                };
            }
        }
        return (ref, s, pos) -> Double.NaN;
    }

    public TsDataFunction asTsDataFunction() {
        switch (this) {
            case AbsoluteDifference: 
            case RelativeDifference: {
                return (s, pos) -> s.get(pos);
            }
            case PeriodToPeriodGrowthDifference: {
                return (s, pos) -> 100.0 * (s.get(pos) / s.get(pos - 1) - 1.0);
            }
            case PeriodToPeriodDifference: {
                return (s, pos) -> s.get(pos) - s.get(pos - 1);
            }
            case AnnualGrowthDifference: {
                return (s, pos) -> 100.0 * (s.get(pos) / s.get(pos - s.getFrequency().intValue()) - 1.0);
            }
            case AnnualDifference: {
                return (s, pos) -> s.get(pos) - s.get(pos - s.getFrequency().intValue());
            }
        }
        return (s, pos) -> Double.NaN;
    }

    public DiagnosticInfo adaptForNegativeValues() {
        switch (this) {
            case RelativeDifference: {
                return AbsoluteDifference;
            }
            case PeriodToPeriodGrowthDifference: {
                return PeriodToPeriodDifference;
            }
            case AnnualGrowthDifference: {
                return AnnualDifference;
            }
        }
        return this;
    }

    public boolean isRelative() {
        return this == RelativeDifference || this == PeriodToPeriodGrowthDifference || this == AnnualGrowthDifference;
    }

    public String toString() {
        switch (this) {
            case AbsoluteDifference: {
                return "Absolute differences";
            }
            case RelativeDifference: {
                return "Relative differences (%)";
            }
            case PeriodToPeriodGrowthDifference: {
                return "Period to period growth differences (%)";
            }
            case PeriodToPeriodDifference: {
                return "Period to period differences";
            }
            case AnnualGrowthDifference: {
                return "Annual growth differences (%)";
            }
            case AnnualDifference: {
                return "Annual differences";
            }
        }
        return null;
    }
}

