% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.balancetest.R
\name{plot.balancetest}
\alias{plot.balancetest}
\title{Plot of balance across multiple strata}
\usage{
\method{plot}{balancetest}(
  x,
  xlab = "Standardized Differences",
  statistic = "std.diff",
  absolute = FALSE,
  strata.labels = NULL,
  variable.labels = NULL,
  groups = NULL,
  ...
)
}
\arguments{
\item{x}{An object returned by \code{\link{xBalance}}}

\item{xlab}{The label for the x-axis of the plot}

\item{statistic}{The statistic to plot. The default choice of standardized
difference is a good choice as it will have roughly the same scale for all
plotted variables.}

\item{absolute}{Convert the results to the absolute value of the statistic.}

\item{strata.labels}{A named vector of the from \code{c(strata1 = "Strata Label 1", ...)}
that maps the stratification schemes to textual labels.}

\item{variable.labels}{A named vector of the from \code{c(var1 = "Var Label1", ...)}
that maps the variables to textual labels.}

\item{groups}{A vector of group names for each variable in
\code{x$results}. By default, factor level variables will be
grouped.}

\item{...}{additional arguments to pass to \code{\link{balanceplot}}}
}
\value{
A \code{ggplot2} object that can be further manipulated (e.g., to set the colors or text).
}
\description{
The plot allows a quick visual comparison of the effect of different
stratification designs on the comparability of different
variables. This is not a replacement for the omnibus statistical test
reported as part of \code{\link{print.xbal}}. This plot does allow the
analyst an easy way to identify variables that might be the primary culprits
of overall imbalances and/or a way to assess whether certain important
covariates might be imbalanced even if the omnibus test reports that
the stratification overall produces balance.
}
\details{
By default all variables and all strata are plotted. The scope
of the plot can be reduced by using the \code{\link{subset.xbal}} function to
make a smaller \code{xbal} object with only the desired variables or
strata.

\code{\link{balanceTest}} can produce several different summary statistics for
each variable, any of which can serve as the data for this plot. By default,
the standardized differences between treated and control units makes a good
choice as all variables are on the same scale. Other statistics can be
selected using the \code{statistic} argument.

The result of this function is a \code{\link{ggplot}} object. Most display of
the plot can be manipulated using additional commands appended to the plot
option. For example, the entire theme of the plot can be changed to black and
white using \code{plot(b) + theme_bw()}, where \code{b} is the result of a
call to \code{\link{balanceTest}}. The points on the plot are known as
"values", so colors or symbols used for each strata can be updated using the
\code{\link{scale_color_manual}} function. For example, \code{plot(b) +
scale_color_manaual(values = c('red', 'green', 'blue'))} for a balance test
of three stratification variables.
}
\seealso{
\code{\link{balanceTest}}, \code{\link{ggplot}}
}
