% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ijzip.R
\name{plot.ijzip}
\alias{plot.ijzip}
\title{Plot ijzip object}
\usage{
\method{plot}{ijzip}(x, add = FALSE, xlab = "", ylab = "", main = "", asp = 1, ...)
}
\arguments{
\item{x}{The \code{ijzip} object.}

\item{add}{Whether to add to an existing plot.}

\item{xlab}{a title for the x axis: see \code{\link{title}}.}

\item{ylab}{a title for the y axis: see \code{\link{title}}.}

\item{main}{an overall title for the plot: see \code{\link{title}}.}

\item{asp}{numeric defining the aspect ratio y/x: see \code{\link{plot.window}}. Defaults to 1.}

\item{...}{Arguments to be passed to methods, such as graphical parameters (see \code{\link{par}}).}
}
\description{
Plots .zip files containing ImageJ ROI objects using the \link[=graphics]{'base' graphics} package.
}
\details{
The function loops \code{\link{plot.ijroi}} plotting function over all elements in \code{x}. See \code{plot.ijroi} for further details.
}
\examples{
file <- file.path(system.file(package = "RImageJROI"), "extdata", "ijroi", "ijzip.zip")
x <- read.ijzip(file)
plot(x)
}
\seealso{
\code{\link{read.ijzip}}, \code{\link{plot.ijroi}}
}
\author{
Mikko Vihtakari, David Sterratt
}
