/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Plot;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.ParticleAnalyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Color;

public class LineGraphAnalyzer
implements PlugInFilter,
Measurements {
    ImagePlus imp;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 129;
    }

    public void run(ImageProcessor imageProcessor) {
        this.analyze(this.imp);
    }

    public void analyze(ImagePlus imagePlus) {
        int n;
        boolean bl;
        ResultsTable resultsTable;
        int n2;
        int n3;
        ParticleAnalyzer particleAnalyzer;
        double d;
        ByteProcessor byteProcessor = (ByteProcessor)imagePlus.getProcessor();
        ImageProcessor imageProcessor = byteProcessor.crop();
        int n4 = imageProcessor.getWidth();
        int n5 = imageProcessor.getHeight();
        imageProcessor.setColor(Color.white);
        for (int i = 1; i < n4; i += 2) {
            imageProcessor.moveTo(i, 0);
            imageProcessor.lineTo(i, n5 - 1);
        }
        imageProcessor = imageProcessor.rotateRight();
        ImagePlus imagePlus2 = imagePlus.createImagePlus();
        imageProcessor.setThreshold(byteProcessor.getMinThreshold(), byteProcessor.getMaxThreshold(), 2);
        imagePlus2.setProcessor("Temp", imageProcessor);
        Calibration calibration = imagePlus2.getCalibration();
        double d2 = calibration.pixelWidth;
        calibration.pixelWidth = d = calibration.pixelHeight;
        calibration.pixelHeight = d2;
        imagePlus2.setCalibration(calibration);
        if (IJ.altKeyDown()) {
            imagePlus2.show();
        }
        if (!(particleAnalyzer = new ParticleAnalyzer(n3 = 32, n2 = 32, resultsTable = new ResultsTable(), (double)(bl = true), n = 999999)).analyze(imagePlus2)) {
            return;
        }
        float[] fArray = resultsTable.getColumn(6);
        if (fArray == null) {
            return;
        }
        float[] fArray2 = resultsTable.getColumn(7);
        double[] dArray = Tools.getMinMax(fArray2);
        double d3 = dArray[0];
        double d4 = dArray[1];
        dArray = Tools.getMinMax(fArray);
        double d5 = dArray[0];
        double d6 = dArray[1];
        String string = " (" + calibration.getUnits() + ")";
        String string2 = "X" + string;
        String string3 = "Y" + string;
        Plot plot = new Plot("Line Graph", string2, string3, fArray2, fArray);
        plot.setLimits(0.0, (double)n4 * d, 0.0, (double)n5 * d2);
        plot.show();
    }
}

