/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RoiProperties;
import ij.gui.ShapeRoi;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.filter.ThresholdToSelection;
import ij.plugin.frame.LineWidthAdjuster;
import ij.plugin.frame.RoiManager;
import ij.process.ByteProcessor;
import ij.process.EllipseFitter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Polygon;
import java.awt.Rectangle;

public class Selection
implements PlugIn,
Measurements {
    private ImagePlus imp;
    private float[] kernel = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private float[] kernel3 = new float[]{1.0f, 1.0f, 1.0f};
    private static String angle = "15";
    private static String enlarge = "15";
    private static String bandSize = "15";
    private static boolean nonScalable;
    private static Color linec;
    private static Color fillc;
    private static int lineWidth;

    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        if (string.equals("add")) {
            this.addToRoiManager(this.imp);
            return;
        }
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (string.equals("all")) {
            this.imp.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
        } else if (string.equals("none")) {
            this.imp.killRoi();
        } else if (string.equals("restore")) {
            this.imp.restoreRoi();
        } else if (string.equals("spline")) {
            this.fitSpline();
        } else if (string.equals("ellipse")) {
            this.drawEllipse(this.imp);
        } else if (string.equals("hull")) {
            this.convexHull(this.imp);
        } else if (string.equals("mask")) {
            this.createMask(this.imp);
        } else if (string.equals("from")) {
            this.createSelectionFromMask(this.imp);
        } else if (string.equals("inverse")) {
            this.invert(this.imp);
        } else if (string.equals("tobox")) {
            this.toBoundingBox(this.imp);
        } else if (string.equals("toarea")) {
            this.lineToArea(this.imp);
        } else if (string.equals("properties")) {
            this.setProperties("Properties", this.imp.getRoi());
            this.imp.draw();
        } else {
            this.runMacro(string);
        }
    }

    void runMacro(String string) {
        String string2;
        Roi roi = this.imp.getRoi();
        if (IJ.macroRunning() && (string2 = Macro.getOptions()) != null && (string2.indexOf("grid=") != -1 || string2.indexOf("interpolat") != -1)) {
            IJ.run("Rotate... ", string2);
            return;
        }
        if (roi == null) {
            IJ.error("Rotate>Selection", "This command requires a selection");
            return;
        }
        roi = (Roi)roi.clone();
        if (string.equals("rotate")) {
            String string3;
            double d = Tools.parseDouble(angle);
            if (Double.isNaN(d)) {
                angle = "15";
            }
            if ((string3 = IJ.runMacroFile("ij.jar:RotateSelection", angle)) != null) {
                angle = string3;
            }
        } else if (string.equals("enlarge")) {
            string2 = IJ.runMacroFile("ij.jar:EnlargeSelection", enlarge);
            if (string2 != null) {
                enlarge = string2;
            }
            Roi.previousRoi = roi;
        } else if (string.equals("band")) {
            string2 = IJ.runMacroFile("ij.jar:MakeSelectionBand", bandSize);
            if (string2 != null) {
                bandSize = string2;
            }
            Roi.previousRoi = roi;
        }
    }

    void fitSpline() {
        String string;
        boolean bl;
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            IJ.error("Spline", "Selection required");
            return;
        }
        int n = roi.getType();
        boolean bl2 = bl = n == 2 || n == 6;
        if (!bl && n != 3 && n != 4 && n != 7) {
            IJ.error("Spline", "Polygon or polyline selection required");
            return;
        }
        PolygonRoi polygonRoi = (PolygonRoi)roi;
        if (!bl) {
            polygonRoi = this.trimPolygon(polygonRoi, this.getUncalibratedLength(polygonRoi));
        }
        if ((string = Macro.getOptions()) != null && string.indexOf("straighten") != -1) {
            polygonRoi.fitSplineForStraightening();
        } else if (string != null && string.indexOf("remove") != -1) {
            polygonRoi.removeSplineFit();
        } else {
            polygonRoi.fitSpline();
        }
        this.imp.draw();
        LineWidthAdjuster.update();
    }

    double getUncalibratedLength(PolygonRoi polygonRoi) {
        Calibration calibration = this.imp.getCalibration();
        double d = calibration.pixelWidth;
        double d2 = calibration.pixelHeight;
        calibration.pixelWidth = 1.0;
        calibration.pixelHeight = 1.0;
        double d3 = polygonRoi.getLength();
        calibration.pixelWidth = d;
        calibration.pixelHeight = d2;
        return d3;
    }

    PolygonRoi trimPolygon(PolygonRoi polygonRoi, double d) {
        int n;
        int[] nArray = polygonRoi.getXCoordinates();
        int[] nArray2 = polygonRoi.getYCoordinates();
        int n2 = polygonRoi.getNCoordinates();
        nArray = this.smooth(nArray, n2);
        nArray2 = this.smooth(nArray2, n2);
        float[] fArray = this.getCurvature(nArray, nArray2, n2);
        Rectangle rectangle = polygonRoi.getBounds();
        double d2 = this.rodbard(d);
        double d3 = Math.sqrt((nArray[1] - nArray[0]) * (nArray[1] - nArray[0]) + (nArray2[1] - nArray2[0]) * (nArray2[1] - nArray2[0]));
        nArray[0] = nArray[0] + rectangle.x;
        nArray2[0] = nArray2[0] + rectangle.y;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        for (n = 1; n < n2 - 1; ++n) {
            int n6 = nArray[n];
            int n7 = nArray2[n];
            n4 = nArray[n + 1];
            n5 = nArray2[n + 1];
            d3 += Math.sqrt((n4 - n6) * (n4 - n6) + (n5 - n7) * (n5 - n7)) + 1.0;
            if (!((d3 += (double)(fArray[n] * 2.0f)) >= d2)) continue;
            nArray[n3] = n4 + rectangle.x;
            nArray2[n3] = n5 + rectangle.y;
            ++n3;
            d3 = 0.0;
        }
        int n8 = n = polygonRoi.getType() == 7 ? 6 : 2;
        if (n == 6 && d3 > 0.0) {
            nArray[n3] = n4 + rectangle.x;
            nArray2[n3] = n5 + rectangle.y;
            ++n3;
        }
        PolygonRoi polygonRoi2 = new PolygonRoi(nArray, nArray2, n3, n);
        this.imp.setRoi(polygonRoi2);
        return polygonRoi2;
    }

    double rodbard(double d) {
        double d2 = d == 0.0 ? 5.0 : Math.exp(Math.log(d / 700.0) * 0.88);
        double d3 = -40.1;
        return (d3 /= 1.0 + d2) + 44.0;
    }

    int[] smooth(int[] nArray, int n) {
        FloatProcessor floatProcessor = new FloatProcessor(n, 1);
        for (int i = 0; i < n; ++i) {
            floatProcessor.putPixelValue(i, 0, nArray[i]);
        }
        GaussianBlur gaussianBlur = new GaussianBlur();
        gaussianBlur.blur1Direction(floatProcessor, 2.0, 0.01, true, 0);
        for (int i = 0; i < n; ++i) {
            nArray[i] = Math.round(floatProcessor.getPixelValue(i, 0));
        }
        return nArray;
    }

    float[] getCurvature(int[] nArray, int[] nArray2, int n) {
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = nArray[i];
            fArray2[i] = nArray2[i];
        }
        FloatProcessor floatProcessor = new FloatProcessor(n, 1, fArray, null);
        FloatProcessor floatProcessor2 = new FloatProcessor(n, 1, fArray2, null);
        ((ImageProcessor)floatProcessor).convolve(this.kernel, this.kernel.length, 1);
        ((ImageProcessor)floatProcessor2).convolve(this.kernel, this.kernel.length, 1);
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray3[i] = i;
            fArray4[i] = (float)Math.sqrt((fArray[i] - (float)nArray[i]) * (fArray[i] - (float)nArray[i]) + (fArray2[i] - (float)nArray2[i]) * (fArray2[i] - (float)nArray2[i]));
        }
        return fArray4;
    }

    void drawEllipse(ImagePlus imagePlus) {
        ImageStatistics imageStatistics;
        IJ.showStatus("Fitting ellipse");
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            IJ.error("Fit Ellipse", "Selection required");
            return;
        }
        if (roi.isLine()) {
            IJ.error("Fit Ellipse", "\"Fit Ellipse\" does not work with line selections");
            return;
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (roi.getType() == 9) {
            imageStatistics = imagePlus.getStatistics();
        } else {
            imageProcessor.setRoi(roi.getPolygon());
            imageStatistics = ImageStatistics.getStatistics(imageProcessor, 27, null);
        }
        EllipseFitter ellipseFitter = new EllipseFitter();
        ellipseFitter.fit(imageProcessor, imageStatistics);
        ellipseFitter.makeRoi(imageProcessor);
        imagePlus.setRoi(new PolygonRoi(ellipseFitter.xCoordinates, ellipseFitter.yCoordinates, ellipseFitter.nCoordinates, 3));
        IJ.showStatus("");
    }

    void convexHull(ImagePlus imagePlus) {
        int n;
        Roi roi = imagePlus.getRoi();
        int n2 = n = roi != null ? roi.getType() : -1;
        if (n != 3 && n != 4 && n != 2 && n != 10) {
            IJ.error("Convex Hull", "Polygonal or point selection required");
            return;
        }
        Polygon polygon = roi.getConvexHull();
        if (polygon != null) {
            imagePlus.setRoi(new PolygonRoi(polygon.xpoints, polygon.ypoints, polygon.npoints, 2));
        }
    }

    int findFirstPoint(int[] nArray, int[] nArray2, int n, ImagePlus imagePlus) {
        int n2;
        int n3;
        int n4 = imagePlus.getHeight();
        for (n3 = 0; n3 < n; ++n3) {
            n2 = nArray2[n3];
            if (n2 >= n4) continue;
            n4 = n2;
        }
        n3 = imagePlus.getWidth();
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            int n6 = nArray[i];
            n2 = nArray2[i];
            if (n2 != n4 || n6 >= n3) continue;
            n3 = n6;
            n5 = i;
        }
        return n5;
    }

    void createMask(ImagePlus imagePlus) {
        ImageProcessor imageProcessor;
        Roi roi = imagePlus.getRoi();
        boolean bl = Prefs.useInvertingLut;
        Prefs.useInvertingLut = false;
        if (roi == null || !roi.isArea() && roi.getType() != 10) {
            this.createMaskFromThreshold(imagePlus);
            Prefs.useInvertingLut = bl;
            return;
        }
        ImagePlus imagePlus2 = null;
        Frame frame = WindowManager.getFrame("Mask");
        if (frame != null && frame instanceof ImageWindow) {
            imagePlus2 = ((ImageWindow)frame).getImagePlus();
        }
        if (imagePlus2 == null) {
            imageProcessor = new ByteProcessor(imagePlus.getWidth(), imagePlus.getHeight());
            if (!Prefs.blackBackground) {
                imageProcessor.invertLut();
            }
            imagePlus2 = new ImagePlus("Mask", imageProcessor);
            imagePlus2.show();
        }
        imageProcessor = imagePlus2.getProcessor();
        imageProcessor.setRoi(roi);
        imageProcessor.setValue(255.0);
        imageProcessor.fill(imageProcessor.getMask());
        imagePlus2.updateAndDraw();
        Prefs.useInvertingLut = bl;
    }

    void createMaskFromThreshold(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (imageProcessor.getMinThreshold() == -808080.0) {
            IJ.error("Create Mask", "Area selection or thresholded image required");
            return;
        }
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        IJ.run("Duplicate...", "title=mask");
        ImagePlus imagePlus2 = WindowManager.getCurrentImage();
        ImageProcessor imageProcessor2 = imagePlus2.getProcessor();
        imageProcessor2.setThreshold(d, d2, 2);
        IJ.run("Convert to Mask");
    }

    void createSelectionFromMask(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (imageProcessor.getMinThreshold() != -808080.0) {
            IJ.runPlugIn("ij.plugin.filter.ThresholdToSelection", "");
            return;
        }
        if (!imageProcessor.isBinary()) {
            IJ.error("Create Selection", "This command creates a composite selection from\na mask (8-bit binary image with white background)\nor from an image that has been thresholded using\nthe Image>Adjust>Threshold tool. The current\nimage is not a mask and has not been thresholded.");
            return;
        }
        int n = imageProcessor.isInvertedLut() ? 255 : 0;
        imageProcessor.setThreshold(n, n, 2);
        IJ.runPlugIn("ij.plugin.filter.ThresholdToSelection", "");
    }

    void invert(ImagePlus imagePlus) {
        Roi roi = imagePlus.getRoi();
        if (roi == null || !roi.isArea()) {
            IJ.error("Inverse", "Area selection required");
            return;
        }
        ShapeRoi shapeRoi = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
        ShapeRoi shapeRoi2 = new ShapeRoi(new Roi(0, 0, imagePlus.getWidth(), imagePlus.getHeight()));
        imagePlus.setRoi(shapeRoi.xor(shapeRoi2));
    }

    void lineToArea(ImagePlus imagePlus) {
        Roi roi = imagePlus.getRoi();
        if (roi == null || !roi.isLine()) {
            IJ.error("Line to Area", "Line selection required");
            return;
        }
        if (roi.getType() == 5 && roi.getStrokeWidth() == 1.0f) {
            IJ.error("Line to Area", "Straight line width must be > 1");
            return;
        }
        ByteProcessor byteProcessor = new ByteProcessor(imagePlus.getWidth(), imagePlus.getHeight());
        byteProcessor.setColor(255);
        if (roi.getType() == 5) {
            byteProcessor.fillPolygon(roi.getPolygon());
        } else {
            roi.drawPixels(byteProcessor);
        }
        ((ImageProcessor)byteProcessor).setThreshold(255.0, 255.0, 2);
        ThresholdToSelection thresholdToSelection = new ThresholdToSelection();
        Roi roi2 = thresholdToSelection.convert(byteProcessor);
        imagePlus.setRoi(roi2);
        Roi.previousRoi = (Roi)roi.clone();
    }

    void toBoundingBox(ImagePlus imagePlus) {
        Roi roi = imagePlus.getRoi();
        if (roi == null || roi.getType() == 0) {
            IJ.error("To Bounding Box", "Non-rectangular selection required");
            return;
        }
        Rectangle rectangle = roi.getBounds();
        imagePlus.killRoi();
        imagePlus.setRoi(new Roi(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
    }

    void addToRoiManager(ImagePlus imagePlus) {
        Frame frame;
        if (IJ.macroRunning() && Interpreter.isBatchModeRoiManager()) {
            IJ.error("run(\"Add to Manager\") may not work in batch mode macros");
        }
        if ((frame = WindowManager.getFrame("ROI Manager")) == null) {
            IJ.run("ROI Manager...");
        }
        if (imagePlus == null) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            return;
        }
        frame = WindowManager.getFrame("ROI Manager");
        if (frame == null || !(frame instanceof RoiManager)) {
            IJ.error("ROI Manager not found");
        }
        RoiManager roiManager = (RoiManager)frame;
        boolean bl = IJ.altKeyDown();
        IJ.setKeyUp(-1);
        if (bl) {
            IJ.setKeyDown(16);
        }
        roiManager.runCommand("add");
        IJ.setKeyUp(-1);
    }

    boolean setProperties(String string, Roi roi) {
        if (roi == null) {
            IJ.error("This command requires a selection.");
            return false;
        }
        RoiProperties roiProperties = new RoiProperties(string, roi);
        return roiProperties.showDialog();
    }

    static {
        lineWidth = 1;
    }
}

