/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.StackStatistics;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.StringTokenizer;
import java.util.Vector;

public class Distribution
implements PlugIn,
TextListener {
    static String parameter = "Area";
    static boolean autoBinning = true;
    static boolean showStats = false;
    static int nBins = 10;
    static String range = "0-0";
    Checkbox checkbox;
    TextField nBinsField;
    TextField rangeField;
    String defaultNBins;
    String defaultRange;

    public void run(String string) {
        float f;
        Object[] objectArray;
        ResultsTable resultsTable = ResultsTable.getResultsTable();
        int n = resultsTable.getCounter();
        if (n == 0) {
            IJ.error("Distribution", "The \"Results\" table is empty");
            return;
        }
        String string2 = resultsTable.getColumnHeadings();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
        int n2 = stringTokenizer.countTokens() - 1;
        String[] stringArray = new String[n2];
        stringArray[0] = stringTokenizer.nextToken();
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        this.defaultNBins = "" + nBins;
        this.defaultRange = range;
        GenericDialog genericDialog = new GenericDialog("Distribution");
        genericDialog.addChoice("Parameter: ", stringArray, stringArray[this.getIndex(stringArray)]);
        genericDialog.addMessage("Data points: " + n);
        genericDialog.addCheckbox("Automatic binning", autoBinning);
        genericDialog.addNumericField("or specify bins:", nBins, 0);
        genericDialog.addStringField("and range:", range);
        Vector vector = genericDialog.getNumericFields();
        this.nBinsField = (TextField)vector.elementAt(0);
        this.nBinsField.addTextListener(this);
        vector = genericDialog.getStringFields();
        this.rangeField = (TextField)vector.elementAt(0);
        this.rangeField.addTextListener(this);
        this.checkbox = (Checkbox)genericDialog.getCheckboxes().elementAt(0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        parameter = genericDialog.getNextChoice();
        autoBinning = genericDialog.getNextBoolean();
        double d = 0.0;
        double d2 = 0.0;
        if (!autoBinning) {
            nBins = (int)genericDialog.getNextNumber();
            range = genericDialog.getNextString();
            objectArray = Tools.split(range, " -");
            d = Tools.parseDouble((String)objectArray[0]);
            double d3 = d2 = objectArray.length == 2 ? Tools.parseDouble((String)objectArray[1]) : Double.NaN;
            if (Double.isNaN(d) || Double.isNaN(d2)) {
                d = 0.0;
                d2 = 0.0;
                range = "0-0";
            }
        }
        objectArray = resultsTable.getColumn(resultsTable.getColumnIndex(parameter));
        float[] fArray = new float[11];
        this.stats(n, (float[])objectArray, fArray);
        if (showStats) {
            IJ.log("Param: " + parameter);
            IJ.log("Data: " + fArray[1]);
            IJ.log("Sum: " + fArray[2]);
            IJ.log("Min: " + fArray[3]);
            IJ.log("Max: " + fArray[4]);
            IJ.log("Mean: " + fArray[5]);
            IJ.log("AvDev: " + fArray[6]);
            IJ.log("StDev: " + fArray[7]);
            IJ.log("Var: " + fArray[8]);
            IJ.log("Skew: " + fArray[9]);
            IJ.log("Kurt: " + fArray[10]);
            IJ.log(" ");
        }
        if (autoBinning && (nBins = (int)Math.floor((double)((fArray[4] - fArray[3]) / (f = (float)(3.49 * (double)fArray[7] * (double)((float)Math.pow(n, -0.3333333333333333))))) + 0.5)) < 2) {
            nBins = 2;
        }
        FloatProcessor floatProcessor = new FloatProcessor(n, 1, (float[])objectArray, null);
        ImagePlus imagePlus = new ImagePlus("", floatProcessor);
        StackStatistics stackStatistics = new StackStatistics(imagePlus, nBins, d, d2);
        int n3 = 0;
        for (int i = 0; i < stackStatistics.histogram.length; ++i) {
            if (stackStatistics.histogram[i] <= n3) continue;
            n3 = stackStatistics.histogram[i];
        }
        stackStatistics.histYMax = n3;
        new HistogramWindow(parameter + " Distribution", imagePlus, stackStatistics);
    }

    int getIndex(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(parameter)) continue;
            return i;
        }
        return 0;
    }

    public void textValueChanged(TextEvent textEvent) {
        if (!this.defaultNBins.equals(this.nBinsField.getText())) {
            this.checkbox.setState(false);
        }
        if (!this.defaultRange.equals(this.rangeField.getText())) {
            this.checkbox.setState(false);
        }
    }

    void stats(int n, float[] fArray, float[] fArray2) {
        int n2;
        float f = 0.0f;
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        for (n2 = 0; n2 < n; ++n2) {
            f4 += fArray[n2];
            if (fArray[n2] < f2) {
                f2 = fArray[n2];
            }
            if (!(fArray[n2] > f3)) continue;
            f3 = fArray[n2];
        }
        f5 = f4 / (float)n;
        for (n2 = 0; n2 < n; ++n2) {
            f = fArray[n2] - f5;
            f6 += Math.abs(f);
            float f11 = f * f;
            f8 += f11;
            f9 += (f11 *= f);
            f10 += (f11 *= f);
        }
        f6 /= (float)n;
        f7 = (float)Math.sqrt(f8 /= (float)(n - 1));
        if (f8 > 0.0f) {
            f9 /= (float)n * (float)Math.pow(f7, 3.0);
            f10 = f10 / ((float)n * (float)Math.pow(f8, 2.0)) - 3.0f;
        }
        fArray2[1] = n;
        fArray2[2] = f4;
        fArray2[3] = f2;
        fArray2[4] = f3;
        fArray2[5] = f5;
        fArray2[6] = f6;
        fArray2[7] = f7;
        fArray2[8] = f8;
        fArray2[9] = f9;
        fArray2[10] = f10;
    }
}

