/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Prefs;
import ij.VirtualStack;
import ij.gui.ImageCanvas;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.io.ImageWriter;
import ij.io.RoiEncoder;
import ij.io.SaveDialog;
import ij.io.TextEncoder;
import ij.io.TiffEncoder;
import ij.measure.Calibration;
import ij.plugin.JpegWriter;
import ij.plugin.Orthogonal_Views;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileSaver {
    public static final int DEFAULT_JPEG_QUALITY = 75;
    private static int jpegQuality;
    private static String defaultDirectory;
    private ImagePlus imp;
    private FileInfo fi;
    private String name;
    private String directory;

    public FileSaver(ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.fi = imagePlus.getFileInfo();
    }

    public boolean save() {
        boolean bl;
        FileInfo fileInfo = null;
        if (this.imp != null) {
            fileInfo = this.imp.getOriginalFileInfo();
        }
        boolean bl2 = bl = fileInfo != null && this.imp.getTitle().equals(fileInfo.fileName);
        if (bl && fileInfo.fileFormat == 2 && fileInfo.directory != null && !fileInfo.directory.equals("") && (fileInfo.url == null || fileInfo.url.equals(""))) {
            this.name = this.imp.getTitle();
            this.directory = fileInfo.directory;
            String string = this.directory + this.name;
            File file = new File(string);
            if (file == null || !file.exists()) {
                return this.saveAsTiff();
            }
            if (!IJ.isMacro() && !IJ.showMessageWithCancel("Save as TIFF", "The file " + fileInfo.fileName + " already exists.\nDo you want to replace it?")) {
                return false;
            }
            IJ.showStatus("Saving " + string);
            if (this.imp.getStackSize() > 1) {
                IJ.saveAs(this.imp, "tif", string);
                return true;
            }
            return this.saveAsTiff(string);
        }
        return this.saveAsTiff();
    }

    String getPath(String string, String string2) {
        this.name = this.imp.getTitle();
        SaveDialog saveDialog = new SaveDialog("Save as " + string, this.name, string2);
        this.name = saveDialog.getFileName();
        if (this.name == null) {
            return null;
        }
        this.directory = saveDialog.getDirectory();
        this.imp.startTiming();
        String string3 = this.directory + this.name;
        return string3;
    }

    public boolean saveAsTiff() {
        String string = this.getPath("TIFF", ".tif");
        if (string == null) {
            return false;
        }
        if (this.fi.nImages > 1) {
            return this.saveAsTiffStack(string);
        }
        return this.saveAsTiff(string);
    }

    public boolean saveAsTiff(String string) {
        Object object;
        this.fi.nImages = 1;
        Object object2 = this.imp.getProperty("Info");
        if (object2 != null && object2 instanceof String) {
            this.fi.info = (String)object2;
        }
        if ((object = this.imp.getProperty("Label")) != null && object instanceof String) {
            this.fi.sliceLabels = new String[1];
            this.fi.sliceLabels[0] = (String)object;
        }
        this.fi.description = this.getDescriptionString();
        this.fi.roi = RoiEncoder.saveAsByteArray(this.imp.getRoi());
        this.fi.overlay = this.getOverlay(this.imp);
        try {
            TiffEncoder tiffEncoder = new TiffEncoder(this.fi);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            tiffEncoder.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    byte[][] getOverlay(ImagePlus imagePlus) {
        int n;
        if (imagePlus.getHideOverlay()) {
            return null;
        }
        Overlay overlay = imagePlus.getOverlay();
        if (overlay == null) {
            ImageCanvas imageCanvas = imagePlus.getCanvas();
            if (imageCanvas == null) {
                return null;
            }
            overlay = imageCanvas.getShowAllList();
            if (overlay == null) {
                return null;
            }
        }
        if ((n = overlay.size()) == 0) {
            return null;
        }
        if (Orthogonal_Views.isOrthoViewsImage(imagePlus)) {
            return null;
        }
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < overlay.size(); ++i) {
            Roi roi = overlay.get(i);
            byArrayArray[i] = RoiEncoder.saveAsByteArray(roi);
        }
        return byArrayArray;
    }

    public boolean saveAsTiffStack(String string) {
        Object object;
        Object object2;
        Object object3;
        if (this.fi.nImages == 1) {
            IJ.error("This is not a stack");
            return false;
        }
        boolean bl = this.imp.getStack().isVirtual();
        if (bl) {
            this.fi.virtualStack = (VirtualStack)this.imp.getStack();
        }
        if ((object3 = this.imp.getProperty("Info")) != null && object3 instanceof String) {
            this.fi.info = (String)object3;
        }
        this.fi.description = this.getDescriptionString();
        if (bl) {
            object2 = null;
            object = this.imp.getStack();
            for (int i = 1; i <= ((ImageStack)object).getSize(); ++i) {
                ImageProcessor imageProcessor = ((ImageStack)object).getProcessor(i);
                String string2 = ((ImageStack)object).getSliceLabel(i);
                if (i == 1 && (string2 == null || string2.length() < 200)) break;
                if (object2 == null) {
                    object2 = new String[((ImageStack)object).getSize()];
                }
                object2[i - 1] = string2;
            }
            this.fi.sliceLabels = object2;
        } else {
            this.fi.sliceLabels = this.imp.getStack().getSliceLabels();
        }
        this.fi.roi = RoiEncoder.saveAsByteArray(this.imp.getRoi());
        this.fi.overlay = this.getOverlay(this.imp);
        if (this.imp.isComposite()) {
            this.saveDisplayRangesAndLuts(this.imp, this.fi);
        }
        try {
            object2 = new TiffEncoder(this.fi);
            object = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            ((TiffEncoder)object2).write((DataOutputStream)object);
            ((FilterOutputStream)object).close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    void saveDisplayRangesAndLuts(ImagePlus imagePlus, FileInfo fileInfo) {
        LUT lUT;
        int n;
        CompositeImage compositeImage = (CompositeImage)imagePlus;
        int n2 = imagePlus.getNChannels();
        fileInfo.displayRanges = new double[n2 * 2];
        for (n = 1; n <= n2; ++n) {
            lUT = compositeImage.getChannelLut(n);
            fileInfo.displayRanges[(n - 1) * 2] = lUT.min;
            fileInfo.displayRanges[(n - 1) * 2 + 1] = lUT.max;
        }
        if (compositeImage.hasCustomLuts()) {
            fileInfo.channelLuts = new byte[n2][];
            for (n = 0; n < n2; ++n) {
                lUT = compositeImage.getChannelLut(n + 1);
                byte[] byArray = lUT.getBytes();
                if (byArray == null) {
                    fileInfo.channelLuts = null;
                    break;
                }
                fileInfo.channelLuts[n] = byArray;
            }
        }
    }

    public boolean saveAsZip() {
        String string = this.getPath("TIFF/ZIP", ".zip");
        if (string == null) {
            return false;
        }
        return this.saveAsZip(string);
    }

    public boolean saveAsZip(String string) {
        if (!string.endsWith(".zip")) {
            string = string + ".zip";
        }
        if (this.name == null) {
            this.name = this.imp.getTitle();
        }
        if (this.name.endsWith(".zip")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
        if (!this.name.endsWith(".tif")) {
            this.name = this.name + ".tif";
        }
        this.fi.description = this.getDescriptionString();
        Object object = this.imp.getProperty("Info");
        if (object != null && object instanceof String) {
            this.fi.info = (String)object;
        }
        this.fi.roi = RoiEncoder.saveAsByteArray(this.imp.getRoi());
        this.fi.overlay = this.getOverlay(this.imp);
        this.fi.sliceLabels = this.imp.getStack().getSliceLabels();
        if (this.imp.isComposite()) {
            this.saveDisplayRangesAndLuts(this.imp, this.fi);
        }
        if (this.fi.nImages > 1 && this.imp.getStack().isVirtual()) {
            this.fi.virtualStack = (VirtualStack)this.imp.getStack();
        }
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(zipOutputStream));
            zipOutputStream.putNextEntry(new ZipEntry(this.name));
            TiffEncoder tiffEncoder = new TiffEncoder(this.fi);
            tiffEncoder.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    public static boolean okForGif(ImagePlus imagePlus) {
        int n = imagePlus.getType();
        if (n == 4) {
            IJ.error("To save as Gif, the image must be converted to \"8-bit Color\".");
            return false;
        }
        return true;
    }

    public boolean saveAsGif() {
        if (!FileSaver.okForGif(this.imp)) {
            return false;
        }
        String string = this.getPath("GIF", ".gif");
        if (string == null) {
            return false;
        }
        return this.saveAsGif(string);
    }

    public boolean saveAsGif(String string) {
        if (!FileSaver.okForGif(this.imp)) {
            return false;
        }
        IJ.runPlugIn(this.imp, "ij.plugin.GifWriter", string);
        this.updateImp(this.fi, 3);
        return true;
    }

    public static boolean okForJpeg(ImagePlus imagePlus) {
        return true;
    }

    public boolean saveAsJpeg() {
        String string = "JPEG (" + FileSaver.getJpegQuality() + ")";
        String string2 = this.getPath(string, ".jpg");
        if (string2 == null) {
            return false;
        }
        return this.saveAsJpeg(string2);
    }

    public boolean saveAsJpeg(String string) {
        String string2 = JpegWriter.save(this.imp, string, jpegQuality);
        if (string2 == null && this.imp.getType() != 1 && this.imp.getType() != 2) {
            this.updateImp(this.fi, 3);
        }
        return true;
    }

    public boolean saveAsBmp() {
        String string = this.getPath("BMP", ".bmp");
        if (string == null) {
            return false;
        }
        return this.saveAsBmp(string);
    }

    public boolean saveAsBmp(String string) {
        IJ.runPlugIn(this.imp, "ij.plugin.BMP_Writer", string);
        this.updateImp(this.fi, 5);
        return true;
    }

    public boolean saveAsPgm() {
        String string = this.imp.getBitDepth() == 24 ? ".pnm" : ".pgm";
        String string2 = this.getPath("PGM", string);
        if (string2 == null) {
            return false;
        }
        return this.saveAsPgm(string2);
    }

    public boolean saveAsPgm(String string) {
        IJ.runPlugIn(this.imp, "ij.plugin.PNM_Writer", string);
        this.updateImp(this.fi, 8);
        return true;
    }

    public boolean saveAsPng() {
        String string = this.getPath("PNG", ".png");
        if (string == null) {
            return false;
        }
        return this.saveAsPng(string);
    }

    public boolean saveAsPng(String string) {
        IJ.runPlugIn(this.imp, "ij.plugin.PNG_Writer", string);
        this.updateImp(this.fi, 9);
        return true;
    }

    public boolean saveAsFits() {
        if (!FileSaver.okForFits(this.imp)) {
            return false;
        }
        String string = this.getPath("FITS", ".fits");
        if (string == null) {
            return false;
        }
        return this.saveAsFits(string);
    }

    public boolean saveAsFits(String string) {
        if (!FileSaver.okForFits(this.imp)) {
            return false;
        }
        IJ.runPlugIn(this.imp, "ij.plugin.FITS_Writer", string);
        this.updateImp(this.fi, 4);
        return true;
    }

    public static boolean okForFits(ImagePlus imagePlus) {
        if (imagePlus.getBitDepth() == 24) {
            IJ.error("FITS Writer", "Grayscale image required");
            return false;
        }
        return true;
    }

    public boolean saveAsRaw() {
        String string = this.getPath("Raw", ".raw");
        if (string == null) {
            return false;
        }
        if (this.imp.getStackSize() == 1) {
            return this.saveAsRaw(string);
        }
        return this.saveAsRawStack(string);
    }

    public boolean saveAsRaw(String string) {
        this.fi.nImages = 1;
        this.fi.intelByteOrder = Prefs.intelByteOrder;
        boolean bl = false;
        short[] sArray = null;
        int n = 0;
        try {
            bl = this.imp.getCalibration().isSigned16Bit();
            if (bl) {
                sArray = (short[])this.imp.getProcessor().getPixels();
                n = this.imp.getWidth() * this.imp.getHeight();
                for (int i = 0; i < n; ++i) {
                    sArray[i] = (short)(sArray[i] - 32768);
                }
            }
            ImageWriter imageWriter = new ImageWriter(this.fi);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            imageWriter.write(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                sArray[i] = (short)(sArray[i] + 32768);
            }
        }
        this.updateImp(this.fi, 1);
        return true;
    }

    public boolean saveAsRawStack(String string) {
        int n;
        Object object;
        boolean bl;
        if (this.fi.nImages == 1) {
            IJ.write("This is not a stack");
            return false;
        }
        this.fi.intelByteOrder = Prefs.intelByteOrder;
        boolean bl2 = false;
        Object[] objectArray = null;
        int n2 = 0;
        boolean bl3 = bl = this.imp.getStackSize() > 1 && this.imp.getStack().isVirtual();
        if (bl) {
            this.fi.virtualStack = (VirtualStack)this.imp.getStack();
            if (this.imp.getProperty("AnalyzeFormat") != null) {
                this.fi.fileName = "FlipTheseImages";
            }
        }
        try {
            bl2 = this.imp.getCalibration().isSigned16Bit();
            if (bl2 && !bl) {
                objectArray = (Object[])this.fi.pixels;
                n2 = this.imp.getWidth() * this.imp.getHeight();
                for (int i = 0; i < this.fi.nImages; ++i) {
                    object = (short[])objectArray[i];
                    for (n = 0; n < n2; ++n) {
                        object[n] = (short)(object[n] - 32768);
                    }
                }
            }
            ImageWriter imageWriter = new ImageWriter(this.fi);
            object = new BufferedOutputStream(new FileOutputStream(string));
            imageWriter.write((OutputStream)object);
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        if (bl2) {
            for (int i = 0; i < this.fi.nImages; ++i) {
                object = (short[])objectArray[i];
                for (n = 0; n < n2; ++n) {
                    object[n] = (short)(object[n] + 32768);
                }
            }
        }
        this.updateImp(this.fi, 1);
        return true;
    }

    public boolean saveAsText() {
        String string = this.getPath("Text", ".txt");
        if (string == null) {
            return false;
        }
        return this.saveAsText(string);
    }

    public boolean saveAsText(String string) {
        try {
            Calibration calibration = this.imp.getCalibration();
            int n = Analyzer.getPrecision();
            TextEncoder textEncoder = new TextEncoder(this.imp.getProcessor(), calibration, n);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            textEncoder.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        return true;
    }

    public boolean saveAsLut() {
        if (this.imp.getType() == 4) {
            IJ.error("RGB Images do not have a LUT.");
            return false;
        }
        String string = this.getPath("LUT", ".lut");
        if (string == null) {
            return false;
        }
        return this.saveAsLut(string);
    }

    public boolean saveAsLut(String string) {
        LookUpTable lookUpTable = this.imp.createLut();
        int n = lookUpTable.getMapSize();
        if (n == 0) {
            IJ.error("RGB Images do not have a LUT.");
            return false;
        }
        if (n < 256) {
            IJ.error("Cannot save LUTs with less than 256 entries.");
            return false;
        }
        byte[] byArray = lookUpTable.getReds();
        byte[] byArray2 = lookUpTable.getGreens();
        byte[] byArray3 = lookUpTable.getBlues();
        byte[] byArray4 = new byte[768];
        for (int i = 0; i < 256; ++i) {
            byArray4[i] = byArray[i];
            byArray4[i + 256] = byArray2[i];
            byArray4[i + 512] = byArray3[i];
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.width = 768;
        fileInfo.height = 1;
        fileInfo.pixels = byArray4;
        try {
            ImageWriter imageWriter = new ImageWriter(fileInfo);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            imageWriter.write(fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            this.showErrorMessage(iOException);
            return false;
        }
        return true;
    }

    private void updateImp(FileInfo fileInfo, int n) {
        this.imp.changes = false;
        if (this.name != null) {
            fileInfo.fileFormat = n;
            fileInfo.fileName = this.name;
            fileInfo.directory = this.directory;
            fileInfo.description = null;
            this.imp.setTitle(this.name);
            this.imp.setFileInfo(fileInfo);
        }
    }

    void showErrorMessage(IOException iOException) {
        String string = iOException.getMessage();
        if (string.length() > 100) {
            string = string.substring(0, 100);
        }
        IJ.error("FileSaver", "An error occured writing the file.\n \n" + string);
    }

    public String getDescriptionString() {
        boolean bl;
        Object object;
        int n;
        int n2;
        int n3;
        Calibration calibration = this.imp.getCalibration();
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ImageJ=1.44i\n");
        if (this.fi.nImages > 1 && this.fi.fileType != 12) {
            stringBuffer.append("images=" + this.fi.nImages + "\n");
        }
        if ((n3 = this.imp.getNChannels()) > 1) {
            stringBuffer.append("channels=" + n3 + "\n");
        }
        if ((n2 = this.imp.getNSlices()) > 1) {
            stringBuffer.append("slices=" + n2 + "\n");
        }
        if ((n = this.imp.getNFrames()) > 1) {
            stringBuffer.append("frames=" + n + "\n");
        }
        if (this.imp.isHyperStack()) {
            stringBuffer.append("hyperstack=true\n");
        }
        if (this.imp.isComposite()) {
            object = ((CompositeImage)this.imp).getModeAsString();
            stringBuffer.append("mode=" + (String)object + "\n");
        }
        if (this.fi.unit != null) {
            stringBuffer.append("unit=" + (this.fi.unit.equals("\u00b5m") ? "um" : this.fi.unit) + "\n");
        }
        if (this.fi.valueUnit != null && this.fi.calibrationFunction != 22) {
            stringBuffer.append("cf=" + this.fi.calibrationFunction + "\n");
            if (this.fi.coefficients != null) {
                for (int i = 0; i < this.fi.coefficients.length; ++i) {
                    stringBuffer.append("c" + i + "=" + this.fi.coefficients[i] + "\n");
                }
            }
            stringBuffer.append("vunit=" + this.fi.valueUnit + "\n");
            if (calibration.zeroClip()) {
                stringBuffer.append("zeroclip=true\n");
            }
        }
        if (calibration.frameInterval != 0.0) {
            if ((double)((int)calibration.frameInterval) == calibration.frameInterval) {
                stringBuffer.append("finterval=" + (int)calibration.frameInterval + "\n");
            } else {
                stringBuffer.append("finterval=" + calibration.frameInterval + "\n");
            }
        }
        if (!calibration.getTimeUnit().equals("sec")) {
            stringBuffer.append("tunit=" + calibration.getTimeUnit() + "\n");
        }
        if (this.fi.nImages > 1) {
            if (this.fi.pixelDepth != 0.0 && this.fi.pixelDepth != 1.0) {
                stringBuffer.append("spacing=" + this.fi.pixelDepth + "\n");
            }
            if (calibration.fps != 0.0) {
                if ((double)((int)calibration.fps) == calibration.fps) {
                    stringBuffer.append("fps=" + (int)calibration.fps + "\n");
                } else {
                    stringBuffer.append("fps=" + calibration.fps + "\n");
                }
            }
            stringBuffer.append("loop=" + (calibration.loop ? "true" : "false") + "\n");
        }
        object = this.imp.getProcessor();
        double d = ((ImageProcessor)object).getMin();
        double d2 = ((ImageProcessor)object).getMax();
        int n4 = this.imp.getType();
        boolean bl2 = bl = !(n4 != 0 && n4 != 3 || d == 0.0 && d2 == 255.0);
        if (bl || n4 == 1 || n4 == 2) {
            stringBuffer.append("min=" + d + "\n");
            stringBuffer.append("max=" + d2 + "\n");
        }
        if (calibration.xOrigin != 0.0) {
            stringBuffer.append("xorigin=" + calibration.xOrigin + "\n");
        }
        if (calibration.yOrigin != 0.0) {
            stringBuffer.append("yorigin=" + calibration.yOrigin + "\n");
        }
        if (calibration.zOrigin != 0.0) {
            stringBuffer.append("zorigin=" + calibration.zOrigin + "\n");
        }
        if (calibration.info != null && calibration.info.length() <= 64 && calibration.info.indexOf(61) == -1 && calibration.info.indexOf(10) == -1) {
            stringBuffer.append("info=" + calibration.info + "\n");
        }
        stringBuffer.append('\u0000');
        return new String(stringBuffer);
    }

    public static void setJpegQuality(int n) {
        jpegQuality = n;
        if (jpegQuality < 0) {
            jpegQuality = 0;
        }
        if (jpegQuality > 100) {
            jpegQuality = 100;
        }
    }

    public static int getJpegQuality() {
        return jpegQuality;
    }

    static {
        FileSaver.setJpegQuality(Prefs.getInt("jpeg", 75));
        defaultDirectory = null;
    }
}

