/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.plugin.filter.RGBStackSplitter;
import ij.plugin.frame.Channels;
import ij.plugin.frame.ContrastAdjuster;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class CompositeImage
extends ImagePlus {
    public static final int COMPOSITE = 1;
    public static final int COLOR = 2;
    public static final int GRAYSCALE = 3;
    public static final int TRANSPARENT = 4;
    public static final int MAX_CHANNELS = 7;
    int[] rgbPixels;
    boolean newPixels;
    MemoryImageSource imageSource;
    Image awtImage;
    WritableRaster rgbRaster;
    SampleModel rgbSampleModel;
    BufferedImage rgbImage;
    ColorModel rgbCM;
    ImageProcessor[] cip;
    Color[] colors = new Color[]{Color.red, Color.green, Color.blue, Color.white, Color.cyan, Color.magenta, Color.yellow};
    LUT[] lut;
    int currentChannel = -1;
    int previousChannel;
    int currentSlice = 1;
    int currentFrame = 1;
    static int count;
    boolean singleChannel;
    boolean[] active = new boolean[7];
    int mode = 2;
    int bitDepth;
    double[] displayRanges;
    byte[][] channelLuts;
    boolean customLuts;
    boolean syncChannels;
    boolean channelsUpdated;

    public CompositeImage(ImagePlus imagePlus) {
        this(imagePlus, 2);
    }

    public CompositeImage(ImagePlus imagePlus, int n) {
        ImageStack imageStack;
        boolean bl;
        if (n < 1 || n > 3) {
            n = 2;
        }
        this.mode = n;
        int n2 = imagePlus.getNChannels();
        this.bitDepth = this.getBitDepth();
        if (IJ.debugMode) {
            IJ.log("CompositeImage: " + imagePlus + " " + n + " " + n2);
        }
        boolean bl2 = bl = imagePlus.getBitDepth() == 24;
        if (bl) {
            if (imagePlus.getImageStackSize() > 1) {
                throw new IllegalArgumentException("RGB stacks not supported");
            }
            imageStack = this.getRGBStack(imagePlus);
        } else {
            imageStack = imagePlus.getImageStack();
        }
        int n3 = imageStack.getSize();
        if (n2 == 1 && bl) {
            n2 = 3;
        }
        if (n2 == 1 && n3 <= 7) {
            n2 = n3;
        }
        if (n2 < 2 || n3 % n2 != 0) {
            throw new IllegalArgumentException("channels<2 or stacksize not multiple of channels");
        }
        if (n == 1 && n2 > 7) {
            this.mode = 2;
        }
        this.compositeImage = true;
        int n4 = imagePlus.getNSlices();
        int n5 = imagePlus.getNFrames();
        if (n2 == n3 || n2 * n4 * n5 != n3) {
            this.setDimensions(n2, n3 / n2, 1);
        } else {
            this.setDimensions(n2, n4, n5);
        }
        this.setStack(imagePlus.getTitle(), imageStack);
        this.setCalibration(imagePlus.getCalibration());
        FileInfo fileInfo = imagePlus.getOriginalFileInfo();
        if (fileInfo != null) {
            this.displayRanges = fileInfo.displayRanges;
            this.channelLuts = fileInfo.channelLuts;
        }
        this.setFileInfo(fileInfo);
        Object object = imagePlus.getProperty("Info");
        if (object != null) {
            this.setProperty("Info", imagePlus.getProperty("Info"));
        }
        if (n == 1) {
            for (int i = 0; i < 7; ++i) {
                this.active[i] = true;
            }
        } else {
            this.active[0] = true;
        }
        this.setRoi(imagePlus.getRoi());
        this.setOverlay(imagePlus.getOverlay());
        if (n2 != n3) {
            this.setOpenAsHyperStack(true);
        }
    }

    public Image getImage() {
        if (this.img == null) {
            this.updateImage();
        }
        return this.img;
    }

    public void updateChannelAndDraw() {
        if (!this.customLuts) {
            this.singleChannel = true;
        }
        this.updateAndDraw();
    }

    public void updateAllChannelsAndDraw() {
        if (this.mode != 1) {
            this.updateChannelAndDraw();
        } else {
            this.syncChannels = true;
            this.singleChannel = false;
            this.updateAndDraw();
        }
    }

    public ImageProcessor getChannelProcessor() {
        if (this.cip != null && this.currentChannel != -1) {
            return this.cip[this.currentChannel];
        }
        return this.getProcessor();
    }

    void setup(int n, ImageStack imageStack) {
        this.setupLuts(n);
        if (this.mode == 1) {
            this.cip = new ImageProcessor[n];
            for (int i = 0; i < n; ++i) {
                this.cip[i] = imageStack.getProcessor(i + 1);
                this.cip[i].setColorModel(this.lut[i]);
                this.cip[i].setMinAndMax(this.lut[i].min, this.lut[i].max);
            }
            this.currentFrame = 1;
            this.currentSlice = 1;
        }
    }

    void setupLuts(int n) {
        if (this.lut == null || this.lut.length < n) {
            if (this.displayRanges != null && n != this.displayRanges.length / 2) {
                this.displayRanges = null;
            }
            if (this.displayRanges == null && this.ip.getMin() == 0.0 && this.ip.getMax() == 0.0) {
                this.ip.resetMinAndMax();
            }
            this.lut = new LUT[n];
            LUT lUT = n > 7 ? this.createLutFromColor(Color.white) : null;
            for (int i = 0; i < n; ++i) {
                if (this.channelLuts != null && i < this.channelLuts.length) {
                    this.lut[i] = this.createLutFromBytes(this.channelLuts[i]);
                    this.customLuts = true;
                } else {
                    this.lut[i] = i < 7 ? this.createLutFromColor(this.colors[i]) : (LUT)lUT.clone();
                }
                if (this.displayRanges != null) {
                    this.lut[i].min = this.displayRanges[i * 2];
                    this.lut[i].max = this.displayRanges[i * 2 + 1];
                    continue;
                }
                this.lut[i].min = this.ip.getMin();
                this.lut[i].max = this.ip.getMax();
            }
            this.displayRanges = null;
        }
    }

    public void resetDisplayRanges() {
        int n = this.getNChannels();
        ImageStack imageStack = this.getImageStack();
        if (this.lut == null || n != this.lut.length || n > imageStack.getSize() || n > 7) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            ImageProcessor imageProcessor = imageStack.getProcessor(i + 1);
            imageProcessor.resetMinAndMax();
            this.lut[i].min = imageProcessor.getMin();
            this.lut[i].max = imageProcessor.getMax();
        }
    }

    public void updateAndDraw() {
        this.updateImage();
        if (this.win != null) {
            this.notifyListeners(2);
        }
        this.draw();
    }

    public synchronized void updateImage() {
        int n = this.width * this.height;
        int n2 = this.getNChannels();
        int n3 = this.getChannel();
        if (n3 > n2) {
            n3 = n2;
        }
        boolean bl = false;
        if (n3 - 1 != this.currentChannel) {
            this.previousChannel = this.currentChannel;
            this.currentChannel = n3 - 1;
            bl = true;
        }
        ImageProcessor imageProcessor = this.getProcessor();
        if (this.mode != 1) {
            if (bl) {
                this.setupLuts(n2);
                LUT lUT = this.lut[this.currentChannel];
                if (this.mode == 2) {
                    imageProcessor.setColorModel(lUT);
                }
                if (lUT.min != 0.0 || lUT.max != 0.0) {
                    imageProcessor.setMinAndMax(lUT.min, lUT.max);
                }
                if (!IJ.isMacro()) {
                    ContrastAdjuster.update();
                }
                Frame frame = Channels.getInstance();
                for (int i = 0; i < 7; ++i) {
                    this.active[i] = i == this.currentChannel;
                }
                if (frame != null) {
                    ((Channels)frame).update();
                }
            }
            this.img = imageProcessor.createImage();
            return;
        }
        if (n2 == 1) {
            this.cip = null;
            this.rgbPixels = null;
            this.awtImage = null;
            if (imageProcessor != null) {
                this.img = imageProcessor.createImage();
            }
            return;
        }
        if (this.cip == null || this.cip[0].getWidth() != this.width || this.cip[0].getHeight() != this.height || this.getBitDepth() != this.bitDepth) {
            this.setup(n2, this.getImageStack());
            this.rgbPixels = null;
            this.rgbSampleModel = null;
            if (this.currentChannel >= n2) {
                this.setSlice(1);
                this.currentChannel = 0;
                bl = true;
            }
            this.bitDepth = this.getBitDepth();
        }
        if (bl) {
            this.getProcessor().setMinAndMax(this.cip[this.currentChannel].getMin(), this.cip[this.currentChannel].getMax());
            if (!IJ.isMacro()) {
                ContrastAdjuster.update();
            }
        }
        if (this.getSlice() != this.currentSlice || this.getFrame() != this.currentFrame || this.channelsUpdated) {
            this.channelsUpdated = false;
            this.currentSlice = this.getSlice();
            this.currentFrame = this.getFrame();
            int n4 = this.getStackIndex(1, this.currentSlice, this.currentFrame);
            for (int i = 0; i < n2; ++i) {
                this.cip[i].setPixels(this.getImageStack().getProcessor(n4 + i).getPixels());
            }
        }
        if (this.rgbPixels == null) {
            this.rgbPixels = new int[n];
            this.newPixels = true;
            this.imageSource = null;
            this.rgbRaster = null;
            this.rgbImage = null;
        }
        this.cip[this.currentChannel].setMinAndMax(imageProcessor.getMin(), imageProcessor.getMax());
        if (this.singleChannel && n2 <= 3) {
            switch (this.currentChannel) {
                case 0: {
                    this.cip[0].updateComposite(this.rgbPixels, 1);
                    break;
                }
                case 1: {
                    this.cip[1].updateComposite(this.rgbPixels, 2);
                    break;
                }
                case 2: {
                    this.cip[2].updateComposite(this.rgbPixels, 3);
                }
            }
        } else {
            if (this.syncChannels) {
                ImageProcessor imageProcessor2 = this.getProcessor();
                double d = imageProcessor2.getMin();
                double d2 = imageProcessor2.getMax();
                for (int i = 0; i < n2; ++i) {
                    this.cip[i].setMinAndMax(d, d2);
                    this.lut[i].min = d;
                    this.lut[i].max = d2;
                }
                this.syncChannels = false;
            }
            if (this.active[0]) {
                this.cip[0].updateComposite(this.rgbPixels, 4);
            } else {
                for (int i = 1; i < n; ++i) {
                    this.rgbPixels[i] = 0;
                }
            }
            for (int i = 1; i < n2; ++i) {
                if (!this.active[i]) continue;
                this.cip[i].updateComposite(this.rgbPixels, 5);
            }
        }
        if (IJ.isJava16()) {
            this.createBufferedImage();
        } else {
            this.createImage();
        }
        if (this.img == null && this.awtImage != null) {
            this.img = this.awtImage;
        }
        this.singleChannel = false;
    }

    void createImage() {
        if (this.imageSource == null) {
            this.rgbCM = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.imageSource = new MemoryImageSource(this.width, this.height, this.rgbCM, this.rgbPixels, 0, this.width);
            this.imageSource.setAnimated(true);
            this.imageSource.setFullBufferUpdates(true);
            this.awtImage = Toolkit.getDefaultToolkit().createImage(this.imageSource);
            this.newPixels = false;
        } else if (this.newPixels) {
            this.imageSource.newPixels(this.rgbPixels, this.rgbCM, 0, this.width);
            this.newPixels = false;
        } else {
            this.imageSource.newPixels();
        }
    }

    void createBufferedImage() {
        if (this.rgbSampleModel == null) {
            this.rgbSampleModel = this.getRGBSampleModel();
        }
        if (this.rgbRaster == null) {
            DataBufferInt dataBufferInt = new DataBufferInt(this.rgbPixels, this.width * this.height, 0);
            this.rgbRaster = Raster.createWritableRaster(this.rgbSampleModel, dataBufferInt, null);
        }
        if (this.rgbImage == null) {
            this.rgbImage = new BufferedImage(this.rgbCM, this.rgbRaster, false, null);
        }
        this.awtImage = this.rgbImage;
    }

    SampleModel getRGBSampleModel() {
        this.rgbCM = new DirectColorModel(24, 0xFF0000, 65280, 255);
        WritableRaster writableRaster = this.rgbCM.createCompatibleWritableRaster(1, 1);
        SampleModel sampleModel = writableRaster.getSampleModel();
        sampleModel = sampleModel.createCompatibleSampleModel(this.width, this.height);
        return sampleModel;
    }

    ImageStack getRGBStack(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        int n3 = n * n2;
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        ((ColorProcessor)imageProcessor).getRGB(byArray, byArray2, byArray3);
        ImageStack imageStack = new ImageStack(n, n2);
        imageStack.addSlice("Red", byArray);
        imageStack.addSlice("Green", byArray2);
        imageStack.addSlice("Blue", byArray3);
        imageStack.setColorModel(imageProcessor.getDefaultColorModel());
        return imageStack;
    }

    public LUT createLutFromColor(Color color) {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        double d = (double)n / 255.0;
        double d2 = (double)n2 / 255.0;
        double d3 = (double)n3 / 255.0;
        for (int i = 0; i < 256; ++i) {
            byArray[i] = (byte)((double)i * d);
            byArray2[i] = (byte)((double)i * d2);
            byArray3[i] = (byte)((double)i * d3);
        }
        return new LUT(byArray, byArray2, byArray3);
    }

    LUT createLutFromBytes(byte[] byArray) {
        int n;
        if (byArray == null || byArray.length != 768) {
            return this.createLutFromColor(Color.white);
        }
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        byte[] byArray4 = new byte[256];
        for (n = 0; n < 256; ++n) {
            byArray2[n] = byArray[n];
        }
        for (n = 0; n < 256; ++n) {
            byArray3[n] = byArray[256 + n];
        }
        for (n = 0; n < 256; ++n) {
            byArray4[n] = byArray[512 + n];
        }
        return new LUT(byArray2, byArray3, byArray4);
    }

    public Color getChannelColor() {
        if (this.lut == null || this.mode == 3) {
            return Color.black;
        }
        LUT lUT = this.lut[this.getChannelIndex()];
        if (lUT == null) {
            return Color.black;
        }
        int n = lUT.getMapSize() - 1;
        int n2 = lUT.getRed(n);
        int n3 = lUT.getGreen(n);
        int n4 = lUT.getBlue(n);
        if (n2 < 100 || n3 < 100 || n4 < 100) {
            return new Color(n2, n3, n4);
        }
        return Color.black;
    }

    public ImageProcessor getProcessor(int n) {
        if (this.cip == null || n > this.cip.length) {
            return null;
        }
        return this.cip[n - 1];
    }

    public boolean[] getActiveChannels() {
        return this.active;
    }

    public void setMode(int n) {
        Frame frame;
        int n2;
        if (n < 1 || n > 3) {
            return;
        }
        if (n == 1 && this.getNChannels() > 7) {
            n = 2;
        }
        for (n2 = 0; n2 < 7; ++n2) {
            this.active[n2] = true;
        }
        if (this.mode != 1 && n == 1) {
            this.img = null;
        }
        this.mode = n;
        if (n == 2 || n == 3) {
            if (this.cip != null) {
                for (n2 = 0; n2 < this.cip.length; ++n2) {
                    if (this.cip[n2] != null) {
                        this.cip[n2].setPixels(null);
                    }
                    this.cip[n2] = null;
                }
            }
            this.cip = null;
            this.rgbPixels = null;
            this.awtImage = null;
            this.currentChannel = -1;
        }
        if (n == 3 || n == 4) {
            this.ip.setColorModel(this.ip.getDefaultColorModel());
        }
        if ((frame = Channels.getInstance()) != null) {
            ((Channels)frame).update();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public String getModeAsString() {
        switch (this.mode) {
            case 1: {
                return "composite";
            }
            case 2: {
                return "color";
            }
            case 3: {
                return "grayscale";
            }
        }
        return "";
    }

    public LUT getChannelLut(int n) {
        int n2 = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(n2);
        }
        if (n < 1 || n > this.lut.length) {
            throw new IllegalArgumentException("Channel out of range");
        }
        return this.lut[n - 1];
    }

    public LUT getChannelLut() {
        int n = this.getChannelIndex();
        return this.lut[n];
    }

    public LUT[] getLuts() {
        int n = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(n);
        }
        LUT[] lUTArray = new LUT[n];
        for (int i = 0; i < n; ++i) {
            lUTArray[i] = (LUT)this.lut[i].clone();
        }
        return lUTArray;
    }

    public void setLuts(LUT[] lUTArray) {
        int n = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(n);
        }
        if (lUTArray == null || lUTArray.length < n) {
            throw new IllegalArgumentException("Lut array is null or too small");
        }
        for (int i = 0; i < n; ++i) {
            this.setChannelLut(lUTArray[i], i + 1);
        }
    }

    public void copyLuts(ImagePlus imagePlus) {
        int n = this.getNChannels();
        if (!imagePlus.isComposite() || imagePlus.getNChannels() != n) {
            return;
        }
        CompositeImage compositeImage = (CompositeImage)imagePlus;
        LUT[] lUTArray = compositeImage.getLuts();
        if (lUTArray != null && lUTArray.length == n) {
            this.lut = lUTArray;
            this.cip = null;
        }
        int n2 = compositeImage.getMode();
        this.setMode(n2);
        if (n2 == 1) {
            boolean[] blArray = compositeImage.getActiveChannels();
            for (int i = 0; i < 7; ++i) {
                this.active[i] = blArray[i];
            }
        }
    }

    int getChannelIndex() {
        int n = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(n);
        }
        int n2 = this.getChannel() - 1;
        return n2;
    }

    public void reset() {
        this.setup(this.getNChannels(), this.getImageStack());
    }

    public void setChannelLut(LUT lUT) {
        if (this.mode == 3) {
            this.getProcessor().setColorModel(lUT);
        } else {
            int n = this.getChannelIndex();
            double d = this.lut[n].min;
            double d2 = this.lut[n].max;
            this.lut[n] = lUT;
            this.lut[n].min = d;
            this.lut[n].max = d2;
            if (this.mode == 1 && this.cip != null && n < this.cip.length) {
                this.cip[n].setColorModel(this.lut[n]);
                this.imageSource = null;
                this.newPixels = true;
                this.img = null;
            }
            this.currentChannel = -1;
            if (!IJ.isMacro()) {
                ContrastAdjuster.update();
            }
        }
        this.customLuts = true;
    }

    public void setChannelLut(LUT lUT, int n) {
        int n2 = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(n2);
        }
        if (n < 1 || n > this.lut.length) {
            throw new IllegalArgumentException("Channel out of range");
        }
        this.lut[n - 1] = (LUT)lUT.clone();
        this.cip = null;
    }

    public void setChannelColorModel(IndexColorModel indexColorModel) {
        this.setChannelLut(new LUT(indexColorModel, 0.0, 0.0));
    }

    public void setDisplayRange(double d, double d2) {
        this.ip.setMinAndMax(d, d2);
        int n = this.getChannelIndex();
        this.lut[n].min = d;
        this.lut[n].max = d2;
    }

    public double getDisplayRangeMin() {
        return this.lut[this.getChannelIndex()].min;
    }

    public double getDisplayRangeMax() {
        return this.lut[this.getChannelIndex()].max;
    }

    public void resetDisplayRange() {
        this.ip.resetMinAndMax();
        int n = this.getChannelIndex();
        this.lut[n].min = this.ip.getMin();
        this.lut[n].max = this.ip.getMax();
    }

    public boolean hasCustomLuts() {
        return this.customLuts && this.mode != 3;
    }

    public void setChannelsUpdated() {
        this.channelsUpdated = true;
    }

    public ImagePlus[] splitChannels(boolean bl) {
        return RGBStackSplitter.splitChannelsToArray(this, bl);
    }
}

