% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_RIA_images.R
\encoding{UTF-8}
\name{merge_RIA_images}
\alias{merge_RIA_images}
\title{Merges multiple loaded images into one volume}
\usage{
merge_RIA_images(RIA_data_in, crop_in = TRUE, verbose_in = TRUE)
}
\arguments{
\item{RIA_data_in}{List of Multiple \emph{RIA_images}.}

\item{crop_in}{logical, indicating whether to crop the merged image to smallest bounding box.}

\item{verbose_in}{logical indicating whether to print detailed information.
Most prints can also be suppressed using the \code{\link{suppressMessages}} function.}
}
\value{
\emph{RIA_image} containing the merged volume with updated log and header data
}
\description{
Merges multiple \emph{RIA_image} class objects loaded using any of the load functions.
All images need to have the same dimensions. Further, during loading the images should not be cropped
to assure that the orientation and position of the data is maintained. Data of the new combined image is updated sequentially,
using data from the \emph{data$orig} slot, that is only parts of the image that do not have data
(which are converted to NA during the load process) are updated in the order of provided \emph{RIA_images}. If multiple images
contain data in for the same element, the first value is used in the new image. Data in the \emph{data$log} slot
is updated based on the new combined image, while data in the \emph{data$header} slot is copied from the first provided image.
}
\examples{
\dontrun{
#Load multiple images and combine them
d1 <- load_nifti(ABC_p1.nii.gz, crop_in = FALSE)
d2 <- load_nifti(ABC_p2.nii.gz, crop_in = FALSE)
d  <- merge_RIA(list(d1, d2))
}

}
\references{
Márton KOLOSSVÁRY et al.
Radiomic Features Are Superior to Conventional Quantitative Computed Tomographic
Metrics to Identify Coronary Plaques With Napkin-Ring Sign
Circulation: Cardiovascular Imaging (2017).
DOI: 10.1161/circimaging.117.006843
\url{https://pubmed.ncbi.nlm.nih.gov/29233836/}

Márton KOLOSSVÁRY et al.
Cardiac Computed Tomography Radiomics: A Comprehensive Review on Radiomic Techniques.
Journal of Thoracic Imaging (2018).
DOI: 10.1097/RTI.0000000000000268
\url{https://pubmed.ncbi.nlm.nih.gov/28346329/}
}
